/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.util.Util;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class FloorCakeCreamProjectile
extends BaseProjectile
implements GeoEntity {
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(FloorCakeCreamProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<String> ARMOR_NAME = SynchedEntityData.m_135353_(FloorCakeCreamProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public FloorCakeCreamProjectile(EntityType<? extends BaseProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(new Random().nextFloat(1.0f, 2.0f)));
            this.setLifetime(new Random().nextInt(80, 180));
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        AABB effectArea = new AABB(this.m_20185_() - (double)this.getSize(), this.m_20186_() - 0.5, this.m_20189_() - (double)this.getSize(), this.m_20185_() + (double)this.getSize(), this.m_20186_() + 0.5, this.m_20189_() + (double)this.getSize());
        List entities = this.m_9236_().m_45976_(LivingEntity.class, effectArea);
        for (LivingEntity entity : entities) {
            if (this.m_19749_() != null && !Util.areEntitiesLinked((Entity)entity, (Entity)this)) {
                Vec3 v = entity.m_20184_();
                entity.m_20334_(v.f_82479_ * 0.2, v.f_82480_, v.f_82481_ * 0.2);
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 40, 0));
                continue;
            }
            switch (this.getArmorName()) {
                case "chocolate": {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 80, 0));
                    break;
                }
                case "strawberry": {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 80, 0));
                    break;
                }
                case "vanilla": {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 80, 0));
                    break;
                }
            }
        }
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("ArmorName")) {
            this.setArmorName(pCompound.m_128461_("ArmorName"));
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128359_("ArmorName", this.getArmorName());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(1.2f));
        this.f_19804_.m_135372_(ARMOR_NAME, (Object)"default");
    }

    public float getSize() {
        return ((Float)this.f_19804_.m_135370_(SIZE)).floatValue();
    }

    public void setArmorName(String name) {
        this.f_19804_.m_135381_(ARMOR_NAME, (Object)name);
    }

    public String getArmorName() {
        return (String)this.f_19804_.m_135370_(ARMOR_NAME);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    @Override
    protected int baseLifetime() {
        return 200;
    }
}

