/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.entity.BaseProjectile;
import dev.xylonity.companions.common.entity.projectile.FrogHealProjectile;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.mixin.CompanionsProjectileAccessor;
import dev.xylonity.companions.registry.CompanionsParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BloodSlashProjectile
extends FrogHealProjectile {
    public BloodSlashProjectile(EntityType<? extends BaseProjectile> type, Level level) {
        super(type, level);
    }

    @Override
    public float getDefaultSpeed() {
        return (float)CompanionsConfig.BLOOD_SLASH_SPEED;
    }

    @Override
    public float getDefaultLerp() {
        return 0.0f;
    }

    @Override
    public void spawnRibbon() {
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_ && (this.f_19797_ % 20 == 0 || this.f_19797_ == 1)) {
            this.spawnSidedRibbon();
        }
    }

    private void spawnSidedRibbon() {
        Vec3 dir = this.m_20184_().m_82541_();
        if (dir.m_82556_() < 1.0E-6) {
            return;
        }
        Vec3 perp = new Vec3(-dir.f_82481_, 0.0, dir.f_82479_).m_82541_().m_82490_(1.5);
        double y = this.m_20186_();
        Vec3 left = new Vec3(this.m_20185_(), y, this.m_20189_()).m_82546_(perp);
        Companions.PROXY.spawnSidedRibbonTrail((Entity)this, this.m_9236_(), left.f_82479_, left.f_82480_, left.f_82481_, 0.5686275f, 0.078431375f, 0.078431375f, 0.0f, 0.1725f, 0);
        Vec3 right = new Vec3(this.m_20185_(), y, this.m_20189_()).m_82549_(perp);
        Companions.PROXY.spawnSidedRibbonTrail((Entity)this, this.m_9236_(), right.f_82479_, right.f_82480_, right.f_82481_, 0.5686275f, 0.078431375f, 0.078431375f, 0.0f, 0.1725f, 1);
    }

    @Override
    protected boolean m_5603_(@NotNull Entity pTarget) {
        if (Util.areEntitiesLinked((Entity)this, pTarget)) {
            return false;
        }
        if (!pTarget.m_271807_()) {
            return false;
        }
        Entity entity = this.m_19749_();
        return entity == null || ((CompanionsProjectileAccessor)((Object)this)).getLeftOwner() || !entity.m_20365_(pTarget);
    }

    @Override
    public void spawnParticles() {
    }

    @Override
    protected void m_5790_(@NotNull EntityHitResult pResult) {
        LivingEntity entity;
        Entity e = pResult.m_82443_();
        if (e instanceof LivingEntity && !Util.areEntitiesLinked((Entity)this, (Entity)(entity = (LivingEntity)e))) {
            entity.m_6469_(this.m_269291_().m_269425_(), (float)CompanionsConfig.BLOOD_SLASH_DAMAGE);
        }
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    @Override
    public void m_142687_(@NotNull Entity.RemovalReason pReason) {
        if (!this.m_9236_().f_46443_) {
            this.spawnRemoveParticles();
            this.m_9236_().m_247517_(null, this.m_20183_(), SoundEvents.f_144245_, SoundSource.NEUTRAL);
        }
        super.m_142687_(pReason);
    }

    private void spawnRemoveParticles() {
        for (int i = 0; i < 15; ++i) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * 1.15;
            double dy = (this.f_19796_.m_188500_() - 0.5) * 1.15;
            double dz = (this.f_19796_.m_188500_() - 0.5) * 1.15;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * Math.random(), this.m_20189_(), 1, dx, dy, dz, 0.1);
            if (!(level2.f_46441_.m_188501_() < 0.35f)) continue;
            level2.m_8767_((ParticleOptions)CompanionsParticles.SHADE_SUMMON.get(), this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * Math.random(), this.m_20189_(), 1, dx, dy, dz, 0.1225);
        }
    }

    @Override
    @Nullable
    protected EntityHitResult findHitEntity(Vec3 pStartVec, Vec3 pEndVec) {
        return ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)pStartVec, (Vec3)pEndVec, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(0.5), this::m_5603_);
    }

    protected void m_8060_(@NotNull BlockHitResult pResult) {
        super.m_8060_(pResult);
        this.m_146870_();
    }
}

