/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.companion;

import dev.xylonity.companions.Companions;
import dev.xylonity.companions.common.ai.navigator.FlyingNavigator;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.ai.generic.CompanionsLookAtPlayerGoal;
import dev.xylonity.companions.common.entity.ai.mage.allay.control.GoldenAllayMoveControl;
import dev.xylonity.companions.common.entity.ai.mage.allay.goal.GoldenAllayRandomMoveGoal;
import dev.xylonity.companions.common.entity.companion.SoulMageEntity;
import dev.xylonity.companions.common.entity.projectile.SoulMageBookEntity;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.companions.registry.CompanionsParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GoldenAllayEntity
extends CompanionEntity
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("fly_idle");
    private final RawAnimation FLY = RawAnimation.begin().thenPlay("fly");
    private final RawAnimation LEVITATE = RawAnimation.begin().thenPlay("levitate");
    private final RawAnimation HAT = RawAnimation.begin().thenPlay("hat");
    private final RawAnimation SHIRT = RawAnimation.begin().thenPlay("tshirt");
    private final RawAnimation TRANSFORM = RawAnimation.begin().thenPlay("transform");
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(GoldenAllayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int TRANSFORMATION_ANIMATION_TICKS = 80;
    private static final int HAT_ANIMATION_TICKS = 20;
    private static final int SHIRT_ANIMATION_TICKS = 15;
    private int transformationCounter;
    private int shirtCounter;
    private int hatCounter;

    public GoldenAllayEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new GoldenAllayMoveControl(this);
        this.transformationCounter = -1;
        this.shirtCounter = -1;
        this.hatCounter = -1;
    }

    @Override
    public void m_8119_() {
        this.f_19794_ = true;
        super.m_8119_();
        this.f_19794_ = false;
        this.m_20242_(true);
        if (this.f_19797_ % 20 == 0 && this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)CompanionsParticles.GOLDEN_ALLAY_TRAIL.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.35, 0.35, 0.35);
        }
        if (!this.m_9236_().f_46443_) {
            if (this.getState() == 1 && this.shirtCounter == -1) {
                ++this.shirtCounter;
            }
            if (this.getState() == 3 && this.hatCounter == -1) {
                ++this.hatCounter;
            }
            if (this.getState() == 5 && this.transformationCounter == -1) {
                ++this.transformationCounter;
            }
            if (this.shirtCounter != -1) {
                ++this.shirtCounter;
            }
            if (this.hatCounter != -1) {
                ++this.hatCounter;
            }
            if (this.transformationCounter != -1) {
                ++this.transformationCounter;
            }
            if (this.shirtCounter == 15) {
                this.cycleState();
                this.generatePoofParticles();
                this.shirtCounter = -1;
            }
            if (this.hatCounter == 20) {
                this.cycleState();
                this.generatePoofParticles();
                this.hatCounter = -1;
            }
            if (this.transformationCounter == 80) {
                SoulMageEntity mage = (SoulMageEntity)((EntityType)CompanionsEntities.SOUL_MAGE.get()).m_20615_(this.m_9236_());
                if (mage != null) {
                    mage.m_20219_(this.m_20182_());
                    LivingEntity livingEntity = this.m_269323_();
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        mage.tameInteraction(player);
                    } else if (this.m_21805_() != null) {
                        mage.m_21816_(this.m_21805_());
                    }
                    this.m_9236_().m_7967_((Entity)mage);
                    SoulMageBookEntity book = (SoulMageBookEntity)((EntityType)CompanionsEntities.SOUL_MAGE_BOOK.get()).m_20615_(this.m_9236_());
                    if (book != null) {
                        book.m_20219_(this.m_20182_());
                        book.m_5602_((Entity)mage);
                        this.m_9236_().m_7967_((Entity)book);
                    }
                }
                this.generatePoofParticles();
                this.m_146870_();
            }
        }
        if (this.m_9236_().f_46443_) {
            Companions.PROXY.spawnGoldenAllayRibbonTrail((Entity)this, this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, 1.0f, 0.627451f, 0.0f, 0.1225f);
        }
    }

    private void generatePoofParticles() {
        for (int i = 0; i < 30; ++i) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            double dy = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            double dz = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20182_().f_82479_, this.m_20186_() + (double)this.m_20206_() * Math.random(), this.m_20182_().f_82481_, 1, dx, dy, dz, 0.1);
        }
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22277_, 35.0).m_22265_();
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        FlyingNavigator navigation = new FlyingNavigator((Mob)this, this.m_9236_());
        navigation.m_26440_(true);
        navigation.m_26443_(true);
        return navigation;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new GoldenAllayRandomMoveGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Monster.class, 6.0f, (double)0.6f, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new CompanionsLookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_215675_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_215672_;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_215671_;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)0);
    }

    public int getState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public void setState(int state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("State")) {
            this.setState(pCompound.m_128451_("State"));
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("State", this.getState());
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (this.getState() == 1 || this.getState() == 3 || this.getState() == 5) {
            return InteractionResult.PASS;
        }
        if (pPlayer.m_20148_().equals(this.m_21805_()) || this.m_21805_() == null) {
            ItemStack stack = pPlayer.m_21120_(pHand);
            return switch (this.getState()) {
                case 0 -> this.giveFirstItem(pPlayer, pHand, stack);
                case 2 -> this.giveSecondItem(pPlayer, pHand, stack);
                default -> this.giveThirdItem(pPlayer, pHand, stack);
            };
        }
        return super.m_6071_(pPlayer, pHand);
    }

    private InteractionResult giveFirstItem(Player pPlayer, InteractionHand pHand, ItemStack stack) {
        if (stack.m_41720_() == CompanionsItems.MAGE_COAT.get()) {
            return this.handleGoodInteraction(pPlayer, pHand, stack, "mage_coat_consumed");
        }
        return this.handleBadInteraction(pPlayer, pHand, stack, "requires_mage_coat");
    }

    private InteractionResult giveSecondItem(Player pPlayer, InteractionHand pHand, ItemStack stack) {
        if (stack.m_41720_() == CompanionsItems.MAGE_HAT.get()) {
            return this.handleGoodInteraction(pPlayer, pHand, stack, "mage_hat_consumed");
        }
        return this.handleBadInteraction(pPlayer, pHand, stack, "requires_hat_coat");
    }

    private InteractionResult giveThirdItem(Player pPlayer, InteractionHand pHand, ItemStack stack) {
        if (stack.m_41720_() == CompanionsItems.MAGE_STAFF.get()) {
            return this.handleGoodInteraction(pPlayer, pHand, stack, "mage_staff_consumed");
        }
        return this.handleBadInteraction(pPlayer, pHand, stack, "requires_staff_coat");
    }

    private InteractionResult handleGoodInteraction(Player pPlayer, InteractionHand pHand, ItemStack stack, String translationPrefix) {
        if (this.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!pPlayer.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        this.cycleState();
        if (this.m_21805_() == null) {
            this.m_21816_(pPlayer.m_20148_());
        }
        pPlayer.m_5661_((Component)Component.m_237115_((String)("golden_allay.companions.client_message." + translationPrefix)), true);
        pPlayer.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12275_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult handleBadInteraction(Player pPlayer, InteractionHand pHand, ItemStack stack, String translationPrefix) {
        pPlayer.m_5661_((Component)Component.m_237115_((String)("golden_allay.companions.client_message." + translationPrefix)), true);
        pPlayer.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12507_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        return InteractionResult.PASS;
    }

    public static boolean checkGoldenAllaySpawnRules(EntityType<GoldenAllayEntity> allay, ServerLevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return GoldenAllayEntity.isDarkEnoughToSpawn(pLevel, pPos, pRandom);
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor level, BlockPos pos, RandomSource random) {
        if (level.m_45517_(LightLayer.SKY, pos) > random.m_188503_(32)) {
            return false;
        }
        DimensionType dimensionType = level.m_6042_();
        int i = dimensionType.m_223570_();
        if (i < 15 && level.m_45517_(LightLayer.BLOCK, pos) > i) {
            return false;
        }
        int j = level.m_6018_().m_46470_() ? level.m_46849_(pos, 10) : level.m_46803_(pos);
        return j <= dimensionType.m_223569_().m_214085_(random);
    }

    @Override
    protected boolean canThisCompanionWork() {
        return false;
    }

    @Override
    protected int sitAnimationsAmount() {
        return 0;
    }

    @Override
    protected boolean shouldKeepChunkLoaded() {
        return false;
    }

    public void cycleState() {
        this.f_19804_.m_135381_(STATE, (Object)(this.getState() + 1));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "levitateController", this::levitatePredicate)});
    }

    private <T extends GeoAnimatable> PlayState levitatePredicate(AnimationState<T> event) {
        event.getController().setAnimation(this.LEVITATE);
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.getState() == 5) {
            event.getController().setAnimation(this.TRANSFORM);
        } else if (this.getState() == 3) {
            event.getController().setAnimation(this.HAT);
        } else if (this.getState() == 1) {
            event.getController().setAnimation(this.SHIRT);
        } else if (event.isMoving()) {
            event.getController().setAnimation(this.FLY);
        } else {
            event.getController().setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

