/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.pontiff;

import dev.xylonity.companions.common.entity.hostile.SacredPontiffEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractSacredPontiffAttackGoal
extends Goal {
    protected final SacredPontiffEntity pontiff;
    private final int attackDuration;
    private final int minCooldown;
    private final int maxCooldown;
    protected int attackTicks;
    protected int nextUseTick;
    protected boolean started;

    public AbstractSacredPontiffAttackGoal(SacredPontiffEntity pontiff, int attackDuration, int minCd, int maxCd) {
        this.pontiff = pontiff;
        this.attackDuration = attackDuration;
        this.minCooldown = minCd;
        this.maxCooldown = maxCd;
        this.nextUseTick = -1;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.pontiff.shouldAttack()) {
            return false;
        }
        if (this.pontiff.getState() != this.attackState()) {
            return false;
        }
        if (this.pontiff.getAttackType() != 0) {
            return false;
        }
        if (this.pontiff.m_5448_() == null) {
            return false;
        }
        if (this.nextUseTick < 0) {
            this.nextUseTick = this.pontiff.f_19797_ + this.minCooldown + this.pontiff.m_217043_().m_188503_(this.maxCooldown - this.minCooldown + 1);
            return false;
        }
        return this.pontiff.f_19797_ >= this.nextUseTick;
    }

    public boolean m_8045_() {
        return this.started && this.attackTicks < this.attackDuration;
    }

    public void m_8056_() {
        this.attackTicks = 0;
        this.started = true;
        this.pontiff.setAttackType(this.getAttackType());
    }

    public void m_8041_() {
        this.started = false;
        this.pontiff.setAttackType(0);
        int cd = this.minCooldown + this.pontiff.m_217043_().m_188503_(this.maxCooldown - this.minCooldown + 1);
        this.nextUseTick = this.pontiff.f_19797_ + cd;
    }

    public void m_8037_() {
        LivingEntity target = this.pontiff.m_5448_();
        if (target != null) {
            this.pontiff.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        }
        if (this.attackTicks == this.attackDelay() && target != null && target.m_6084_()) {
            this.performAttack(target);
        }
        ++this.attackTicks;
    }

    public static boolean isEntityInFront(LivingEntity viewer, Entity target, double fov) {
        Vec3 toTarget;
        Vec3 view = viewer.m_20154_().m_82541_();
        double angle = Math.acos(view.m_82526_(toTarget = new Vec3(target.m_20185_(), viewer.m_20186_(), target.m_20189_()).m_82546_(viewer.m_20182_()).m_82541_())) * 57.29577951308232;
        return angle < fov / 2.0;
    }

    public boolean m_183429_() {
        return true;
    }

    protected abstract int getAttackType();

    protected abstract void performAttack(LivingEntity var1);

    protected abstract int attackDelay();

    protected abstract int attackState();
}

