/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.block;

import dev.xylonity.companions.common.blockentity.RespawnTotemBlockEntity;
import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.knightlib.registry.KnightLibParticles;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RespawnTotemBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE_LOWER_N = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)3.0, (double)4.0, (double)4.0, (double)13.0, (double)17.0, (double)12.0), Block.m_49796_((double)3.0, (double)17.0, (double)3.0, (double)13.0, (double)28.0, (double)13.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_UPPER_N = Stream.of(Block.m_49796_((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)-12.0, (double)16.0), Block.m_49796_((double)3.0, (double)-12.0, (double)4.0, (double)13.0, (double)1.0, (double)12.0), Block.m_49796_((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_UPPER_E = Stream.of(Block.m_49796_((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)-12.0, (double)16.0), Block.m_49796_((double)4.0, (double)-12.0, (double)3.0, (double)12.0, (double)1.0, (double)13.0), Block.m_49796_((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_LOWER_E = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)4.0, (double)4.0, (double)3.0, (double)12.0, (double)17.0, (double)13.0), Block.m_49796_((double)3.0, (double)17.0, (double)3.0, (double)13.0, (double)28.0, (double)13.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;

    public RespawnTotemBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public long m_7799_(@NotNull BlockState pState, @NotNull BlockPos pPos) {
        return pState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? pPos.m_121878_() : pPos.m_7495_().m_121878_();
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        Direction d = (Direction)pState.m_61143_((Property)FACING);
        if (d == Direction.NORTH || d == Direction.SOUTH) {
            return pState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? SHAPE_LOWER_N : SHAPE_UPPER_N;
        }
        return pState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? SHAPE_LOWER_E : SHAPE_UPPER_E;
    }

    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        level.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos pos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        if (pos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(pos.m_7494_()).m_60629_(pContext)) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_())).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public boolean m_7898_(@NotNull BlockState pState, @NotNull LevelReader pLevel, @NotNull BlockPos pPos) {
        if (pState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return pPos.m_123342_() < pLevel.m_151558_() - 1;
        }
        BlockState belowState = pLevel.m_8055_(pPos.m_7495_());
        return belowState.m_60713_((Block)this) && belowState.m_61143_(HALF) == DoubleBlockHalf.LOWER;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        Item item = pPlayer.m_21120_(pHand).m_41720_();
        if (item != CompanionsItems.RELIC_GOLD.get() && item != CompanionsItems.OLD_CLOTH.get()) {
            return InteractionResult.PASS;
        }
        BlockPos lowerPos = pState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? pPos : pPos.m_7495_();
        pLevel.m_7731_(lowerPos, Blocks.f_50016_.m_49966_(), 35);
        pLevel.m_7731_(lowerPos.m_7494_(), Blocks.f_50016_.m_49966_(), 35);
        CompanionEntity entity = null;
        if (item == CompanionsItems.RELIC_GOLD.get()) {
            entity = (CompanionEntity)((EntityType)CompanionsEntities.MANKH.get()).m_20615_(pLevel);
        } else if (item == CompanionsItems.OLD_CLOTH.get()) {
            entity = (CompanionEntity)((EntityType)CompanionsEntities.CLOAK.get()).m_20615_(pLevel);
        }
        if (entity != null) {
            entity.m_7678_((double)lowerPos.m_123341_() + 0.5, lowerPos.m_123342_(), (double)lowerPos.m_123343_() + 0.5, pLevel.f_46441_.m_188501_() * 360.0f, 0.0f);
            entity.tameInteraction(pPlayer);
            double dx = pPlayer.m_20185_() - (double)pPos.m_123341_();
            double dy = pPlayer.m_20186_() + (double)pPlayer.m_20192_() - (double)((float)pPos.m_123342_() + entity.m_20192_());
            double dz = pPlayer.m_20189_() - (double)pPos.m_123343_();
            float yaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
            float pitch = (float)(-(Math.atan2(dy, Math.sqrt(dx * dx + dz * dz)) * 57.29577951308232));
            entity.m_146922_(yaw);
            entity.f_20883_ = yaw;
            entity.f_20884_ = yaw;
            entity.f_20885_ = yaw;
            entity.f_20886_ = yaw;
            entity.m_146926_(pitch);
            entity.f_19860_ = pitch;
            pLevel.m_7967_((Entity)entity);
        }
        for (int i = 0; i < 20; ++i) {
            double dx = (pLevel.f_46441_.m_188500_() - 0.5) * 1.25;
            double dy = (pLevel.f_46441_.m_188500_() - 0.5) * 1.25;
            double dz = (pLevel.f_46441_.m_188500_() - 0.5) * 1.25;
            if (!(pLevel instanceof ServerLevel)) continue;
            ServerLevel level = (ServerLevel)pLevel;
            if (level.f_46441_.m_188501_() < 0.35f) {
                level.m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + Math.random() * 2.0, (double)pPos.m_123343_() + 0.5, 1, dx, dy, dz, 0.1);
            }
            if (!(level.f_46441_.m_188501_() < 0.65f)) continue;
            level.m_8767_((ParticleOptions)((SimpleParticleType)KnightLibParticles.STARSET.get()), (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + Math.random() * 2.0, (double)pPos.m_123343_() + 0.5, 1, dx, dy, dz, 0.1);
        }
        pLevel.m_5594_(null, lowerPos, SoundEvents.f_11868_, SoundSource.BLOCKS, 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState pState, @NotNull Direction pDirection, @NotNull BlockState pNeighborState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pPos, @NotNull BlockPos pNeighborPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)pState.m_61143_(HALF);
        if (pDirection.m_122434_() == Direction.Axis.Y) {
            if (half == DoubleBlockHalf.LOWER && pDirection == Direction.UP) {
                return pNeighborState.m_60713_((Block)this) && pNeighborState.m_61143_(HALF) == DoubleBlockHalf.UPPER ? pState : Blocks.f_50016_.m_49966_();
            }
            if (half == DoubleBlockHalf.UPPER && pDirection == Direction.DOWN) {
                return pNeighborState.m_60713_((Block)this) && pNeighborState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? pState : Blocks.f_50016_.m_49966_();
            }
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    public void m_5707_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull Player pPlayer) {
        if (!pLevel.f_46443_) {
            if (pPlayer.m_7500_()) {
                RespawnTotemBlock.preventCreativeTabDestroy(pLevel, pPos, pState, pPlayer);
            } else {
                BlockPos oPos = pState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? pPos.m_7494_() : pPos.m_7495_();
                BlockState oState = pLevel.m_8055_(oPos);
                if (oState.m_60713_((Block)this)) {
                    pLevel.m_7731_(oPos, Blocks.f_50016_.m_49966_(), 35);
                    pLevel.m_5898_(pPlayer, 2001, oPos, Block.m_49956_((BlockState)oState));
                }
                RespawnTotemBlock.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)this));
            }
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public static void preventCreativeTabDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockPos lowerPos;
        BlockState lowerState;
        if (pState.m_61143_(HALF) == DoubleBlockHalf.UPPER && (lowerState = pLevel.m_8055_(lowerPos = pPos.m_7495_())).m_60713_(pState.m_60734_()) && lowerState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            pLevel.m_7731_(lowerPos, Blocks.f_50016_.m_49966_(), 35);
            pLevel.m_5898_(pPlayer, 2001, lowerPos, Block.m_49956_((BlockState)lowerState));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, LIT, HALF});
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? ((BlockEntityType)CompanionsBlockEntities.RESPAWN_TOTEM.get()).m_155264_(pos, state) : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        return pState.m_61143_(HALF) == DoubleBlockHalf.LOWER && pBlockEntityType == CompanionsBlockEntities.RESPAWN_TOTEM.get() ? RespawnTotemBlockEntity::tick : null;
    }

    @Nullable
    public BlockEntity getMultiblockBlockEntity(Level level, BlockPos pos, BlockState state) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return level.m_7702_(pos);
        }
        BlockPos lowerPos = pos.m_7495_();
        BlockState lowerState = level.m_8055_(lowerPos);
        if (lowerState.m_60713_((Block)this) && lowerState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return level.m_7702_(lowerPos);
        }
        return null;
    }

    public void updateLitState(Level level, BlockPos pos, BlockState state, boolean lit) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(lit)), 3);
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            BlockPos lowerPos = pos.m_7495_();
            BlockState lowerState = level.m_8055_(lowerPos);
            if (lowerState.m_60713_((Block)this)) {
                level.m_7731_(lowerPos, (BlockState)lowerState.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(lit)), 3);
            }
        } else {
            BlockPos upperPos = pos.m_7494_();
            BlockState upperState = level.m_8055_(upperPos);
            if (upperState.m_60713_((Block)this)) {
                level.m_7731_(upperPos, (BlockState)upperState.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(lit)), 3);
            }
        }
    }
}

