/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.forge.services;

import com.natamus.collective_common_forge.services.helpers.ToolFunctionsHelper;
import java.util.Set;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class ForgeToolFunctionsHelper
implements ToolFunctionsHelper {
    public static final ToolAction LIGHT_CAMPFIRE = ToolAction.get((String)"light_campfire");

    @Override
    public boolean isTool(ItemStack itemstack) {
        return this.isPickaxe(itemstack) || this.isAxe(itemstack) || this.isShovel(itemstack) || this.isHoe(itemstack) || this.isShears(itemstack);
    }

    @Override
    public boolean isSword(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof SwordItem || itemStack.m_204117_(ItemTags.f_271388_) || ForgeToolFunctionsHelper.canPerformOneOfActions(itemStack, ToolActions.DEFAULT_SWORD_ACTIONS);
    }

    @Override
    public boolean isShield(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof ShieldItem || ForgeToolFunctionsHelper.canPerformOneOfActions(itemStack, ToolActions.DEFAULT_SHIELD_ACTIONS);
    }

    @Override
    public boolean isPickaxe(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof PickaxeItem || itemStack.m_204117_(ItemTags.f_271360_) || ForgeToolFunctionsHelper.canPerformOneOfActions(itemStack, ToolActions.DEFAULT_PICKAXE_ACTIONS);
    }

    @Override
    public boolean isAxe(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof AxeItem || itemStack.m_204117_(ItemTags.f_271207_) || ForgeToolFunctionsHelper.canPerformOneOfActions(itemStack, ToolActions.DEFAULT_AXE_ACTIONS);
    }

    @Override
    public boolean isShovel(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof ShovelItem || itemStack.m_204117_(ItemTags.f_271138_) || ForgeToolFunctionsHelper.canPerformOneOfActions(itemStack, ToolActions.DEFAULT_SHOVEL_ACTIONS);
    }

    @Override
    public boolean isHoe(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof HoeItem || itemStack.m_204117_(ItemTags.f_271298_) || ForgeToolFunctionsHelper.canPerformOneOfActions(itemStack, ToolActions.DEFAULT_HOE_ACTIONS);
    }

    @Override
    public boolean isShears(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof ShearsItem || ForgeToolFunctionsHelper.canPerformOneOfActions(itemStack, ToolActions.DEFAULT_SHEARS_ACTIONS);
    }

    @Override
    public boolean isFlintAndSteel(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof FlintAndSteelItem || itemStack.canPerformAction(LIGHT_CAMPFIRE);
    }

    private static boolean canPerformOneOfActions(ItemStack itemStack, Set<ToolAction> toolActions) {
        for (ToolAction toolAction : toolActions) {
            if (!itemStack.canPerformAction(toolAction)) continue;
            return true;
        }
        return false;
    }
}

