/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.network.packet;

import io.github.mortuusars.chalk.Chalk;
import io.github.mortuusars.chalk.block.ChalkMarkBlock;
import io.github.mortuusars.chalk.core.IDrawingTool;
import io.github.mortuusars.chalk.utils.MarkDrawHelper;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public record ServerboundDrawMarkPacket(int color, CompoundTag blockStateNBT, BlockPos markBlockPos, InteractionHand drawingHand) {
    public static ServerboundDrawMarkPacket fromBuffer(FriendlyByteBuf buffer) {
        return new ServerboundDrawMarkPacket(buffer.readInt(), buffer.m_130261_(), buffer.m_130135_(), (InteractionHand)buffer.m_130066_(InteractionHand.class));
    }

    public void toBuffer(FriendlyByteBuf buffer) {
        buffer.writeInt(this.color);
        buffer.m_130079_(this.blockStateNBT);
        buffer.m_130064_(this.markBlockPos);
        buffer.m_130068_((Enum)this.drawingHand);
    }

    public boolean handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        @Nullable ServerPlayer player = context.getSender();
        if (player == null) {
            Chalk.LOGGER.error("DrawMarkPacket cannot be handled: player was null.");
            return false;
        }
        ItemStack itemInHand = player.m_21120_(this.drawingHand);
        if (!(itemInHand.m_41720_() instanceof IDrawingTool)) {
            Chalk.LOGGER.error("Item in player's hand cannot draw a mark.");
            return true;
        }
        Level level = player.m_9236_();
        BlockState existingState = level.m_8055_(this.markBlockPos);
        if (!existingState.m_60795_() && !(existingState.m_60734_() instanceof ChalkMarkBlock)) {
            Chalk.LOGGER.error("Cannot draw at this block.");
            return true;
        }
        BlockState blockState = NbtUtils.m_247651_((HolderGetter)level.m_246945_(Registries.f_256747_), (CompoundTag)this.blockStateNBT);
        return MarkDrawHelper.draw((Player)player, level, this.markBlockPos, blockState, this.color, this.drawingHand);
    }
}

