/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.chalk.advancement;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.MapColor;

public class MapColorPredicate {
    public static final String JSON_PROPERTY = "materialColorPredicate";
    public static final MapColorPredicate ANY = new MapColorPredicate(Collections.emptyList());
    private final List<MapColor> colors;

    public MapColorPredicate(List<MapColor> colors) {
        this.colors = colors;
    }

    public boolean matches(MapColor color) {
        if (this.colors.size() == 0) {
            return true;
        }
        for (MapColor dyeColor : this.colors) {
            if (!color.equals(dyeColor)) continue;
            return true;
        }
        return false;
    }

    public static MapColorPredicate fromJson(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return ANY;
        }
        JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)json, (String)JSON_PROPERTY);
        JsonArray colorsList = jsonobject.get("colors").getAsJsonArray();
        ArrayList<MapColor> colors = new ArrayList<MapColor>();
        for (JsonElement element : colorsList) {
            colors.add(MapColor.m_284175_((int)element.getAsInt()));
        }
        return new MapColorPredicate(colors);
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonArray colorsList = new JsonArray();
        for (MapColor color : this.colors) {
            colorsList.add((Number)color.f_283805_);
        }
        JsonObject jsonobject = new JsonObject();
        jsonobject.add("colors", (JsonElement)colorsList);
        return jsonobject;
    }
}

