/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.events;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesBlockEntityTypes;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.structure_gel.core.registry.SGRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.MissingMappingsEvent;

public class SkiesMappingChanges {
    @SubscribeEvent
    protected static void blockMapping(MissingMappingsEvent event) {
        if (event.getKey().equals((Object)Registries.f_256747_)) {
            HashMap<ResourceLocation, Block> blocks = new HashMap<ResourceLocation, Block>(){
                private static final long serialVersionUID = 4431458256986938918L;
                {
                    this.put("poison_slab", SkiesBlocks.poison_stone_slab);
                    this.put("poison_stairs", SkiesBlocks.poison_stone_stairs);
                    this.put("poison_wall", SkiesBlocks.poison_stonebrick_wall);
                    this.put("glowing_poison_slab", SkiesBlocks.glowing_poison_stone_slab);
                    this.put("glowing_poison_stairs", SkiesBlocks.glowing_poison_stone_stairs);
                    this.put("glowing_poison_wall", SkiesBlocks.poison_stonebrick_wall);
                    this.put("nature_slab", SkiesBlocks.nature_stone_slab);
                    this.put("nature_stairs", SkiesBlocks.nature_stone_stairs);
                    this.put("nature_wall", SkiesBlocks.nature_stonebrick_wall);
                    this.put("glowing_nature_slab", SkiesBlocks.glowing_nature_stone_slab);
                    this.put("glowing_nature_stairs", SkiesBlocks.glowing_nature_stone_stairs);
                    this.put("glowing_nature_wall", SkiesBlocks.glowing_nature_stonebrick_wall);
                    this.put("structure_filler", (Block)SGRegistry.Blocks.RED_GEL.get());
                    this.put("corn", SkiesBlocks.pine_fruits);
                    this.put("cabbage", SkiesBlocks.winter_leaves);
                    this.put("raspberry_bush", SkiesBlocks.brewberry_bush);
                    this.put("potted_raspberry_bush", SkiesBlocks.potted_brewberry_bush);
                    this.put("tomatoes", SkiesBlocks.scalefruits);
                    this.put("green_beans", SkiesBlocks.fiery_beans);
                    this.put("peanuts", SkiesBlocks.solnuts);
                    this.put("nectarine_fruit", SkiesBlocks.crescent_fruit);
                    this.put("nectarine_leaves", (Block)SkiesBlocks.crescent_fruit_leaves);
                    this.put("nectarine_sapling", SkiesBlocks.crescent_fruit_sapling);
                    this.put("potted_nectarine_sapling", SkiesBlocks.potted_crescent_fruit_sapling);
                    this.put("turquoise_block", SkiesBlocks.aquite_block);
                    this.put("everbright_turquoise_ore", (Block)SkiesBlocks.everbright_aquite_ore);
                    this.put("everdawn_turquoise_ore", (Block)SkiesBlocks.everdawn_aquite_ore);
                    this.put("raw_moonstone", SkiesBlocks.vitreous_moonstone);
                    this.put("cherry_pie", SkiesBlocks.comet_berry_pie);
                    this.put("cherry_log", SkiesBlocks.comet_log);
                    this.put("cherry_wood", SkiesBlocks.comet_wood);
                    this.put("stripped_cherry_log", SkiesBlocks.stripped_comet_log);
                    this.put("stripped_cherry_wood", SkiesBlocks.stripped_comet_wood);
                    this.put("cherry_planks", SkiesBlocks.comet_planks);
                    this.put("cherry_stairs", SkiesBlocks.comet_stairs);
                    this.put("cherry_slab", SkiesBlocks.comet_slab);
                    this.put("cherry_fence", SkiesBlocks.comet_fence);
                    this.put("cherry_fence_gate", SkiesBlocks.comet_fence_gate);
                    this.put("cherry_door", SkiesBlocks.comet_door);
                    this.put("cherry_trapdoor", SkiesBlocks.comet_trapdoor);
                    this.put("cherry_pressure_plate", SkiesBlocks.comet_pressure_plate);
                    this.put("cherry_button", SkiesBlocks.comet_button);
                    this.put("cherry_ladder", SkiesBlocks.comet_ladder);
                    this.put("cherry_bookshelf", SkiesBlocks.comet_bookshelf);
                    this.put("cherry_chest", SkiesBlocks.comet_chest);
                    this.put("cherry_sign", SkiesBlocks.comet_sign);
                    this.put("cherry_wall_sign", SkiesBlocks.comet_wall_sign);
                    this.put("cherry_crafting_table", SkiesBlocks.comet_crafting_table);
                    this.put("cherry_leaves", (Block)SkiesBlocks.comet_leaves);
                    this.put("cherry_grass", SkiesBlocks.comet_grass);
                    this.put("turquoise_cherry_grass_block", SkiesBlocks.turquoise_comet_grass_block);
                    this.put("lunar_cherry_grass_block", SkiesBlocks.lunar_comet_grass_block);
                    this.put("cherry_sapling", SkiesBlocks.comet_sapling);
                    this.put("potted_cherry_sapling", SkiesBlocks.potted_comet_sapling);
                }

                @Override
                public void put(String key, Block value) {
                    this.put(BlueSkies.locate(key), value);
                }
            };
            SkiesMappingChanges.handleRemap(event, Registries.f_256747_, "Found missing block mappings. Attempting to replace them...", m -> SkiesMappingChanges.remap(event, m, blocks));
        } else if (event.getKey().equals((Object)Registries.f_256913_)) {
            HashMap<ResourceLocation, Item> items = new HashMap<ResourceLocation, Item>(){
                private static final long serialVersionUID = -7164982842679092263L;
                {
                    this.put("poison_slab", SkiesBlocks.poison_stone_slab);
                    this.put("poison_stairs", SkiesBlocks.poison_stone_stairs);
                    this.put("poison_wall", SkiesBlocks.poison_stonebrick_wall);
                    this.put("glowing_poison_slab", SkiesBlocks.glowing_poison_stone_slab);
                    this.put("glowing_poison_stairs", SkiesBlocks.glowing_poison_stone_stairs);
                    this.put("glowing_poison_wall", SkiesBlocks.poison_stonebrick_wall);
                    this.put("nature_slab", SkiesBlocks.nature_stone_slab);
                    this.put("nature_stairs", SkiesBlocks.nature_stone_stairs);
                    this.put("nature_wall", SkiesBlocks.nature_stonebrick_wall);
                    this.put("glowing_nature_slab", SkiesBlocks.glowing_nature_stone_slab);
                    this.put("glowing_nature_stairs", SkiesBlocks.glowing_nature_stone_stairs);
                    this.put("glowing_nature_wall", SkiesBlocks.glowing_nature_stonebrick_wall);
                    this.put("structure_filler", (Block)SGRegistry.Blocks.RED_GEL.get());
                    this.put("corn", SkiesItems.pine_fruit);
                    this.put("cabbage", SkiesItems.winter_leaves);
                    this.put("raspberry_bush", SkiesBlocks.brewberry_bush);
                    this.put("raspberry", SkiesItems.brewberry);
                    this.put("pink_raspberry", SkiesItems.pink_brewberry);
                    this.put("black_raspberry", SkiesItems.black_brewberry);
                    this.put("tomato", SkiesItems.scalefruit);
                    this.put("green_bean", SkiesItems.fiery_beans);
                    this.put("peanut", SkiesItems.solnut);
                    this.put("nectarine", SkiesItems.crescent_fruit);
                    this.put("nectarine_leaves", (Block)SkiesBlocks.crescent_fruit_leaves);
                    this.put("nectarine_sapling", SkiesBlocks.crescent_fruit_sapling);
                    this.put("corn_seeds", SkiesItems.pine_fruit_seeds);
                    this.put("cabbage_seeds", SkiesItems.winter_leaf_seeds);
                    this.put("tomato_seeds", SkiesItems.scalefruit_seeds);
                    this.put("green_bean_seeds", SkiesItems.fiery_bean_seeds);
                    this.put("hellfire_arc", SkiesItems.life_arc);
                    this.put("blue_lore", SkiesItems.blue_journal);
                    this.put("turquoise_gem", SkiesItems.aquite);
                    this.put("turquoise_sword", SkiesItems.aquite_sword);
                    this.put("turquoise_pickaxe", SkiesItems.aquite_pickaxe);
                    this.put("turquoise_axe", SkiesItems.aquite_axe);
                    this.put("turquoise_shovel", SkiesItems.aquite_shovel);
                    this.put("turquoise_hoe", SkiesItems.aquite_hoe);
                    this.put("turquoise_helmet", SkiesItems.aquite_helmet);
                    this.put("turquoise_chestplate", SkiesItems.aquite_chestplate);
                    this.put("turquoise_leggings", SkiesItems.aquite_leggings);
                    this.put("turquoise_boots", SkiesItems.aquite_boots);
                    this.put("mudkipz_sword", SkiesItems.debug_sword);
                    this.put("turquoise_block", SkiesBlocks.aquite_block);
                    this.put("everbright_turquoise_ore", (Block)SkiesBlocks.everbright_aquite_ore);
                    this.put("everdawn_turquoise_ore", (Block)SkiesBlocks.everdawn_aquite_ore);
                    this.put("raw_azulfo_beef", SkiesItems.carabeef);
                    this.put("azulfo_steak", SkiesItems.cooked_carabeef);
                    this.put("raw_venison", SkiesItems.venison);
                    this.put("venison_steak", SkiesItems.cooked_venison);
                    this.put("aquite_gem", SkiesItems.aquite);
                    this.put("cherry_pie", SkiesBlocks.comet_berry_pie);
                    this.put("cherry", SkiesItems.comet_berries);
                    this.put("cherry_log", SkiesBlocks.comet_log);
                    this.put("cherry_wood", SkiesBlocks.comet_wood);
                    this.put("stripped_cherry_log", SkiesBlocks.stripped_comet_log);
                    this.put("stripped_cherry_wood", SkiesBlocks.stripped_comet_wood);
                    this.put("cherry_planks", SkiesBlocks.comet_planks);
                    this.put("cherry_stairs", SkiesBlocks.comet_stairs);
                    this.put("cherry_slab", SkiesBlocks.comet_slab);
                    this.put("cherry_fence", SkiesBlocks.comet_fence);
                    this.put("cherry_fence_gate", SkiesBlocks.comet_fence_gate);
                    this.put("cherry_door", SkiesItems.comet_door);
                    this.put("cherry_trapdoor", SkiesBlocks.comet_trapdoor);
                    this.put("cherry_pressure_plate", SkiesBlocks.comet_pressure_plate);
                    this.put("cherry_button", SkiesBlocks.comet_button);
                    this.put("cherry_ladder", SkiesBlocks.comet_ladder);
                    this.put("cherry_bookshelf", SkiesBlocks.comet_bookshelf);
                    this.put("cherry_chest", SkiesBlocks.comet_chest);
                    this.put("cherry_sign", SkiesBlocks.comet_sign);
                    this.put("cherry_crafting_table", SkiesBlocks.comet_crafting_table);
                    this.put("cherry_stick", SkiesItems.comet_stick);
                    this.put("cherry_axe", SkiesItems.comet_axe);
                    this.put("cherry_pickaxe", SkiesItems.comet_pickaxe);
                    this.put("cherry_shovel", SkiesItems.comet_shovel);
                    this.put("cherry_hoe", SkiesItems.comet_hoe);
                    this.put("cherry_sword", SkiesItems.comet_sword);
                    this.put("cherry_spear", SkiesItems.comet_spear);
                    this.put("cherry_leaves", (Block)SkiesBlocks.comet_leaves);
                    this.put("cherry_grass", SkiesBlocks.comet_grass);
                    this.put("turquoise_cherry_grass_block", SkiesBlocks.turquoise_comet_grass_block);
                    this.put("lunar_cherry_grass_block", SkiesBlocks.lunar_comet_grass_block);
                    this.put("cherry_sapling", SkiesBlocks.comet_sapling);
                }

                @Override
                public void put(String key, Item value) {
                    this.put(BlueSkies.locate(key), value);
                }

                @Override
                public void put(String key, Block value) {
                    this.put(BlueSkies.locate(key), value.m_5456_());
                }
            };
            SkiesMappingChanges.handleRemap(event, Registries.f_256913_, "Found missing item mappings. Attempting to replace them...", m -> SkiesMappingChanges.remap(event, m, items));
        } else if (event.getKey().equals((Object)Registries.f_256922_)) {
            HashMap blockEntities = new HashMap<ResourceLocation, BlockEntityType<?>>(){
                private static final long serialVersionUID = -3030191177151506017L;
                {
                    this.put("cherry_chest", SkiesBlockEntityTypes.COMET_CHEST);
                }

                @Override
                public void put(String key, BlockEntityType<?> value) {
                    this.put(BlueSkies.locate(key), value);
                }
            };
            SkiesMappingChanges.handleRemap(event, Registries.f_256922_, "Found missing block entity mappings. Attempting to replace them...", m -> SkiesMappingChanges.remap(event, m, blockEntities));
        } else if (event.getKey().equals((Object)Registries.f_256840_)) {
            SkiesMappingChanges.handleRemap(event, Registries.f_256840_, "Found missing sound event mappings. Ignoring them, as they do not need to be remapped.", m -> m.ignore());
        }
    }

    private static <T> void handleRemap(MissingMappingsEvent event, ResourceKey<? extends Registry<T>> key, String logMessage, Consumer<? super MissingMappingsEvent.Mapping<T>> action) {
        if (event.getAllMappings(key).stream().filter(m -> m.getKey().m_135827_().equals("blue_skies")).findAny().isPresent()) {
            BlueSkies.LOGGER.warn(logMessage);
            event.getAllMappings(key).stream().filter(m -> m.getKey().m_135827_().equals("blue_skies")).forEach(action);
        }
    }

    private static <T> void remap(MissingMappingsEvent event, MissingMappingsEvent.Mapping<T> mapping, Map<ResourceLocation, T> remappings) {
        ResourceLocation key = mapping.getKey();
        if (remappings.containsKey(key)) {
            mapping.remap(remappings.get(key));
            BlueSkies.LOGGER.warn("Replaced " + key + " with " + remappings.get(key));
        } else {
            mapping.ignore();
            BlueSkies.LOGGER.warn("Could not find a mapping replacement for " + key + ". It was likely intentionally removed in an update.");
        }
    }
}

