/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.passive;

import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.entities.util.base.SkiesMountEntity;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;

public class ReindeerEntity
extends SkiesMountEntity {
    private static final float NATURAL_FESTIVE_CHANCE = 0.4f;
    private static final EntityDataAccessor<Integer> FESTIVE_STATUS = SynchedEntityData.m_135353_(ReindeerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ReindeerEntity(EntityType<? extends ReindeerEntity> type, Level world) {
        super((EntityType<? extends SkiesMountEntity>)SkiesEntityTypes.REINDEER, world);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.getTameItem()}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22279_, (double)0.15f);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData group, CompoundTag nbt) {
        this.setFestiveStatus(this.f_19796_.m_188501_() < 0.4f ? 1 : 0);
        return super.m_6518_(level, difficulty, reason, group, nbt);
    }

    protected SoundEvent m_7515_() {
        return SkiesSounds.ENTITY_REINDEER_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SkiesSounds.ENTITY_REINDEER_HURT;
    }

    protected SoundEvent m_5592_() {
        return SkiesSounds.ENTITY_REINDEER_DEATH;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12035_, 0.15f, 1.0f);
    }

    public int m_8100_() {
        return 460;
    }

    protected float m_6121_() {
        return 1.0f;
    }

    @Override
    public boolean m_6898_(ItemStack stack) {
        return this.isTamed() ? stack.m_41720_() == this.getTameItem() : false;
    }

    public ReindeerEntity createChild(AgeableMob ageable) {
        ReindeerEntity child = new ReindeerEntity((EntityType<? extends ReindeerEntity>)SkiesEntityTypes.REINDEER, this.m_9236_());
        if (BlueSkiesConfig.COMMON.isChristmas() && this.getFestiveStatus() > 0 && ((ReindeerEntity)ageable).getFestiveStatus() > 0) {
            child.setFestiveStatus(2);
        }
        return child;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_6162_() ? this.m_20206_() : 1.5f;
    }

    public double m_6048_() {
        return this.m_6162_() ? 0.3 : 1.0;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!super.m_6071_(player, hand).m_19077_() && itemstack.m_41720_() == this.getTameItem() && !this.isTamed()) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            if (!this.m_9236_().f_46443_) {
                if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    this.playTameEffect(true);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                    this.setTamed(true);
                } else {
                    this.playTameEffect(false);
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            }
            if (player.m_9236_().f_46443_) {
                player.m_9236_().m_5594_(player, player.m_20183_(), SoundEvents.f_11976_, SoundSource.AMBIENT, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return distance > 5.0f ? super.m_142535_(distance - 5.0f, damageMultiplier, source) : false;
    }

    @Override
    public Item getSaddleItem() {
        return Items.f_42450_;
    }

    @Override
    public Item getTameItem() {
        return SkiesItems.pine_fruit;
    }

    @Override
    public int getMaxInventorySlots() {
        return 1;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FESTIVE_STATUS, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("FestiveStatus", this.getFestiveStatus());
    }

    @Override
    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.setFestiveStatus(!compound.m_128441_("FestiveStatus") ? (this.f_19796_.m_188501_() < 0.4f ? 1 : 0) : compound.m_128451_("FestiveStatus"));
    }

    public int getFestiveStatus() {
        return (Integer)this.f_19804_.m_135370_(FESTIVE_STATUS);
    }

    public void setFestiveStatus(int flag) {
        this.f_19804_.m_135381_(FESTIVE_STATUS, (Object)flag);
    }
}

