/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.renders.tile_entities;

import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.client.init.SkiesRenderRefs;
import com.legacy.blue_skies.registries.SkiesBlockEntityTypes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Triple;

@OnlyIn(value=Dist.CLIENT)
public class SkyChestRenderer<T extends BlockEntity>
extends ChestRenderer<T> {
    private static final Map<BlockEntityType<?>, Triple<Material, Material, Material>> CHEST_MATERIALS = new HashMap<BlockEntityType<?>, Triple<Material, Material, Material>>(){
        private static final long serialVersionUID = -5505549653590035348L;
        {
            this.put(SkiesBlockEntityTypes.BLUEBRIGHT_CHEST, Triple.of((Object)SkiesRenderRefs.BLUEBRIGHT_CHEST_LOCATION_LEFT, (Object)SkiesRenderRefs.BLUEBRIGHT_CHEST_LOCATION, (Object)SkiesRenderRefs.BLUEBRIGHT_CHEST_LOCATION_RIGHT));
            this.put(SkiesBlockEntityTypes.STARLIT_CHEST, Triple.of((Object)SkiesRenderRefs.STARLIT_CHEST_LOCATION_LEFT, (Object)SkiesRenderRefs.STARLIT_CHEST_LOCATION, (Object)SkiesRenderRefs.STARLIT_CHEST_LOCATION_RIGHT));
            this.put(SkiesBlockEntityTypes.FROSTBRIGHT_CHEST, Triple.of((Object)SkiesRenderRefs.FROSTBRIGHT_CHEST_LOCATION_LEFT, (Object)SkiesRenderRefs.FROSTBRIGHT_CHEST_LOCATION, (Object)SkiesRenderRefs.FROSTBRIGHT_CHEST_LOCATION_RIGHT));
            this.put(SkiesBlockEntityTypes.LUNAR_CHEST, Triple.of((Object)SkiesRenderRefs.LUNAR_CHEST_LOCATION_LEFT, (Object)SkiesRenderRefs.LUNAR_CHEST_LOCATION, (Object)SkiesRenderRefs.LUNAR_CHEST_LOCATION_RIGHT));
            this.put(SkiesBlockEntityTypes.DUSK_CHEST, Triple.of((Object)SkiesRenderRefs.DUSK_CHEST_LOCATION_LEFT, (Object)SkiesRenderRefs.DUSK_CHEST_LOCATION, (Object)SkiesRenderRefs.DUSK_CHEST_LOCATION_RIGHT));
            this.put(SkiesBlockEntityTypes.MAPLE_CHEST, Triple.of((Object)SkiesRenderRefs.MAPLE_CHEST_LOCATION_LEFT, (Object)SkiesRenderRefs.MAPLE_CHEST_LOCATION, (Object)SkiesRenderRefs.MAPLE_CHEST_LOCATION_RIGHT));
            this.put(SkiesBlockEntityTypes.COMET_CHEST, Triple.of((Object)SkiesRenderRefs.COMET_CHEST_LOCATION_LEFT, (Object)SkiesRenderRefs.COMET_CHEST_LOCATION, (Object)SkiesRenderRefs.COMET_CHEST_LOCATION_RIGHT));
        }
    };

    public SkyChestRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected Material getMaterial(T blockEntity, ChestType chestType) {
        boolean isDouble = chestType != ChestType.SINGLE;
        boolean isLeft = chestType == ChestType.LEFT;
        Triple<Material, Material, Material> matRefs = CHEST_MATERIALS.get(blockEntity.m_58903_());
        Material material = BlueSkiesConfig.COMMON.isChristmas() ? (isDouble ? (isLeft ? Sheets.f_110749_ : Sheets.f_110750_) : Sheets.f_110748_) : (BlueSkiesConfig.COMMON.isHalloween() && !isDouble ? SkiesRenderRefs.PUMPKIN_CHEST_LOCATION : (isDouble ? (isLeft ? (Material)matRefs.getLeft() : (Material)matRefs.getRight()) : (Material)matRefs.getMiddle()));
        return material;
    }
}

