/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.renders.entities.passive;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.client.init.SkiesRenderRefs;
import com.legacy.blue_skies.client.models.entities.passive.ReindeerModel;
import com.legacy.blue_skies.client.renders.entities.layers.EmissiveRenderLayer;
import com.legacy.blue_skies.client.renders.entities.layers.TextureRenderLayer;
import com.legacy.blue_skies.entities.passive.ReindeerEntity;
import com.legacy.blue_skies.entities.util.base.SkiesMountEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ReindeerRenderer<T extends ReindeerEntity>
extends MobRenderer<T, ReindeerModel<T>> {
    private static final ResourceLocation TEXTURE = BlueSkies.locate("textures/entity/reindeer/reindeer.png");
    private static final ResourceLocation TEXTURE_BABY = BlueSkies.locate("textures/entity/reindeer/reindeer_baby.png");
    private static final ResourceLocation TEXTURE_SADDLE = BlueSkies.locate("textures/entity/reindeer/saddle.png");
    private static final ResourceLocation TEXTURE_XMAS = BlueSkies.locate("textures/entity/reindeer/reindeer_xmas.png");
    private static final ResourceLocation TEXTURE_XMAS_ANTLER_GLOW = BlueSkies.locate("textures/entity/reindeer/reindeer_xmas_antler_glow.png");
    private static final ResourceLocation TEXTURE_XMAS_ANTLER_OVERLAY = BlueSkies.locate("textures/entity/reindeer/reindeer_xmas_antler_overlay.png");

    public ReindeerRenderer(EntityRendererProvider.Context context) {
        super(context, new ReindeerModel(context.m_174023_(SkiesRenderRefs.REINDEER)), 0.7f);
        this.m_115326_(new TextureRenderLayer<T, ReindeerModel<T>>((RenderLayerParent)this, (EntityModel)new ReindeerModel(context.m_174023_(SkiesRenderRefs.REINDEER_SADDLE)), TEXTURE_SADDLE){

            @Override
            protected boolean shouldRenderOverlay(T entity) {
                return ((SkiesMountEntity)((Object)entity)).isSaddled();
            }
        });
        this.m_115326_(new TextureRenderLayer<T, ReindeerModel<T>>((RenderLayerParent)this, TEXTURE_XMAS_ANTLER_OVERLAY){

            @Override
            protected boolean shouldRenderOverlay(T entity) {
                int festiveStatus = ((ReindeerEntity)((Object)entity)).getFestiveStatus();
                return (festiveStatus >= 2 || BlueSkiesConfig.COMMON.isChristmas() && festiveStatus >= 1) && !entity.m_6162_();
            }
        });
        this.m_115326_(new EmissiveRenderLayer<T, ReindeerModel<T>>((RenderLayerParent)this, (EntityModel)new ReindeerModel(context.m_174023_(SkiesRenderRefs.REINDEER_XMAS_GLOW)), TEXTURE_XMAS_ANTLER_GLOW){

            @Override
            protected boolean shouldRenderOverlay(T entity) {
                int festiveStatus = ((ReindeerEntity)((Object)entity)).getFestiveStatus();
                return (festiveStatus >= 2 || BlueSkiesConfig.COMMON.isChristmas() && festiveStatus >= 1) && !entity.m_6162_();
            }
        });
    }

    public ResourceLocation getTextureLocation(T entity) {
        if (((ReindeerEntity)((Object)entity)).getFestiveStatus() >= 2) {
            return TEXTURE_XMAS;
        }
        return entity.m_6162_() ? TEXTURE_BABY : TEXTURE;
    }
}

