/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.models.entities.hostile;

import com.legacy.blue_skies.client.SkiesClientUtil;
import com.legacy.blue_skies.entities.hostile.ShrumptyEntity;
import java.util.List;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ShrumptyModel<T extends ShrumptyEntity>
extends ListModel<T> {
    protected final ModelPart body;
    protected final ModelPart cap;
    protected final ModelPart tail;
    protected final ModelPart rightLeg;
    protected final ModelPart leftLeg;

    public ShrumptyModel(ModelPart model) {
        this.body = model.m_171324_("body");
        this.cap = this.body.m_171324_("cap");
        this.tail = this.body.m_171324_("tail");
        this.rightLeg = model.m_171324_("right_leg");
        this.leftLeg = model.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation size) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-6.0f, -4.75f, -6.0f, 12.0f, 5.0f, 12.0f, size), PartPose.m_171419_((float)0.0f, (float)9.75f, (float)0.0f));
        body.m_171599_("cap", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-9.0f, -2.0f, -9.0f, 18.0f, 2.0f, 18.0f, size), PartPose.m_171419_((float)0.0f, (float)-4.75f, (float)0.0f));
        body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(17, 31).m_171488_(0.0f, 0.0f, -2.0f, 0.0f, 12.0f, 7.0f, size), PartPose.m_171419_((float)0.0f, (float)-0.75f, (float)6.0f));
        root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 37).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 14.0f, 4.0f, size), PartPose.m_171419_((float)-4.0f, (float)10.0f, (float)0.0f));
        root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 37).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 14.0f, 4.0f, size), PartPose.m_171419_((float)4.0f, (float)10.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)96, (int)64);
    }

    public Iterable<ModelPart> m_6195_() {
        return List.of(this.body, this.rightLeg, this.leftLeg);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!((ShrumptyEntity)((Object)entityIn)).shouldSpreadLegs) {
            this.rightLeg.m_104227_(-2.0f, 10.0f, 0.0f);
            this.leftLeg.m_104227_(2.0f, 10.0f, 0.0f);
        } else {
            this.leftLeg.m_104227_(4.0f, 10.0f, 0.0f);
            this.rightLeg.m_104227_(-4.0f, 10.0f, 0.0f);
        }
        this.body.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.body.f_104203_ = SkiesClientUtil.lockNum(headPitch * ((float)Math.PI / 180), 0.15f);
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.tail.f_104203_ = 0.1f + limbSwingAmount * 0.8f;
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }
}

