/*
 * Decompiled with CFR 0.152.
 */
package com.worldswanderer.blocksbydimensionblocker;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod(value="blocksbydimensionblocker")
public class BlocksByDimensionBlocker {
    public static final String MODID = "blocksbydimensionblocker";
    private static final Logger LOGGER = LogUtils.getLogger();

    public BlocksByDimensionBlocker() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::onCommonSetup);
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
        Config.load();
    }

    @SubscribeEvent
    public void blockPlaceCancel(BlockEvent.EntityPlaceEvent event) {
        ServerPlayer splayer;
        if (!Config.isLoaded()) {
            return;
        }
        BlockState state = event.getPlacedBlock();
        ServerPlayer player = null;
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        Entity entity = event.getEntity();
        if (Config.isBlockPlacingBlocked(level.m_46472_().m_135782_().toString(), state.m_60734_(), entity instanceof ServerPlayer && (player = (splayer = (ServerPlayer)entity)).m_7500_())) {
            event.setCanceled(true);
            if (player != null) {
                BlocksByDimensionBlocker.updatePlayerHands(player);
            }
        }
    }

    public static void updatePlayerHands(ServerPlayer player) {
        player.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(player.f_36095_.f_38840_, player.f_36095_.m_182425_(), 36 + player.m_150109_().f_35977_, player.m_21205_()));
        player.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(player.f_36095_.f_38840_, player.f_36095_.m_182425_(), 45, player.m_21206_()));
    }

    public static class Config {
        public static final String CONFIG_NAME = "blocksbydimensionblocker-lock_place_blocks.json";
        private static ConfigData data;
        private static boolean isLoaded;
        private static Map<String, DimensionEntry> mappedPlaceListCache;
        private static DimensionEntry unmappedPlaceListCache;

        public static boolean isLoaded() {
            return isLoaded;
        }

        public static void load() {
            data = new ConfigData(FileUtils.loadConfig(CONFIG_NAME, ConfigData.Raw.class));
            mappedPlaceListCache.clear();
            unmappedPlaceListCache = null;
            for (DimensionEntry entry : Config.data.placeList) {
                if (entry.blocks.isEmpty()) {
                    LOGGER.warn("No blocks defined for dimension '{}', skipping", (Object)entry.dimension);
                    continue;
                }
                if (entry.dimension != null) {
                    mappedPlaceListCache.put(entry.dimension, entry);
                    continue;
                }
                if (unmappedPlaceListCache == null) {
                    unmappedPlaceListCache = entry;
                    continue;
                }
                LOGGER.error("Multiple unmapped dimension entries found, only the first one will be used");
            }
            LOGGER.info("Config loaded successfully");
            isLoaded = true;
        }

        public static boolean isBlockPlacingBlocked(String dimension, Block block, boolean isCreativeMode) {
            if (data == null) {
                return false;
            }
            if (isCreativeMode && Config.data.settings.doCreativeModePlayersPlaceBlackListBlocks) {
                return false;
            }
            DimensionEntry placeListData = mappedPlaceListCache.get(dimension);
            if (placeListData != null && placeListData.isBlacklist == placeListData.blocks.stream().anyMatch(be -> be.check(block))) {
                return true;
            }
            return unmappedPlaceListCache != null && Config.unmappedPlaceListCache.isBlacklist == Config.unmappedPlaceListCache.blocks.stream().anyMatch(be -> be.check(block));
        }

        static {
            isLoaded = false;
            mappedPlaceListCache = new HashMap<String, DimensionEntry>();
            unmappedPlaceListCache = null;
        }

        public static class ConfigData {
            public Setting settings = new Setting();
            public List<DimensionEntry> placeList = new ArrayList<DimensionEntry>();

            public ConfigData(Raw raw) {
                this.settings = raw.settings;
                for (DimensionEntry.Raw r : raw.placeList) {
                    this.placeList.add(new DimensionEntry(r));
                }
            }

            public static class Raw {
                public Setting settings = new Setting();
                @SerializedName(value="place_block_list")
                public List<DimensionEntry.Raw> placeList = new ArrayList<DimensionEntry.Raw>();
            }
        }

        public static class DimensionEntry {
            public String dimension;
            public boolean isBlacklist;
            public Set<BlockEntry> blocks = new HashSet<BlockEntry>();

            public DimensionEntry(Raw raw) {
                this.dimension = raw.dimension;
                this.isBlacklist = raw.isBlacklist;
                for (BlockEntry.Raw r : raw.blocks) {
                    this.blocks.add(new BlockEntry(r));
                }
            }

            public static class Raw {
                public String dimension = null;
                @SerializedName(value="is_blacklist")
                public boolean isBlacklist = true;
                public Set<BlockEntry.Raw> blocks = new HashSet<BlockEntry.Raw>();
            }
        }

        public static class Setting {
            @SerializedName(value="creative_place_blacklist")
            public boolean doCreativeModePlayersPlaceBlackListBlocks = true;
            @SerializedName(value="creative_break_blacklist")
            public boolean doCreativeModePlayersBreakBlackListBlocks = true;
        }

        public static class BlockEntry {
            public Block block = null;
            public TagKey<Block> tag = null;
            public String mod = null;

            public BlockEntry(Raw raw) {
                if (raw.block != null) {
                    this.block = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.m_135820_((String)raw.block));
                    if (this.block == null) {
                        LOGGER.warn("Unknown block '{}' in block entry", (Object)raw.block);
                    }
                }
                if (raw.tag != null) {
                    this.tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)ResourceLocation.parse((String)raw.tag));
                }
                this.mod = raw.mod;
                if (this.block == null && this.tag == null && this.mod == null) {
                    throw new IllegalArgumentException("Block entry must have at least one of 'block', 'tag' or 'mod' defined");
                }
            }

            public boolean check(Block block) {
                return !(this.block != null && this.block != block || this.tag != null && !block.m_204297_().m_203656_(this.tag) || this.mod != null && !this.mod.equals(ForgeRegistries.BLOCKS.getKey((Object)block).m_135827_()));
            }

            public static class Raw {
                public String block = null;
                public String tag = null;
                public String mod = null;
            }
        }
    }

    public static class FileUtils {
        public static final Gson gson = new Gson();

        public static Path getConfigPath(String CONFIG_NAME) {
            return Paths.get("config/" + CONFIG_NAME, new String[0]);
        }

        public static boolean copyDefaultConfig(String CONFIG_NAME) {
            Path path = FileUtils.getConfigPath(CONFIG_NAME);
            if (!Files.exists(path, new LinkOption[0])) {
                boolean bl;
                block9: {
                    InputStream in = FileUtils.class.getResourceAsStream("/" + String.valueOf(FileUtils.getConfigPath(CONFIG_NAME)));
                    try {
                        Files.createDirectories(path.getParent(), new FileAttribute[0]);
                        Files.copy(in, path, new CopyOption[0]);
                        bl = true;
                        if (in == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            LOGGER.error("Error during copy config '" + CONFIG_NAME + "'", (Throwable)e);
                            return false;
                        }
                    }
                    in.close();
                }
                return bl;
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static <T> T loadConfig(String CONFIG_NAME, Class<T> tClass) {
            if (!FileUtils.copyDefaultConfig(CONFIG_NAME)) {
                return null;
            }
            try (BufferedReader reader = Files.newBufferedReader(FileUtils.getConfigPath(CONFIG_NAME));){
                Object object = gson.fromJson((Reader)reader, tClass);
                return (T)object;
            }
            catch (JsonSyntaxException | IOException e) {
                LOGGER.error("Error during loading config '" + CONFIG_NAME + "'", e);
                return null;
            }
        }
    }
}

