/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.nixie.foundation;

import com.kipti.bnb.CreateBitsnBobs;
import com.kipti.bnb.content.nixie.foundation.ConfigurableDisplayOptionTransform;
import com.kipti.bnb.content.nixie.foundation.DoubleOrientedDirections;
import com.kipti.bnb.content.nixie.foundation.GenericNixieDisplayBlock;
import com.kipti.bnb.content.nixie.foundation.IGenericNixieDisplayBlock;
import com.kipti.bnb.content.nixie.nixie_board.NixieBoardBlockNixie;
import com.kipti.bnb.mixin_accessor.DynamicComponentMigrator;
import com.kipti.bnb.registry.BnbBlocks;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.DynamicComponent;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericNixieDisplayBlockEntity
extends SmartBlockEntity {
    private static final int MAX_CHARS_IN_BLOCK = 3;
    private static final Logger log = LoggerFactory.getLogger(GenericNixieDisplayBlockEntity.class);
    private Optional<DynamicComponent> customTextTop = Optional.empty();
    private Optional<DynamicComponent> customTextBottom = Optional.empty();
    private int customTextStart = 0;
    private String renderedTextTop = "";
    private String renderedTextBottom = "";
    protected ConfigurableDisplayOptions currentDisplayOption = ConfigurableDisplayOptions.NONE;

    public GenericNixieDisplayBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void initialize() {
        if (this.f_58857_.f_46443_) {
            this.updateDisplayedStrings();
        }
    }

    public void inheritDataFrom(GenericNixieDisplayBlockEntity be) {
        this.customTextTop = be.customTextTop;
        this.customTextBottom = be.customTextBottom;
        this.customTextStart = be.customTextStart;
        this.currentDisplayOption = be.currentDisplayOption;
        this.notifyUpdate();
    }

    public ConfigurableDisplayOptions getCurrentDisplayOption() {
        return this.currentDisplayOption;
    }

    public char getRenderedText(int line, int width) {
        if (line == 0) {
            if (width < this.renderedTextTop.length()) {
                return this.renderedTextTop.charAt(width);
            }
        } else if (line == 1 && width < this.renderedTextBottom.length()) {
            return this.renderedTextBottom.charAt(width);
        }
        return ' ';
    }

    public void setPositionOffset(int consumedCharsOnRow) {
        this.customTextStart = consumedCharsOnRow;
    }

    public List<ConfigurableDisplayOptions> getPossibleDisplayOptions() {
        return ((IGenericNixieDisplayBlock)this.m_58900_().m_60734_()).getPossibleDisplayOptions();
    }

    public void applyToEachElementOfThisStructure(Consumer<GenericNixieDisplayBlockEntity> consumer) {
        BlockEntity blockEntity;
        GenericNixieDisplayBlockEntity controller = this.findControllerBlockEntity();
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)GenericNixieDisplayBlock.f_52588_);
        Direction orientation = (Direction)this.m_58900_().m_61143_((Property)GenericNixieDisplayBlock.ORIENTATION);
        Direction right = DoubleOrientedDirections.getLeft(facing, orientation).m_122424_();
        BlockPos currentPos = controller.m_58899_();
        for (int i = 0; i < 100 && (blockEntity = controller.f_58857_.m_7702_(currentPos)) instanceof GenericNixieDisplayBlockEntity; ++i) {
            GenericNixieDisplayBlockEntity display = (GenericNixieDisplayBlockEntity)blockEntity;
            if (!GenericNixieDisplayBlockEntity.areStatesComprableForConnection(controller.m_58900_(), display.m_58900_())) break;
            consumer.accept(display);
            currentPos = currentPos.m_121945_(right);
        }
    }

    public void setDisplayOption(ConfigurableDisplayOptions option) {
        if (this.currentDisplayOption == option) {
            return;
        }
        this.currentDisplayOption = option;
        if (this.f_58857_.f_46443_) {
            this.updateDisplayedStrings();
        }
        this.notifyUpdate();
    }

    public static boolean areStatesComprableForConnection(BlockState state1, BlockState state2) {
        boolean stateTwoIsTube;
        if (state1 == null || state2 == null) {
            return false;
        }
        boolean stateOneIsBoard = BnbBlocks.NIXIE_BOARD.is((Object)state1.m_60734_()) || BnbBlocks.DYED_NIXIE_BOARD.contains(state1.m_60734_());
        boolean stateTwoIsBoard = BnbBlocks.NIXIE_BOARD.is((Object)state2.m_60734_()) || BnbBlocks.DYED_NIXIE_BOARD.contains(state2.m_60734_());
        boolean stateOneIsTube = BnbBlocks.LARGE_NIXIE_TUBE.is((Object)state1.m_60734_()) || BnbBlocks.DYED_LARGE_NIXIE_TUBE.contains(state1.m_60734_());
        boolean bl = stateTwoIsTube = BnbBlocks.LARGE_NIXIE_TUBE.is((Object)state2.m_60734_()) || BnbBlocks.DYED_LARGE_NIXIE_TUBE.contains(state2.m_60734_());
        if (!(stateOneIsBoard && stateTwoIsBoard || stateOneIsTube && stateTwoIsTube)) {
            return false;
        }
        if (state1.m_61143_((Property)GenericNixieDisplayBlock.f_52588_) != state2.m_61143_((Property)GenericNixieDisplayBlock.f_52588_)) {
            return false;
        }
        return state1.m_61143_((Property)GenericNixieDisplayBlock.ORIENTATION) == state2.m_61143_((Property)GenericNixieDisplayBlock.ORIENTATION);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        CompoundTag componentTag;
        super.write(tag, clientPacket);
        if (this.customTextTop.isPresent()) {
            componentTag = new CompoundTag();
            this.customTextTop.get().write(componentTag);
            tag.m_128365_("CustomTextComponentTop", (Tag)componentTag);
        }
        if (this.customTextBottom.isPresent()) {
            componentTag = new CompoundTag();
            this.customTextBottom.get().write(componentTag);
            tag.m_128365_("CustomTextComponentBottom", (Tag)componentTag);
        }
        tag.m_128405_("CustomTextIndex", this.customTextStart);
        tag.m_128359_("CurrentDisplayOption", this.currentDisplayOption.name());
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        CompoundTag componentTag;
        DynamicComponent component;
        super.read(tag, clientPacket);
        if (tag.m_128441_("CustomTextComponentTop")) {
            component = this.customTextTop.orElseGet(DynamicComponent::new);
            componentTag = tag.m_128469_("CustomTextComponentTop");
            component.read(this.f_58857_, this.f_58858_, componentTag);
            this.customTextTop = Optional.of(component);
        }
        if (tag.m_128441_("CustomTextComponentBottom")) {
            component = this.customTextBottom.orElseGet(DynamicComponent::new);
            componentTag = tag.m_128469_("CustomTextComponentBottom");
            component.read(this.f_58857_, this.f_58858_, componentTag);
            this.customTextBottom = Optional.of(component);
        }
        this.customTextStart = tag.m_128451_("CustomTextIndex");
        String optionName = tag.m_128461_("CurrentDisplayOption");
        try {
            this.currentDisplayOption = ConfigurableDisplayOptions.valueOf(optionName);
        }
        catch (IllegalArgumentException e) {
            log.warn("Invalid display option '{}' for block entity at {}. Defaulting to NONE.", (Object)optionName, (Object)this.m_58899_());
            this.currentDisplayOption = ConfigurableDisplayOptions.NONE;
        }
        if (tag.m_128441_("CurrentTextTop")) {
            log.info("Migrating old Nixie display data for block entity at {}", (Object)this.m_58899_());
            String oldTextTop = tag.m_128461_("CurrentTextTop");
            if (!oldTextTop.isEmpty()) {
                EndClipping clipping = this.getEndClipping();
                DynamicComponent component2 = new DynamicComponent();
                ((DynamicComponentMigrator)component2).bits_n_bobs$setValueToLiteral(oldTextTop);
                this.customTextTop = Optional.of(component2);
                this.customTextStart = clipping.left;
            } else {
                this.customTextTop = Optional.empty();
                this.customTextStart = 0;
            }
        }
        if (tag.m_128441_("CurrentTextBottom")) {
            log.info("Migrating old Nixie display data for block entity at {}", (Object)this.m_58899_());
            String oldTextBottom = tag.m_128461_("CurrentTextBottom");
            if (!oldTextBottom.isEmpty()) {
                DynamicComponent component3 = new DynamicComponent();
                ((DynamicComponentMigrator)component3).bits_n_bobs$setValueToLiteral(oldTextBottom);
                this.customTextBottom = Optional.of(component3);
                EndClipping clipping = this.getEndClipping();
                this.customTextStart = clipping.left;
            } else {
                this.customTextBottom = Optional.empty();
                this.customTextStart = 0;
            }
        }
        if (clientPacket || this.isVirtual()) {
            this.updateDisplayedStrings();
        }
    }

    @NotNull
    public GenericNixieDisplayBlockEntity findControllerBlockEntity() {
        BlockEntity blockEntity;
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)GenericNixieDisplayBlock.f_52588_);
        Direction orientation = (Direction)this.m_58900_().m_61143_((Property)GenericNixieDisplayBlock.ORIENTATION);
        Direction left = DoubleOrientedDirections.getLeft(facing, orientation);
        BlockPos leftPos = this.m_58899_().m_121945_(left);
        GenericNixieDisplayBlockEntity lastDisplay = this;
        for (int i = 0; i < 100 && (blockEntity = this.f_58857_.m_7702_(leftPos)) instanceof GenericNixieDisplayBlockEntity; ++i) {
            GenericNixieDisplayBlockEntity display = (GenericNixieDisplayBlockEntity)blockEntity;
            if (!GenericNixieDisplayBlockEntity.areStatesComprableForConnection(this.m_58900_(), display.m_58900_())) break;
            lastDisplay = display;
            leftPos = leftPos.m_121945_(left);
        }
        return lastDisplay;
    }

    public void displayCustomText(String tagElement, int nixiePositionInRow, int line) {
        Optional<DynamicComponent> lineText;
        Optional<DynamicComponent> optional = lineText = line == 0 ? this.customTextTop : this.customTextBottom;
        if (tagElement == null) {
            return;
        }
        if (lineText.filter(d -> d.sameAs(tagElement)).isPresent()) {
            return;
        }
        DynamicComponent component = lineText.orElseGet(DynamicComponent::new);
        component.displayCustomText(this.f_58857_, this.f_58858_, tagElement);
        if (line == 0) {
            this.customTextTop = Optional.of(component);
        } else {
            this.customTextBottom = Optional.of(component);
        }
        this.customTextStart = nixiePositionInRow;
        this.notifyUpdate();
    }

    public int seekWidth() {
        Direction right = DoubleOrientedDirections.getLeft((Direction)this.m_58900_().m_61143_((Property)GenericNixieDisplayBlock.f_52588_), (Direction)this.m_58900_().m_61143_((Property)GenericNixieDisplayBlock.ORIENTATION)).m_122424_();
        int characterCount = 0;
        for (int i = 0; i < 100; ++i) {
            BlockPos nextPos = this.m_58899_().m_5484_(right, i);
            BlockEntity blockEntity = this.f_58857_.m_7702_(nextPos);
            if (!GenericNixieDisplayBlockEntity.areStatesComprableForConnection(this.m_58900_(), this.f_58857_.m_8055_(nextPos))) break;
            if (blockEntity instanceof GenericNixieDisplayBlockEntity) {
                GenericNixieDisplayBlockEntity currentWalkNixieDisplay = (GenericNixieDisplayBlockEntity)blockEntity;
                characterCount += currentWalkNixieDisplay.calculateDisplayedCharacterWidth();
                continue;
            }
            CreateBitsnBobs.LOGGER.warn("Found unexpected non-nixie display block entity at {} while seeking width for {}", (Object)nextPos, (Object)this.m_58899_());
            break;
        }
        return characterCount;
    }

    public void updateDisplayedStrings() {
        this.customTextTop.map(DynamicComponent::resolve).ifPresentOrElse(fullText -> {
            this.renderedTextTop = this.charsOrEmpty((String)fullText, this.customTextStart);
        }, () -> {
            this.renderedTextTop = "";
        });
        this.customTextBottom.map(DynamicComponent::resolve).ifPresentOrElse(fullText -> {
            this.renderedTextBottom = this.charsOrEmpty((String)fullText, this.customTextStart);
        }, () -> {
            this.renderedTextBottom = "";
        });
    }

    private String charsOrEmpty(String string, int index) {
        EndClipping endClipping = this.getEndClipping();
        return " ".repeat(endClipping.left) + (string.length() <= index ? "   " : (string + " ".repeat(3)).substring(index, index + this.calculateDisplayedCharacterWidth()));
    }

    int calculateDisplayedCharacterWidth() {
        EndClipping endClipping = this.getEndClipping();
        return this.currentDisplayOption.width - endClipping.left - endClipping.right;
    }

    public EndClipping getEndClipping() {
        boolean right;
        if (!(this.m_58900_().m_60734_() instanceof NixieBoardBlockNixie) || this.currentDisplayOption != ConfigurableDisplayOptions.DOUBLE_CHAR_DOUBLE_LINES) {
            return EndClipping.NONE;
        }
        boolean left = (Boolean)this.m_58900_().m_61143_((Property)NixieBoardBlockNixie.LEFT) == false;
        boolean bl = right = (Boolean)this.m_58900_().m_61143_((Property)NixieBoardBlockNixie.RIGHT) == false;
        if (left && right) {
            return EndClipping.BOTH;
        }
        if (left) {
            return EndClipping.LEFT;
        }
        if (right) {
            return EndClipping.RIGHT;
        }
        return EndClipping.NONE;
    }

    public static enum ConfigurableDisplayOptions {
        NONE(1, 1, () -> ConfigurableDisplayOptionTransform.NONE),
        ALWAYS_UP(1, 1, () -> ConfigurableDisplayOptionTransform.ALWAYS_UP),
        DOUBLE_CHAR(2, 1, () -> ConfigurableDisplayOptionTransform.DOUBLE_CHAR),
        DOUBLE_CHAR_DOUBLE_LINES(3, 2, () -> ConfigurableDisplayOptionTransform.DOUBLE_CHAR_DOUBLE_LINES);

        public final Supplier<ConfigurableDisplayOptionTransform> renderTransform;
        public final int width;
        public final int lines;

        private ConfigurableDisplayOptions(int width, int lines, Supplier<ConfigurableDisplayOptionTransform> renderTransform) {
            this.renderTransform = renderTransform;
            this.width = width;
            this.lines = lines;
        }
    }

    public static enum EndClipping {
        NONE(0, 0),
        LEFT(1, 0),
        RIGHT(0, 1),
        BOTH(1, 1);

        public final int left;
        public final int right;

        private EndClipping(int left, int right) {
            this.left = left;
            this.right = right;
        }
    }
}

