/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.girder_strut;

import com.kipti.bnb.content.girder_strut.GirderStrutBlock;
import com.kipti.bnb.content.girder_strut.GirderStrutBlockEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;

public class GirderStrutModelBuilder
extends BakedModelWrapper<BakedModel> {
    private static final ModelProperty<GirderStrutModelData> GIRDER_PROPERTY = new ModelProperty();
    private static final double SURFACE_OFFSET = 0.376;

    public GirderStrutModelBuilder(BakedModel originalModel) {
        super(originalModel);
    }

    @NotNull
    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData blockEntityData) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof GirderStrutBlockEntity)) {
            return ModelData.EMPTY;
        }
        GirderStrutBlockEntity blockEntity2 = (GirderStrutBlockEntity)blockEntity;
        blockEntity2.connectionRenderBufferCache = null;
        return ModelData.builder().build();
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData data, RenderType renderType) {
        ArrayList<BakedQuad> base = new ArrayList<BakedQuad>(super.getQuads(state, side, rand, data, renderType));
        return base;
    }

    public boolean useAmbientOcclusion(BlockState state, RenderType renderType) {
        return false;
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7547_() {
        return true;
    }

    static final class GirderConnection {
        private final Vec3 start;
        private final Vec3 direction;
        private final double renderLength;
        private final Vec3 surfacePlanePoint;
        private final Vec3 surfaceNormal;

        GirderConnection(Vec3 start, Vec3 direction, double renderLength, Vec3 surfacePlanePoint, Vec3 surfaceNormal) {
            this.start = start;
            this.direction = direction;
            this.renderLength = renderLength;
            this.surfacePlanePoint = surfacePlanePoint;
            this.surfaceNormal = surfaceNormal;
        }

        Vec3 start() {
            return this.start;
        }

        Vec3 direction() {
            return this.direction;
        }

        double renderLength() {
            return this.renderLength;
        }

        Vec3 surfacePlanePoint() {
            return this.surfacePlanePoint;
        }

        Vec3 surfaceNormal() {
            return this.surfaceNormal;
        }
    }

    static final class GirderStrutModelData {
        private final List<GirderConnection> connections;
        private final BlockPos pos;

        private GirderStrutModelData(List<GirderConnection> connections, BlockPos pos) {
            this.connections = connections;
            this.pos = pos;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        List<GirderConnection> connections() {
            return this.connections;
        }

        static GirderStrutModelData collect(BlockAndTintGetter level, BlockPos pos, BlockState state, GirderStrutBlockEntity blockEntity) {
            if (!(state.m_60734_() instanceof GirderStrutBlock)) {
                return new GirderStrutModelData(List.of(), pos);
            }
            Direction facing = (Direction)state.m_61143_((Property)GirderStrutBlock.FACING);
            Vec3 blockOrigin = Vec3.m_82528_((Vec3i)pos);
            Vec3 facePoint = Vec3.m_82512_((Vec3i)pos).m_231075_(facing, -0.626);
            Vec3 thisSurface = Vec3.m_82512_((Vec3i)pos).m_231075_(facing, -0.376);
            ArrayList<GirderConnection> connections = new ArrayList<GirderConnection>();
            for (BlockPos otherPos : blockEntity.getConnectionsCopy()) {
                Vec3 halfVector;
                double renderLength;
                BlockState otherState = level.m_8055_(otherPos = otherPos.m_121955_((Vec3i)pos));
                if (!(otherState.m_60734_() instanceof GirderStrutBlock)) continue;
                Direction otherFacing = (Direction)otherState.m_61143_((Property)GirderStrutBlock.FACING);
                Vec3 otherSurface = Vec3.m_82512_((Vec3i)otherPos).m_231075_(otherFacing, -0.376);
                Vec3 span = otherSurface.m_82546_(thisSurface);
                if (span.m_82556_() < 1.0E-4 || (renderLength = (halfVector = span.m_82490_(0.5)).m_82553_() + 0.5) <= 1.0E-4) continue;
                Vec3 direction = halfVector.m_82541_();
                Vec3 startLocal = thisSurface.m_82546_(blockOrigin);
                Vec3 planePointLocal = facePoint.m_82546_(blockOrigin);
                connections.add(new GirderConnection(startLocal, direction, renderLength, planePointLocal, Vec3.m_82528_((Vec3i)facing.m_122436_())));
            }
            return new GirderStrutModelData(Collections.unmodifiableList(connections), pos);
        }
    }
}

