/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.cogwheel_chain.graph;

import com.kipti.bnb.CreateBitsnBobs;
import com.kipti.bnb.content.cogwheel_chain.block.CogwheelChainBlock;
import com.kipti.bnb.content.cogwheel_chain.block.CogwheelChainBlockEntity;
import com.kipti.bnb.content.cogwheel_chain.graph.CogwheelChainGeometryBuilder;
import com.kipti.bnb.content.cogwheel_chain.graph.PathedCogwheelNode;
import com.kipti.bnb.content.cogwheel_chain.graph.PlacingCogwheelChain;
import com.kipti.bnb.content.cogwheel_chain.graph.PlacingCogwheelNode;
import com.kipti.bnb.content.cogwheel_chain.graph.RenderedChainPathNode;
import com.kipti.bnb.registry.BnbBlocks;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class CogwheelChain {
    private final List<PathedCogwheelNode> cogwheelNodes;
    private List<RenderedChainPathNode> renderedNodes;

    public CogwheelChain(CompoundTag tag) {
        this.renderedNodes = new ArrayList<RenderedChainPathNode>();
        this.cogwheelNodes = new ArrayList<PathedCogwheelNode>();
        this.read(tag);
    }

    public CogwheelChain(List<PathedCogwheelNode> path) {
        this.cogwheelNodes = path;
        this.renderedNodes = CogwheelChainGeometryBuilder.buildFullChainFromPathNodes(path);
    }

    @Nullable
    public PathedCogwheelNode getNodeFromControllerOffset(Vec3i controllerOffset) {
        Vec3i offsetFromStart = controllerOffset.m_142393_(-1);
        for (PathedCogwheelNode cogwheelNode : this.cogwheelNodes) {
            if (!cogwheelNode.localPos().equals((Object)offsetFromStart)) continue;
            return cogwheelNode;
        }
        return null;
    }

    public boolean checkIntegrity(Level level, BlockPos origin) {
        for (PathedCogwheelNode node : this.cogwheelNodes) {
            CogwheelChainBlock iCogWheel;
            boolean isLarge;
            BlockState state = level.m_8055_(node.localPos().m_121955_((Vec3i)origin));
            if (!this.isValidChainCogwheel(state)) {
                return false;
            }
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)CogWheelBlock.AXIS);
            Block block = state.m_60734_();
            boolean bl = isLarge = block instanceof CogwheelChainBlock && (iCogWheel = (CogwheelChainBlock)block).isLargeChainCog();
            if (axis == node.rotationAxis() && isLarge == node.isLarge()) continue;
            return false;
        }
        return true;
    }

    private boolean isValidChainCogwheel(BlockState state) {
        return BnbBlocks.LARGE_SPROCKET_COGWHEEL_CHAIN.is((Object)state.m_60734_()) || BnbBlocks.SMALL_SPROCKET_COGWHEEL_CHAIN.is((Object)state.m_60734_()) || BnbBlocks.LARGE_FLANGED_COGWHEEL_CHAIN.is((Object)state.m_60734_()) || BnbBlocks.SMALL_FLANGED_COGWHEEL_CHAIN.is((Object)state.m_60734_());
    }

    public void write(CompoundTag tag) {
        tag.m_128405_("cogwheel_pos_count", this.cogwheelNodes.size());
        for (int i = 0; i < this.cogwheelNodes.size(); ++i) {
            CompoundTag posTag = new CompoundTag();
            this.cogwheelNodes.get(i).write(posTag);
            tag.m_128365_("cogwheel_pos_" + i, (Tag)posTag);
        }
    }

    public void read(CompoundTag tag) {
        this.cogwheelNodes.clear();
        int cogWheelPosCount = tag.m_128451_("cogwheel_pos_count");
        for (int i = 0; i < cogWheelPosCount; ++i) {
            CompoundTag posTag = tag.m_128469_("cogwheel_pos_" + i);
            PathedCogwheelNode pos = PathedCogwheelNode.read(posTag);
            this.cogwheelNodes.add(pos);
        }
        this.renderedNodes.clear();
        this.renderedNodes = CogwheelChainGeometryBuilder.buildFullChainFromPathNodes(this.cogwheelNodes);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CogwheelChain that = (CogwheelChain)o;
        return Objects.equals(this.renderedNodes, that.renderedNodes);
    }

    public int hashCode() {
        return Objects.hashCode(this.renderedNodes);
    }

    public void placeInLevel(Level level, PlacingCogwheelChain source) {
        boolean isController = true;
        BlockPos controllerPos = source.getFirstNode().pos();
        int chainsUsed = source.getChainsRequiredInLoop();
        for (PlacingCogwheelNode node : source.getVisitedNodes()) {
            this.placeChainCogwheelInLevel(level, node, isController, chainsUsed, controllerPos);
            isController = false;
        }
    }

    private void placeChainCogwheelInLevel(Level level, PlacingCogwheelNode node, boolean isController, int chainsUsed, BlockPos controllerPos) {
        BlockState existingState = level.m_8055_(node.pos());
        @Nullable BlockState newState = CogwheelChainBlock.getChainState(existingState, node.isLarge(), node.rotationAxis());
        if (newState == null) {
            CreateBitsnBobs.LOGGER.error("Failed to place cogwheel chain at {}, existing block {}, because the chain state could not be resolved", (Object)node.pos(), (Object)existingState);
            return;
        }
        level.m_46597_(node.pos(), newState);
        BlockEntity be = level.m_7702_(node.pos());
        if (be instanceof CogwheelChainBlockEntity) {
            CogwheelChainBlockEntity chainBE = (CogwheelChainBlockEntity)be;
            if (isController) {
                chainBE.setAsController(this);
                chainBE.setChainsUsed(chainsUsed);
            } else {
                chainBE.setController((Vec3i)controllerPos.m_121996_((Vec3i)node.pos()));
            }
        } else {
            throw new IllegalStateException("Expected CogwheelChainBlockEntity at " + node.pos());
        }
    }

    public void destroy(Level level, BlockPos worldPosition) {
        for (PathedCogwheelNode cogwheel : this.cogwheelNodes) {
            BlockPos pos = worldPosition.m_121955_((Vec3i)cogwheel.localPos());
            CogwheelChain.removeChainCogwheelFromLevelIfPresent(level, pos);
        }
    }

    public static void removeChainCogwheelFromLevelIfPresent(Level level, BlockPos pos) {
        Block block;
        BlockEntity be = level.m_7702_(pos);
        BlockState state = level.m_8055_(pos);
        if (be instanceof CogwheelChainBlockEntity && (block = state.m_60734_()) instanceof CogwheelChainBlock) {
            CogwheelChainBlock cogwheelChainBlock = (CogwheelChainBlock)block;
            level.m_46597_(pos, (BlockState)cogwheelChainBlock.getSourceBlockState().m_61124_((Property)CogwheelChainBlock.AXIS, (Comparable)((Direction.Axis)state.m_61143_((Property)CogwheelChainBlock.AXIS))));
        }
    }

    public List<RenderedChainPathNode> getChainPathNodes() {
        return this.renderedNodes;
    }

    public List<PathedCogwheelNode> getChainPathCogwheelNodes() {
        return this.cogwheelNodes;
    }

    public static class InvalidGeometryException
    extends Exception {
        public InvalidGeometryException(String reason) {
            super(reason);
        }
    }
}

