/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.clouds.shaders;

import com.mojang.blaze3d.systems.RenderSystem;
import com.qendolin.betterclouds.clouds.shaders.Uniform;
import com.qendolin.betterclouds.compat.GLCompat;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ChainedJsonException;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.GL32;

public class Shader
implements AutoCloseable {
    private final Map<String, String> defs;
    protected int programId;

    public Shader(ResourceManager resMan, ResourceLocation vshId, ResourceLocation fshId, Map<String, String> defs) throws IOException {
        RenderSystem.assertOnRenderThread();
        this.defs = defs;
        int vsh = this.compileShader(35633, vshId, resMan);
        int fsh = this.compileShader(35632, fshId, resMan);
        GLCompat.glCompat.objectLabelDev(GLCompat.glCompat.GL_SHADER, vsh, vshId.m_135815_());
        GLCompat.glCompat.objectLabelDev(GLCompat.glCompat.GL_SHADER, fsh, fshId.m_135815_());
        this.programId = GL32.glCreateProgram();
        GL32.glAttachShader((int)this.programId, (int)vsh);
        GL32.glAttachShader((int)this.programId, (int)fsh);
        GL32.glLinkProgram((int)this.programId);
        if (GL32.glGetProgrami((int)this.programId, (int)35714) == 0) {
            String log = GL32.glGetProgramInfoLog((int)this.programId);
            throw new IllegalStateException("Failed to link program: " + log);
        }
        GL32.glDeleteShader((int)vsh);
        GL32.glDeleteShader((int)fsh);
    }

    protected int compileShader(int type, ResourceLocation resource, ResourceManager resMan) throws IOException {
        String shaderSrc;
        RenderSystem.assertOnRenderThread();
        try {
            InputStream stream = resMan.m_215593_(resource).m_215507_();
            shaderSrc = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            shaderSrc = shaderSrc.strip();
        }
        catch (IOException ex) {
            ChainedJsonException fileEx = ChainedJsonException.m_135906_((Exception)ex);
            fileEx.m_135910_(resource.toString());
            throw fileEx;
        }
        for (Map.Entry<String, String> entry : this.defs.entrySet()) {
            shaderSrc = shaderSrc.replace(entry.getKey(), entry.getValue());
        }
        int id = GL32.glCreateShader((int)type);
        GLCompat.glCompat.shaderSource(id, shaderSrc);
        GL32.glCompileShader((int)id);
        if (GL32.glGetShaderi((int)id, (int)35713) == 0) {
            String log = StringUtils.trim((String)GL32.glGetShaderInfoLog((int)id, (int)32768));
            ChainedJsonException parseEx = new ChainedJsonException("Couldn't compile shader program (" + String.valueOf(resource) + "): \n" + log + "\n\nShader Source: \n" + shaderSrc);
            parseEx.m_135910_(resource.toString());
            throw parseEx;
        }
        return id;
    }

    @Override
    public void close() {
        if (this.programId != 0) {
            GL32.glDeleteProgram((int)this.programId);
        }
        this.programId = 0;
    }

    public boolean isIncomplete() {
        return this.programId <= 0;
    }

    public void bind() {
        GL32.glUseProgram((int)this.programId);
    }

    public int glId() {
        return this.programId;
    }

    protected Uniform getUniform(String name, boolean cached) {
        int location = GL32.glGetUniformLocation((int)this.programId, (CharSequence)name);
        if (location < 0) {
            return new Uniform.Noop(name, location);
        }
        if (cached) {
            return new Uniform.Cached(name, location);
        }
        return new Uniform.Simple(name, location);
    }
}

