/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.util.state;

import mod.azure.azurelib.util.state.State;
import mod.azure.azurelib.util.state.StateMachineContext;

public abstract class StateMachine<C extends StateMachineContext, T extends State<C>> {
    private final C reusableContext;
    private T state;

    public StateMachine(T initialState) {
        this.state = initialState;
        this.reusableContext = this.createContext();
    }

    protected abstract C createContext();

    public void update(C context) {
        this.state.onUpdate(context);
    }

    public C getContext() {
        return this.reusableContext;
    }

    public T getState() {
        return this.state;
    }

    public void setState(T newState) {
        this.state.onExit(this.reusableContext);
        this.state = newState;
        newState.onEnter(this.reusableContext);
    }
}

