/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.model.factory.impl;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import mod.azure.azurelib.cache.object.GeoCube;
import mod.azure.azurelib.cache.object.GeoQuad;
import mod.azure.azurelib.loading.json.raw.Bone;
import mod.azure.azurelib.loading.json.raw.Cube;
import mod.azure.azurelib.loading.json.raw.ModelProperties;
import mod.azure.azurelib.loading.object.BoneStructure;
import mod.azure.azurelib.loading.object.GeometryTree;
import mod.azure.azurelib.model.AzBakedModel;
import mod.azure.azurelib.model.AzBone;
import mod.azure.azurelib.model.AzBoneMetadata;
import mod.azure.azurelib.model.factory.AzBakedModelFactory;
import mod.azure.azurelib.model.factory.primitive.VertexSet;
import mod.azure.azurelib.util.client.RenderUtils;
import net.minecraft.world.phys.Vec3;

public final class AzBuiltinBakedModelFactory
extends AzBakedModelFactory {
    @Override
    public AzBakedModel constructGeoModel(GeometryTree geometryTree) {
        ObjectArrayList bones = new ObjectArrayList();
        for (BoneStructure boneStructure : geometryTree.topLevelBones().values()) {
            bones.add((Object)this.constructBone(boneStructure, geometryTree.properties(), null));
        }
        return new AzBakedModel((List<AzBone>)bones);
    }

    @Override
    public AzBone constructBone(BoneStructure boneStructure, ModelProperties properties, AzBone parent) {
        Bone bone = boneStructure.self();
        AzBoneMetadata boneMetadata = new AzBoneMetadata(bone, parent);
        AzBone newBone = new AzBone(boneMetadata);
        Vec3 rotation = RenderUtils.arrayToVec(bone.rotation());
        Vec3 pivot = RenderUtils.arrayToVec(bone.pivot());
        newBone.updateRotation((float)Math.toRadians(-rotation.f_82479_), (float)Math.toRadians(-rotation.f_82480_), (float)Math.toRadians(rotation.f_82481_));
        newBone.updatePivot((float)(-pivot.f_82479_), (float)pivot.f_82480_, (float)pivot.f_82481_);
        for (Cube cube : bone.cubes()) {
            newBone.getCubes().add(this.constructCube(cube, properties, newBone));
        }
        for (BoneStructure child : boneStructure.children().values()) {
            newBone.getChildBones().add(this.constructBone(child, properties, newBone));
        }
        return newBone;
    }

    @Override
    public GeoCube constructCube(Cube cube, ModelProperties properties, AzBone bone) {
        boolean mirror;
        boolean bl = mirror = cube.mirror() == Boolean.TRUE;
        double inflate = cube.inflate() != null ? cube.inflate() / 16.0 : (bone.getInflate() == null ? 0.0 : bone.getInflate() / 16.0);
        Vec3 size = RenderUtils.arrayToVec(cube.size());
        Vec3 origin = RenderUtils.arrayToVec(cube.origin());
        Vec3 rotation = RenderUtils.arrayToVec(cube.rotation());
        Vec3 pivot = RenderUtils.arrayToVec(cube.pivot());
        origin = new Vec3(-(origin.f_82479_ + size.f_82479_) / 16.0, origin.f_82480_ / 16.0, origin.f_82481_ / 16.0);
        Vec3 vertexSize = size.m_82542_(0.0625, 0.0625, 0.0625);
        pivot = pivot.m_82542_(-1.0, 1.0, 1.0);
        rotation = new Vec3(Math.toRadians(-rotation.f_82479_), Math.toRadians(-rotation.f_82480_), Math.toRadians(rotation.f_82481_));
        GeoQuad[] quads = this.buildQuads(cube.uv(), new VertexSet(origin, vertexSize, inflate), cube, (float)properties.textureWidth(), (float)properties.textureHeight(), mirror);
        return new GeoCube(quads, pivot, rotation, size, inflate, mirror);
    }
}

