/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.animation.property;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mod.azure.azurelib.animation.easing.AzEasingType;
import mod.azure.azurelib.animation.property.codec.AzAnimationPropertiesCodec;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AzAnimationProperties {
    public static final Function<FriendlyByteBuf, AzAnimationProperties> DECODER = AzAnimationPropertiesCodec.DECODER;
    public static final BiConsumer<FriendlyByteBuf, AzAnimationProperties> ENCODER = AzAnimationPropertiesCodec.ENCODER;
    public static final AzAnimationProperties DEFAULT = new AzAnimationProperties(1.0, null, Float.valueOf(0.0f), 0.0, 0.0, 1.0, false);
    public static final AzAnimationProperties EMPTY = new AzAnimationProperties(null, null, null, null, null, null, null);
    @Nullable
    protected Double animationSpeed;
    @Nullable
    protected AzEasingType easingType;
    @Nullable
    protected Float transitionLength;
    @Nullable
    protected Double startTickOffset;
    @Nullable
    protected Double freezeTickOffset;
    @Nullable
    protected Double repeatXTimes;
    @Nullable
    protected Boolean isReversing;

    public AzAnimationProperties(@Nullable Double animationSpeed, @Nullable AzEasingType easingType, @Nullable Float transitionLength, @Nullable Double startTickOffset, @Nullable Double freezeTickOffset, @Nullable Double repeatXTimes, @Nullable Boolean isReversing) {
        this.animationSpeed = animationSpeed;
        this.easingType = easingType;
        this.transitionLength = transitionLength;
        this.startTickOffset = startTickOffset;
        this.freezeTickOffset = freezeTickOffset;
        this.repeatXTimes = repeatXTimes;
        this.isReversing = isReversing;
    }

    public boolean hasAnimationSpeed() {
        return this.animationSpeed != null;
    }

    public boolean hasEasingType() {
        return this.easingType != null;
    }

    public boolean hasTransitionLength() {
        return this.transitionLength != null;
    }

    public boolean hasStartTickOffset() {
        return this.startTickOffset != null;
    }

    public boolean hasFreezeTickOffset() {
        return this.freezeTickOffset != null;
    }

    public boolean hasRepeatXTimes() {
        return this.repeatXTimes != null;
    }

    public boolean hasReversing() {
        return this.isReversing != null;
    }

    public AzAnimationProperties withAnimationSpeed(double animationSpeed) {
        this.animationSpeed = animationSpeed;
        return new AzAnimationProperties(animationSpeed, this.easingType, this.transitionLength, this.startTickOffset, this.freezeTickOffset, this.repeatXTimes, this.isReversing);
    }

    public AzAnimationProperties withEasingType(@NotNull AzEasingType easingType) {
        this.easingType = easingType;
        return new AzAnimationProperties(this.animationSpeed, easingType, this.transitionLength, this.startTickOffset, this.freezeTickOffset, this.repeatXTimes, this.isReversing);
    }

    public AzAnimationProperties withTransitionLength(float transitionLength) {
        this.transitionLength = Float.valueOf(transitionLength);
        return new AzAnimationProperties(this.animationSpeed, this.easingType, Float.valueOf(transitionLength), this.startTickOffset, this.freezeTickOffset, this.repeatXTimes, this.isReversing);
    }

    public AzAnimationProperties withStartTickOffset(double startTickOffset) {
        this.startTickOffset = startTickOffset;
        return new AzAnimationProperties(this.animationSpeed, this.easingType, this.transitionLength, startTickOffset, this.freezeTickOffset, this.repeatXTimes, this.isReversing);
    }

    public AzAnimationProperties withFreezeTickOffset(double freezeTickOffset) {
        this.freezeTickOffset = freezeTickOffset;
        return new AzAnimationProperties(this.animationSpeed, this.easingType, this.transitionLength, this.startTickOffset, freezeTickOffset, this.repeatXTimes, this.isReversing);
    }

    public AzAnimationProperties withRepeatXTimes(double repeatXTimes) {
        this.repeatXTimes = repeatXTimes;
        return new AzAnimationProperties(this.animationSpeed, this.easingType, this.transitionLength, this.startTickOffset, this.freezeTickOffset, repeatXTimes, this.isReversing);
    }

    public AzAnimationProperties withShouldReverse(boolean isReversing) {
        this.isReversing = isReversing;
        return new AzAnimationProperties(this.animationSpeed, this.easingType, this.transitionLength, this.startTickOffset, this.freezeTickOffset, this.repeatXTimes, isReversing);
    }

    public double animationSpeed() {
        return this.animationSpeed == null ? DEFAULT.animationSpeed() : this.animationSpeed.doubleValue();
    }

    public AzEasingType easingType() {
        return this.easingType;
    }

    public float transitionLength() {
        return this.transitionLength == null ? DEFAULT.transitionLength() : this.transitionLength.floatValue();
    }

    public double startTickOffset() {
        return this.startTickOffset == null ? DEFAULT.startTickOffset() : this.startTickOffset.doubleValue();
    }

    public double freezeTickOffset() {
        return this.freezeTickOffset == null ? DEFAULT.freezeTickOffset() : this.freezeTickOffset.doubleValue();
    }

    public double repeatXTimes() {
        return this.repeatXTimes == null ? DEFAULT.repeatXTimes() : this.repeatXTimes.doubleValue();
    }

    public boolean isReversing() {
        return this.isReversing == null ? DEFAULT.isReversing() : this.isReversing.booleanValue();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AzAnimationProperties that = (AzAnimationProperties)object;
        return Objects.equals(this.animationSpeed, that.animationSpeed) && Objects.equals(this.easingType, that.easingType) && Objects.equals(this.transitionLength, that.transitionLength) && Objects.equals(this.startTickOffset, that.startTickOffset) && Objects.equals(this.freezeTickOffset, that.freezeTickOffset) && Objects.equals(this.repeatXTimes, that.repeatXTimes) && Objects.equals(this.isReversing, that.isReversing);
    }

    public int hashCode() {
        return Objects.hash(this.animationSpeed, this.easingType, this.transitionLength, this.startTickOffset, this.freezeTickOffset, this.repeatXTimes, this.isReversing);
    }
}

