/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.gui.screen.menu;

import com.aetherteam.aether.mixin.mixins.client.accessor.TitleScreenAccessor;
import com.aetherteam.cumulus.CumulusConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.internal.BrandingControl;

public interface TitleScreenBehavior {
    default public float handleFading(GuiGraphics guiGraphics, TitleScreen titleScreen, TitleScreenAccessor titleScreenAccessor, PanoramaRenderer panorama, ResourceLocation panoramaOverlay, float partialTicks) {
        if (titleScreenAccessor.aether$getFadeInStart() == 0L && titleScreenAccessor.aether$isFading()) {
            titleScreenAccessor.aether$setFadeInStart(Util.m_137550_());
        }
        float fadeAmount = titleScreenAccessor.aether$isFading() ? (float)(Util.m_137550_() - titleScreenAccessor.aether$getFadeInStart()) / 1000.0f : 1.0f;
        panorama.m_110003_(partialTicks, Mth.m_14036_((float)fadeAmount, (float)0.0f, (float)1.0f));
        RenderSystem.enableBlend();
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, titleScreenAccessor.aether$isFading() ? (float)Mth.m_14167_((float)Mth.m_14036_((float)fadeAmount, (float)0.0f, (float)1.0f)) : 1.0f);
        guiGraphics.m_280411_(panoramaOverlay, 0, 0, titleScreen.f_96543_, titleScreen.f_96544_, 0.0f, 0.0f, 16, 128, 16, 128);
        return titleScreenAccessor.aether$isFading() ? Mth.m_14036_((float)(fadeAmount - 1.0f), (float)0.0f, (float)1.0f) : 1.0f;
    }

    default public void renderRightBranding(GuiGraphics guiGraphics, TitleScreen titleScreen, Font font, int roundedFadeAmount) {
        BrandingControl.forEachLine((boolean)true, (boolean)true, (brandingLine, branding) -> {
            int n = titleScreen.f_96543_ - font.m_92895_(branding) - 1;
            int n2 = titleScreen.f_96544_;
            int n3 = brandingLine + 1;
            Objects.requireNonNull(font);
            guiGraphics.m_280488_(font, branding, n, n2 - (10 + n3 * (9 + 1)), 0xFFFFFF | roundedFadeAmount);
        });
        BrandingControl.forEachAboveCopyrightLine((brandingLine, branding) -> {
            int n = titleScreen.f_96544_;
            int n2 = brandingLine + 1;
            Objects.requireNonNull(font);
            guiGraphics.m_280488_(font, branding, 1, n - n2 * (9 + 1), 0xFFFFFF | roundedFadeAmount);
        });
    }

    default public int handleButtonVisibility(TitleScreen titleScreen, float fadeAmount) {
        for (GuiEventListener guiEventListener : titleScreen.m_6702_()) {
            if (!(guiEventListener instanceof AbstractWidget)) continue;
            AbstractWidget abstractWidget = (AbstractWidget)guiEventListener;
            if (fadeAmount > 0.02f) {
                if (TitleScreenBehavior.isImageButton(abstractWidget.m_6035_())) continue;
                abstractWidget.m_93650_(fadeAmount);
                abstractWidget.f_93624_ = true;
                continue;
            }
            abstractWidget.f_93624_ = false;
        }
        return (Boolean)CumulusConfig.CLIENT.enable_menu_api.get() != false && (Boolean)CumulusConfig.CLIENT.enable_menu_list_button.get() != false ? -62 : 0;
    }

    default public void handleImageButtons(TitleScreen titleScreen, int xOffset) {
        for (Renderable renderable : titleScreen.f_169369_) {
            if (!(renderable instanceof Button)) continue;
            Button button = (Button)renderable;
            Component buttonText = button.m_6035_();
            if (TitleScreenBehavior.isImageButton(buttonText)) {
                button.f_93624_ = true;
            }
            if (buttonText.equals(Component.m_237115_((String)"narrator.button.accessibility"))) {
                button.m_252865_(titleScreen.f_96543_ - 48 + xOffset);
                button.m_253211_(4);
                continue;
            }
            if (!buttonText.equals(Component.m_237115_((String)"narrator.button.language"))) continue;
            button.m_252865_(titleScreen.f_96543_ - 24 + xOffset);
            button.m_253211_(4);
        }
    }

    public static boolean isImageButton(Component buttonText) {
        return buttonText.equals(Component.m_237115_((String)"narrator.button.accessibility")) || buttonText.equals(Component.m_237115_((String)"narrator.button.language"));
    }

    public static boolean isMainButton(Component buttonText) {
        return buttonText.equals(Component.m_237115_((String)"menu.singleplayer")) || buttonText.equals(Component.m_237115_((String)"menu.multiplayer")) || buttonText.equals(Component.m_237115_((String)"gui.aether.menu.server")) || buttonText.equals(Component.m_237115_((String)"menu.online")) || buttonText.equals(Component.m_237115_((String)"fml.menu.mods")) || buttonText.equals(Component.m_237115_((String)"menu.options")) || buttonText.equals(Component.m_237115_((String)"menu.quit"));
    }
}

