/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.util;

import com.idark.valoria.core.interfaces.ILivingEntityData;
import com.idark.valoria.registries.EffectsRegistry;
import com.idark.valoria.registries.EnchantmentsRegistry;
import com.idark.valoria.registries.item.types.ranged.GunpowderCharge;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.phys.AbsRect;
import pro.komaru.tridot.util.struct.func.Boolf;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;

public class ValoriaUtils {
    @OnlyIn(value=Dist.CLIENT)
    public static void renderText(LivingEntity entityIn, Col textColor, Component component, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, int time) {
        ILivingEntityData data = (ILivingEntityData)entityIn;
        float partialTicks = Minecraft.m_91087_().getPartialTick();
        data.valoria$setTextOffset(Mth.m_14179_((float)partialTicks, (float)data.valoria$getTextOffset(), (float)((float)Math.abs(Math.sin((float)time / 4.0f)))));
        data.valoria$setTextOffsetPrev(data.valoria$getTextOffset());
        float alpha = data.valoria$getTextOffset();
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.0, (double)(entityIn.m_20206_() + 0.25f + data.valoria$getTextOffset()), 0.0);
        matrixStackIn.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
        matrixStackIn.m_85841_(-data.valoria$getTextOffset() / 20.0f, -data.valoria$getTextOffset() / 20.0f, data.valoria$getTextOffset() / 20.0f);
        Matrix4f matrix4f = matrixStackIn.m_85850_().m_252922_();
        Font font = Minecraft.m_91087_().f_91062_;
        Color color = new Color(textColor.r, textColor.g, textColor.b, alpha);
        float f1 = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        int j = (int)(f1 * 255.0f) << 24;
        float f2 = -font.m_92852_((FormattedText)component) / 2;
        font.m_272077_(component, f2 * data.valoria$getTextOffset(), 0.0f, 0x20FFFFFF, false, matrix4f, bufferIn, Font.DisplayMode.NORMAL, j, packedLightIn);
        font.m_272077_(component, f2 * data.valoria$getTextOffset(), data.valoria$getTextOffset(), color.getRGB(), false, matrix4f, bufferIn, Font.DisplayMode.NORMAL, 0, packedLightIn);
        matrixStackIn.m_85849_();
    }

    public static boolean isVisibleInScissor(GuiGraphics gui, int x, int y, int w, int h, int scissorX, int scissorY, int scissorW, int scissorH) {
        AbsRect s = AbsRect.xywhDef((float)scissorX, (float)scissorY, (float)scissorW, (float)scissorH).pose(gui.m_280168_());
        AbsRect r = AbsRect.xywhDef((float)x, (float)y, (float)w, (float)h).pose(gui.m_280168_());
        return r.x < s.x2 && r.x2 > s.x && r.y < s.y2 && r.y2 > s.y;
    }

    @Nullable
    public static ItemStack getEquippedCurio(Predicate<ItemStack> filter, LivingEntity entity) {
        Optional curio = CuriosApi.getCuriosHelper().findEquippedCurio(filter, entity);
        return curio.map(stringIntegerItemStackImmutableTriple -> (ItemStack)stringIntegerItemStackImmutableTriple.right).orElse(null);
    }

    public static boolean isEquippedCurio(Predicate<ItemStack> filter, LivingEntity entity) {
        Optional curio = CuriosApi.getCuriosHelper().findEquippedCurio(filter, entity);
        return curio.isPresent();
    }

    public static boolean isEquippedCurio(TagKey<Item> tag, LivingEntity entity) {
        Optional curio = CuriosApi.getCuriosHelper().findEquippedCurio(item -> item.m_204117_(tag), entity);
        return curio.isPresent();
    }

    public static boolean isEquippedCurio(Item pItem, LivingEntity entity) {
        Optional curio = CuriosApi.getCuriosHelper().findEquippedCurio(item -> item.m_150930_(pItem), entity);
        return curio.isPresent();
    }

    public static void addHandPlayerItem(Level level, Player player, InteractionHand hand, ItemStack stack, ItemStack addStack) {
        if (player.m_150109_().m_36050_(addStack) >= 0) {
            ValoriaUtils.addPlayerItem(level, player, addStack);
        } else if (stack.m_41619_()) {
            player.m_21008_(hand, addStack.m_41777_());
        } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)addStack) && stack.m_41613_() + addStack.m_41613_() <= addStack.m_41741_()) {
            stack.m_41764_(stack.m_41613_() + addStack.m_41613_());
            player.m_21008_(hand, stack);
        } else {
            ValoriaUtils.addPlayerItem(level, player, addStack);
        }
    }

    public static void addPlayerItem(Level level, Player player, ItemStack addStack) {
        if (player.m_150109_().m_36050_(addStack) != -1 || player.m_150109_().m_36062_() > -1) {
            player.m_150109_().m_36054_(addStack.m_41777_());
        } else {
            level.m_7967_((Entity)new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), addStack.m_41777_()));
        }
    }

    public static void SUpdateTileEntityPacket(BlockEntity tile) {
        Packet packet;
        if (tile.m_58904_() instanceof ServerLevel && (packet = tile.m_58483_()) != null) {
            BlockPos pos = tile.m_58899_();
            ((ServerChunkCache)tile.m_58904_().m_7726_()).f_8325_.m_183262_(new ChunkPos(pos), false).forEach(e -> e.f_8906_.m_9829_(packet));
        }
    }

    public static float enchantmentAccuracy(ItemStack stack) {
        int i = stack.getEnchantmentLevel((Enchantment)EnchantmentsRegistry.ACCURACY.get());
        return i > 0 ? (float)i + 0.5f : 0.0f;
    }

    public static void radiusHit(Level level, ItemStack stack, Player player, @Nullable ParticleOptions type, List<LivingEntity> hitEntities, Vector3d pos, float pitchRaw, float yawRaw, float radius) {
        for (int i = 0; i < 360; i += 10) {
            double pitch = (double)(pitchRaw + 90.0f) * Math.PI / 180.0;
            double yaw = (double)(yawRaw + 90.0f) * Math.PI / 180.0;
            float pRadius = radius + Utils.Items.enchantmentRadius((ItemStack)stack);
            double X = Math.sin(pitch) * Math.cos(yaw + (double)i) * (double)pRadius;
            double Y = Math.cos(pitch) * (double)pRadius;
            double Z = Math.sin(pitch) * Math.sin(yaw + (double)i) * (double)pRadius;
            AABB boundingBox = new AABB(pos.x, pos.y - 1.0 + (Math.random() - 0.5) * (double)0.2f, pos.z, pos.x + X, pos.y + Y + (Math.random() - 0.5) * (double)0.2f, pos.z + Z);
            List entities = level.m_45976_(Entity.class, boundingBox);
            for (Entity entity : entities) {
                LivingEntity livingEntity;
                if (!(entity instanceof LivingEntity) || hitEntities.contains(livingEntity = (LivingEntity)entity) || livingEntity.equals((Object)player) || !Utils.Entities.canHitTarget((LivingEntity)player, (LivingEntity)livingEntity)) continue;
                hitEntities.add(livingEntity);
            }
            X = Math.sin(pitch) * Math.cos(yaw + (double)i) * (double)pRadius * 0.75;
            Y = Math.cos(pitch) * (double)pRadius * 0.75;
            Z = Math.sin(pitch) * Math.sin(yaw + (double)i) * (double)pRadius * 0.75;
            if (type == null || level.m_5776_() || !(level instanceof ServerLevel)) continue;
            ServerLevel pServer = (ServerLevel)level;
            pServer.m_8767_(type, pos.x + X, pos.y + Y + (Math.random() - 0.5) * (double)0.2f, pos.z + Z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void radiusHit(Level level, Player player, @Nullable ParticleOptions type, List<LivingEntity> hitEntities, Vector3d pos, float pitchRaw, float yawRaw, float radius) {
        for (int i = 0; i < 360; i += 10) {
            double pitch = (double)(pitchRaw + 90.0f) * Math.PI / 180.0;
            double yaw = (double)(yawRaw + 90.0f) * Math.PI / 180.0;
            double X = Math.sin(pitch) * Math.cos(yaw + (double)i) * (double)radius;
            double Y = Math.cos(pitch) * (double)radius;
            double Z = Math.sin(pitch) * Math.sin(yaw + (double)i) * (double)radius;
            AABB boundingBox = new AABB(pos.x, pos.y - 1.0 + (Math.random() - 0.5) * (double)0.2f, pos.z, pos.x + X, pos.y + Y + (Math.random() - 0.5) * (double)0.2f, pos.z + Z);
            List entities = level.m_45976_(Entity.class, boundingBox);
            for (Entity entity : entities) {
                LivingEntity livingEntity;
                if (!(entity instanceof LivingEntity) || hitEntities.contains(livingEntity = (LivingEntity)entity) || livingEntity.equals((Object)player) || !Utils.Entities.canHitTarget((LivingEntity)player, (LivingEntity)livingEntity)) continue;
                hitEntities.add(livingEntity);
            }
            X = Math.sin(pitch) * Math.cos(yaw + (double)i) * (double)radius * 0.75;
            Y = Math.cos(pitch) * (double)radius * 0.75;
            Z = Math.sin(pitch) * Math.sin(yaw + (double)i) * (double)radius * 0.75;
            if (type == null || level.m_5776_() || !(level instanceof ServerLevel)) continue;
            ServerLevel pServer = (ServerLevel)level;
            pServer.m_8767_(type, pos.x + X, pos.y + Y + (Math.random() - 0.5) * (double)0.2f, pos.z + Z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void stunNearby(Level level, LivingEntity caster, Vector3d pos, float pitchRaw, float yawRaw, float radius) {
        for (int i = 0; i < 360; i += 10) {
            double pitch = (double)(pitchRaw + 90.0f) * Math.PI / 180.0;
            double yaw = (double)(yawRaw + 90.0f) * Math.PI / 180.0;
            double X = Math.sin(pitch) * Math.cos(yaw + (double)i) * (double)radius;
            double Y = Math.cos(pitch) * (double)radius;
            double Z = Math.sin(pitch) * Math.sin(yaw + (double)i) * (double)radius;
            AABB boundingBox = new AABB(pos.x, pos.y - 1.0 + (Math.random() - 0.5) * (double)0.2f, pos.z, pos.x + X, pos.y + Y + (Math.random() - 0.5) * (double)0.2f, pos.z + Z);
            List entities = level.m_45976_(Entity.class, boundingBox);
            for (Entity entity : entities) {
                LivingEntity livingEntity;
                if (!(entity instanceof LivingEntity) || (livingEntity = (LivingEntity)entity).equals((Object)caster) || !Utils.Entities.canHitTarget((LivingEntity)caster, (LivingEntity)livingEntity)) continue;
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)EffectsRegistry.STUN.get(), 30, 0));
            }
        }
    }

    public static ItemStack getProjectile(Player player, ItemStack pShootable) {
        Boolf predicate = stack -> stack.m_41720_() instanceof GunpowderCharge;
        return Utils.Items.getProjectile((Player)player, (ItemStack)pShootable, (Boolf)predicate);
    }

    public static boolean isCurable(MobEffectInstance e) {
        MobEffect effect = e.m_19544_();
        return !effect.m_19486_() && !effect.m_8093_();
    }

    public static boolean onePerTypeEquip(SlotContext slotContext, ItemStack stack) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        List curioSlots = CuriosApi.getCuriosHelper().findCurios(slotContext.getWearer(), stack.m_41720_());
        for (SlotResult slot : curioSlots) {
            items.add(slot.stack());
        }
        return items.isEmpty() || slotContext.cosmetic();
    }

    public static void addList(List<Item> list, Item ... T) {
        Collections.addAll(list, T);
    }
}

