/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.level.portal;

import com.idark.valoria.registries.BlockRegistry;
import com.idark.valoria.registries.MiscRegistry;
import com.idark.valoria.registries.block.types.ValoriaPortalFrame;
import com.idark.valoria.registries.level.LevelGen;
import com.idark.valoria.registries.level.portal.BaseTeleporter;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class ValoriaTeleporter
extends BaseTeleporter
implements ITeleporter {
    protected final ServerLevel level;

    public ValoriaTeleporter(ServerLevel pLevel, BlockPos pos, boolean insideDim) {
        super(pos, insideDim, (ResourceKey<PoiType>)MiscRegistry.VALORIA_PORTAL.getKey());
        this.level = pLevel;
    }

    public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        entity.m_20091_();
        return this.findPlayerMadePortal(destWorld, entity);
    }

    private PortalInfo findPlayerMadePortal(ServerLevel level, Entity entity) {
        BlockPos pos = entity.m_20183_();
        PoiManager poiManager = level.m_8904_();
        poiManager.m_27056_((LevelReader)level, pos, 256);
        Optional<PoiRecord> optional = poiManager.m_27166_(poiType -> poiType.m_203565_(poi), pos, 256, PoiManager.Occupancy.ANY).sorted(Comparator.comparingDouble(poi -> poi.m_27257_().m_123331_((Vec3i)pos)).thenComparingInt(poi -> poi.m_27257_().m_123342_())).findFirst();
        if (optional.isEmpty()) {
            BlockUtil.FoundRectangle rectangle = this.createPortal(level, entity);
            BlockPos blockpos = rectangle.f_124348_;
            level.m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(blockpos), 3, (Object)blockpos);
            return new PortalInfo(new Vec3((double)(rectangle.f_124348_.m_123341_() + 2), (double)rectangle.f_124348_.m_123342_(), (double)(rectangle.f_124348_.m_123343_() + 2)), Vec3.f_82478_, entity.m_146909_(), entity.m_146908_());
        }
        BlockPos blockpos = optional.get().m_27257_();
        if (level.m_46472_() == LevelGen.VALORIA_KEY) {
            return new PortalInfo(new Vec3((double)((float)blockpos.m_123341_() + 1.5f), (double)blockpos.m_123342_(), (double)((float)blockpos.m_123343_() + 1.5f)), Vec3.f_82478_, entity.m_146909_(), entity.m_146908_());
        }
        return new PortalInfo(new Vec3((double)((float)blockpos.m_123341_() - 0.5f), (double)blockpos.m_123342_(), (double)((float)blockpos.m_123343_() - 0.5f)), Vec3.f_82478_, entity.m_146909_(), entity.m_146908_());
    }

    private BlockUtil.FoundRectangle createPortal(ServerLevel level, Entity entity) {
        PoiManager poimanager = level.m_8904_();
        poimanager.m_27056_((LevelReader)level, entity.m_20183_(), 256);
        BlockUtil.FoundRectangle rectangle = this.createPortal(level, entity.m_20183_(), ((Block)BlockRegistry.valoriaPortal.get()).m_49966_(), (BlockState)((Block)BlockRegistry.valoriaPortalFrame.get()).m_49966_().m_61124_((Property)ValoriaPortalFrame.GENERATED, (Comparable)Boolean.valueOf(true))).get();
        BlockPos blockpos = rectangle.f_124348_.m_7918_(0, 0, 0);
        level.m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(blockpos), 3, (Object)blockpos);
        return new BlockUtil.FoundRectangle(blockpos, 3, 3);
    }

    @Override
    public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destinationWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        entity = repositionEntity.apply(true);
        return entity;
    }

    public Optional<BlockUtil.FoundRectangle> createPortal(ServerLevel world, BlockPos pos, BlockState portal, BlockState frame) {
        pos = new BlockPos(pos.m_123341_(), this.getHeight(world, 90, pos.m_123341_(), pos.m_123343_(), (Block)BlockRegistry.voidGrass.get()), pos.m_123343_());
        for (int x = -2; x < 3; ++x) {
            for (int z = -2; z < 3; ++z) {
                if (Math.abs(x) < 2 && Math.abs(z) < 2) {
                    world.m_7731_(pos.m_7918_(x, 0, z), portal, 3);
                    continue;
                }
                if (Math.abs(z) < 2) {
                    if (x == -2) {
                        world.m_7731_(pos.m_7918_(x, 0, z), (BlockState)frame.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.EAST), 3);
                        continue;
                    }
                    if (x != 2) continue;
                    world.m_7731_(pos.m_7918_(x, 0, z), (BlockState)frame.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.WEST), 3);
                    continue;
                }
                if (Math.abs(x) >= 2) continue;
                if (z == -2) {
                    world.m_7731_(pos.m_7918_(x, 0, z), (BlockState)frame.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.SOUTH), 3);
                    continue;
                }
                world.m_7731_(pos.m_7918_(x, 0, z), (BlockState)frame.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH), 3);
            }
        }
        return Optional.of(new BlockUtil.FoundRectangle(pos, 3, 3));
    }
}

