/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types.ranged;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.idark.valoria.Valoria;
import com.idark.valoria.registries.BlockRegistry;
import com.idark.valoria.registries.ItemsRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.entity.projectile.ThrownSpearEntity;
import com.idark.valoria.registries.item.types.builders.AbstractSpearBuilder;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.Tridot;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.common.registry.item.AttributeRegistry;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;

public class SpearItem
extends SwordItem
implements Vanishable {
    private final Supplier<Multimap<Attribute, AttributeModifier>> attributeModifiers = Suppliers.memoize(this::createAttributes);
    public final float attackDamage;
    public final float attackSpeed;
    public final float projectileDamage;
    public final boolean throwable;
    public float chance = 1.0f;
    public final ImmutableList<MobEffectInstance> effects;
    public ArcRandom arcRandom = Tmp.rnd;
    public static final Set<ToolAction> SPEAR = SpearItem.of(ToolActions.SWORD_DIG);

    public SpearItem(Builder builder) {
        super(builder.tier, (int)builder.attackDamageIn, builder.attackSpeedIn, builder.itemProperties);
        this.attackDamage = builder.attackDamageIn;
        this.attackSpeed = builder.attackSpeedIn;
        this.projectileDamage = builder.projectileDamageIn;
        this.effects = builder.effects;
        this.throwable = builder.throwable;
        this.chance = builder.chance;
    }

    @Deprecated
    public SpearItem(Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builderIn, MobEffectInstance ... pEffects) {
        super(tier, (int)attackDamageIn, attackSpeedIn, builderIn);
        this.attackDamage = attackDamageIn + tier.m_6631_();
        this.attackSpeed = attackSpeedIn;
        this.projectileDamage = attackDamageIn + tier.m_6631_() + 3.0f;
        this.effects = ImmutableList.copyOf((Object[])pEffects);
        this.throwable = true;
    }

    @Deprecated
    public SpearItem(Tier tier, float attackDamageIn, float attackSpeedIn, float pChance, Item.Properties builderIn, MobEffectInstance ... pEffects) {
        super(tier, (int)attackDamageIn, attackSpeedIn, builderIn);
        this.attackDamage = attackDamageIn + tier.m_6631_();
        this.attackSpeed = attackSpeedIn;
        this.projectileDamage = attackDamageIn + tier.m_6631_() + 3.0f;
        this.effects = ImmutableList.copyOf((Object[])pEffects);
        this.chance = pChance;
        this.throwable = true;
    }

    @Deprecated
    public SpearItem(Tier tier, float attackDamageIn, float attackSpeedIn, boolean pThrowable, Item.Properties builderIn) {
        super(tier, (int)attackDamageIn, attackSpeedIn, builderIn);
        this.attackDamage = attackDamageIn + tier.m_6631_();
        this.attackSpeed = attackSpeedIn;
        this.throwable = pThrowable;
        this.projectileDamage = 0.0f;
        this.effects = ImmutableList.of();
    }

    private static Set<ToolAction> of(ToolAction ... actions) {
        return Stream.of(actions).collect(Collectors.toCollection(Sets::newIdentityHashSet));
    }

    public Multimap<Attribute, AttributeModifier> createAttributes() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        if (this.projectileDamage > 0.0f) {
            builder.put((Object)((Attribute)AttributeRegistry.PROJECTILE_DAMAGE.get()), (Object)new AttributeModifier(Tridot.BASE_PROJECTILE_DAMAGE_UUID, "Tool modifier", (double)this.projectileDamage, AttributeModifier.Operation.ADDITION));
        }
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.attackSpeed, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(Valoria.BASE_ENTITY_REACH_UUID, "Spear modifier", 1.0, AttributeModifier.Operation.ADDITION));
        return builder.build();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchant) {
        return enchant.f_44672_.m_7454_(stack.m_41720_()) || this.throwable && (enchant == Enchantments.f_44961_ || enchant == Enchantments.f_44955_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (this.throwable && !playerIn.m_6144_()) {
            playerIn.m_6672_(handIn);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        Utils.Entities.applyWithChance((LivingEntity)pTarget, this.effects, (float)this.chance, (ArcRandom)this.arcRandom);
        return super.m_7579_(pStack, pTarget, pAttacker);
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player playerEntity = (Player)entityLiving;
            int i = this.m_8105_(stack) - timeLeft;
            if (i >= 6) {
                if (!worldIn.f_46443_) {
                    stack.m_41622_(1, (LivingEntity)playerEntity, player -> player.m_21190_(entityLiving.m_7655_()));
                    ThrownSpearEntity spear = this.shootProjectile(stack, worldIn, playerEntity);
                    worldIn.m_7967_((Entity)spear);
                    worldIn.m_6269_(null, (Entity)spear, (SoundEvent)SoundsRegistry.SPEAR_THROW.get(), SoundSource.PLAYERS, 1.0f, 0.9f);
                    if (!playerEntity.m_150110_().f_35937_) {
                        playerEntity.m_150109_().m_36057_(stack);
                    }
                }
                playerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    @NotNull
    private ThrownSpearEntity shootProjectile(ItemStack stack, Level worldIn, Player playerEntity) {
        ThrownSpearEntity spear = new ThrownSpearEntity(worldIn, (LivingEntity)playerEntity, stack);
        int pierceLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44961_, (ItemStack)stack);
        if (pierceLevel > 0) {
            spear.m_36767_((byte)pierceLevel);
        }
        if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44981_, (ItemStack)stack) > 0) {
            spear.m_20254_(100);
        }
        spear.setEffectsFromList(this.effects);
        spear.m_37251_((Entity)playerEntity, playerEntity.m_146909_(), playerEntity.m_146908_(), 0.0f, 3.0f, 1.0f);
        if (playerEntity.m_150110_().f_35937_) {
            spear.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        return spear;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.attributeModifiers.get() : super.m_7167_(equipmentSlot);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level worldIn = context.m_43725_();
        RandomSource rand = worldIn.m_213780_();
        BlockState state = worldIn.m_8055_(context.m_8083_());
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        InteractionHand handIn = context.m_43724_();
        if (state.m_60713_((Block)BlockRegistry.chargedVoidPillar.get()) || state.m_60713_((Block)BlockRegistry.voidPillarAmethyst.get())) {
            worldIn.m_5594_(player, player.m_20183_(), SoundEvents.f_12375_, SoundSource.BLOCKS, 1.0f, 1.0f);
            worldIn.m_5594_(player, player.m_20183_(), SoundEvents.f_12376_, SoundSource.BLOCKS, 1.0f, 1.0f);
            for (int i = 0; i < 16; ++i) {
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_() + rand.m_188500_(), (double)((float)pos.m_123342_() + 0.5f) + rand.m_188500_() * 1.1, (double)((float)pos.m_123343_() + 0.5f) + rand.m_188500_(), 0.0, 0.05, 0.0);
            }
            worldIn.m_46597_(pos, (BlockState)((Block)BlockRegistry.voidPillar.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_))));
            if (!worldIn.f_46443_ && !player.m_150110_().f_35937_) {
                worldIn.m_7967_((Entity)new ItemEntity(worldIn, player.m_20185_(), player.m_20186_(), player.m_20189_(), ((Item)ItemsRegistry.unchargedShard.get()).m_7968_()));
                stack.m_41622_(10, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(handIn));
            }
            return InteractionResult.SUCCESS;
        }
        return super.onItemUseFirst(stack, context);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        if (this.throwable) {
            if (stack.m_150930_((Item)ItemsRegistry.pyratiteSpear.get())) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.valoria.pyratite_spear").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237119_());
            }
            tooltip.add((Component)Component.m_237115_((String)"tooltip.valoria.spear").m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.m_237115_((String)"tooltip.valoria.spear_pillars").m_130940_(ChatFormatting.GRAY));
        Utils.Items.effectTooltip(this.effects, tooltip, (float)1.0f, (float)this.chance);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return SPEAR.contains(toolAction);
    }

    public static class Builder
    extends AbstractSpearBuilder<SpearItem> {
        public Builder(float attackDamageIn, float attackSpeedIn, Item.Properties itemProperties) {
            super(attackDamageIn, attackSpeedIn, itemProperties);
        }

        @Override
        public SpearItem build() {
            return new SpearItem(this);
        }
    }
}

