/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types.ranged;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.idark.valoria.registries.entity.projectile.ShurikenProjectile;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.Tridot;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.common.registry.item.AttributeRegistry;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;

public class ShurikenItem
extends Item {
    private final Multimap<Attribute, AttributeModifier> tridentAttributes;
    public final ImmutableList<MobEffectInstance> effects;
    public float chance = 1.0f;
    public ArcRandom arc = Tmp.rnd;

    public ShurikenItem(int damage, Item.Properties builderIn, float chance, MobEffectInstance ... pEffects) {
        super(builderIn);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)((Attribute)AttributeRegistry.PROJECTILE_DAMAGE.get()), (Object)new AttributeModifier(Tridot.BASE_PROJECTILE_DAMAGE_UUID, "Tool modifier", (double)damage, AttributeModifier.Operation.ADDITION));
        this.tridentAttributes = builder.build();
        this.chance = chance;
        this.effects = ImmutableList.copyOf((Object[])pEffects);
    }

    public ShurikenItem(int damage, Item.Properties builderIn, MobEffectInstance ... pEffects) {
        super(builderIn);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)((Attribute)AttributeRegistry.PROJECTILE_DAMAGE.get()), (Object)new AttributeModifier(Tridot.BASE_PROJECTILE_DAMAGE_UUID, "Tool modifier", (double)damage, AttributeModifier.Operation.ADDITION));
        this.tridentAttributes = builder.build();
        this.effects = ImmutableList.copyOf((Object[])pEffects);
    }

    public boolean m_6777_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player playerEntity = (Player)entityLiving;
            int i = this.m_8105_(stack) - timeLeft;
            if (i >= 4) {
                if (!worldIn.f_46443_) {
                    ShurikenProjectile shuriken = this.shootProjectile(stack, worldIn, playerEntity);
                    worldIn.m_7967_((Entity)shuriken);
                    worldIn.m_6269_(playerEntity, (Entity)shuriken, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (!playerEntity.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                }
                playerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    @NotNull
    private ShurikenProjectile shootProjectile(ItemStack stack, Level worldIn, Player playerEntity) {
        ShurikenProjectile shuriken = new ShurikenProjectile((LivingEntity)playerEntity, worldIn, stack);
        shuriken.setItem(stack);
        shuriken.setEffectsFromList(this.effects);
        shuriken.m_37251_((Entity)playerEntity, playerEntity.m_146909_(), playerEntity.m_146908_(), 0.0f, 2.5f, 3.0f);
        if (playerEntity.m_150110_().f_35937_) {
            shuriken.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        return shuriken;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (!playerIn.m_6144_()) {
            playerIn.m_6672_(handIn);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Utils.Entities.applyWithChance((LivingEntity)target, this.effects, (float)this.chance, (ArcRandom)this.arc);
        return super.m_7579_(stack, target, attacker);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.tridentAttributes : super.m_7167_(equipmentSlot);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        tooltip.add((Component)Component.m_237115_((String)"tooltip.valoria.shuriken").m_130940_(ChatFormatting.GRAY));
        Utils.Items.effectTooltip(this.effects, tooltip, (float)1.0f, (float)this.chance);
    }
}

