/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types.curio;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.idark.valoria.registries.item.types.builders.AbstractCurioBuilder;
import com.idark.valoria.registries.item.types.curio.CurioAccessoryItem;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import pro.komaru.tridot.common.registry.item.builders.AbstractArmorBuilder;
import top.theillusivec4.curios.api.SlotContext;

public class EyeNecklaceItem
extends CurioAccessoryItem {
    boolean isDark;

    public EyeNecklaceItem(NecklaceBuilder builder) {
        super(builder);
    }

    public void onInventoryTick(ItemStack stack, Level level, Player player, int slotIndex, int selectedIndex) {
        boolean flag;
        super.onInventoryTick(stack, level, player, slotIndex, selectedIndex);
        float time = level.m_46942_(0.0f) % 24000.0f;
        boolean bl = flag = time > 12000.0f && time < 24000.0f;
        if (flag != this.isDark) {
            this.isDark = flag;
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return super.getAttributeModifiers(slot, stack);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        AbstractCurioBuilder abstractCurioBuilder;
        LinkedHashMultimap m = LinkedHashMultimap.create();
        if (this.isDark) {
            return super.getAttributeModifiers(slotContext, uuid, stack);
        }
        if (!this.isDark && (abstractCurioBuilder = this.builder) instanceof NecklaceBuilder) {
            NecklaceBuilder neckBuilder = (NecklaceBuilder)abstractCurioBuilder;
            neckBuilder.negativeAttributeMap.forEach((arg_0, arg_1) -> EyeNecklaceItem.lambda$getAttributeModifiers$0(uuid, (Multimap)m, arg_0, arg_1));
        }
        return m;
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$0(UUID uuid, Multimap m, Supplier attrSupplier, AbstractArmorBuilder.AttributeData data) {
        AttributeModifier modifier1 = new AttributeModifier(uuid, "Attribute Modifier", (double)data.value(), data.operation());
        m.put((Object)((Attribute)attrSupplier.get()), (Object)modifier1);
    }

    public static class NecklaceBuilder
    extends AbstractCurioBuilder<EyeNecklaceItem, NecklaceBuilder> {
        public Multimap<Supplier<Attribute>, AbstractArmorBuilder.AttributeData> negativeAttributeMap = HashMultimap.create();

        public NecklaceBuilder(Tier tier, Item.Properties properties) {
            super(tier, properties);
        }

        public NecklaceBuilder addNegativeAttrs(Multimap<Supplier<Attribute>, AbstractArmorBuilder.AttributeData> map) {
            this.negativeAttributeMap.putAll(map);
            return this;
        }

        public NecklaceBuilder setNegativeAttrs(Multimap<Supplier<Attribute>, AbstractArmorBuilder.AttributeData> map) {
            this.negativeAttributeMap = map;
            return this;
        }

        public NecklaceBuilder addNegativeAttr(Supplier<Attribute> attribute, AbstractArmorBuilder.AttributeData mod) {
            this.negativeAttributeMap.put(attribute, (Object)mod);
            return this;
        }

        @Override
        public EyeNecklaceItem build() {
            return new EyeNecklaceItem(this);
        }
    }
}

