/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types.builders;

import com.google.common.collect.ImmutableList;
import com.idark.valoria.registries.ItemTierRegistry;
import com.idark.valoria.registries.item.types.ranged.SpearItem;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;

public abstract class AbstractSpearBuilder<T extends SpearItem> {
    public Tier tier = ItemTierRegistry.NONE;
    public Item.Properties itemProperties;
    public ImmutableList<MobEffectInstance> effects = ImmutableList.of();
    public float attackDamageIn;
    public float projectileDamageIn;
    public float attackSpeedIn;
    public float chance = 1.0f;
    public boolean throwable = true;

    public AbstractSpearBuilder(float attackDamageIn, float attackSpeedIn, Item.Properties itemProperties) {
        this.attackDamageIn = attackDamageIn + this.tier.m_6631_();
        this.attackSpeedIn = attackSpeedIn;
        this.projectileDamageIn = attackDamageIn + this.tier.m_6631_() + 3.0f;
        this.itemProperties = itemProperties;
    }

    public AbstractSpearBuilder<T> setThrowable(boolean throwable) {
        this.throwable = throwable;
        return this;
    }

    public AbstractSpearBuilder<T> setTier(Tier tier) {
        this.tier = tier;
        return this;
    }

    public AbstractSpearBuilder<T> setProjectileDamage(float projectileDamageIn) {
        this.projectileDamageIn = projectileDamageIn;
        return this;
    }

    public AbstractSpearBuilder<T> setEffects(float chance, MobEffectInstance ... pEffects) {
        this.chance = chance;
        this.effects = ImmutableList.copyOf((Object[])pEffects);
        return this;
    }

    public AbstractSpearBuilder<T> setEffects(MobEffectInstance ... pEffects) {
        this.effects = ImmutableList.copyOf((Object[])pEffects);
        return this;
    }

    public abstract T build();
}

