/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types.builders;

import com.google.common.collect.ImmutableList;
import com.idark.valoria.client.model.animations.SpinAttackAnimation;
import com.idark.valoria.registries.ItemTierRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.item.types.ScytheItem;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import pro.komaru.tridot.api.render.animation.ItemAnimation;
import pro.komaru.tridot.util.math.Interp;

public abstract class AbstractScytheBuilder<T extends ScytheItem> {
    public Tier tier = ItemTierRegistry.NONE;
    public Item.Properties itemProperties;
    public SoundEvent attackSound = (SoundEvent)SoundsRegistry.SWIFTSLICE.get();
    public SoundEvent cooldownSound = (SoundEvent)SoundsRegistry.RECHARGE.get();
    public float attackDamageIn;
    public float attackSpeedIn;
    public float chance = 1.0f;
    public int useTime = 7;
    public int attackUsages = 1;
    public int attackDelay = 5;
    public int minCooldownTime = 10;
    public int cooldownTime = 60;
    public float attackRadius = 3.0f;
    public float screenShakeIntensity = 0.35f;
    public int screenShakeDuration = 4;
    public ItemAnimation animation = new SpinAttackAnimation();
    public Interp screenShakeEasing = Interp.circleOut;
    public ImmutableList<MobEffectInstance> effects = ImmutableList.of();
    public ParticleOptions particleOptions = ParticleTypes.f_123759_;

    public AbstractScytheBuilder(float attackDamageIn, float attackSpeedIn, Item.Properties itemProperties) {
        this.attackDamageIn = attackDamageIn;
        this.attackSpeedIn = attackSpeedIn;
        this.itemProperties = itemProperties;
    }

    public AbstractScytheBuilder<T> setTier(Tier tier) {
        this.tier = tier;
        return this;
    }

    public AbstractScytheBuilder<T> setUseTIme(int useTime) {
        this.useTime = useTime;
        return this;
    }

    public AbstractScytheBuilder<T> setUseAnimation(ItemAnimation animation) {
        this.animation = animation;
        return this;
    }

    public AbstractScytheBuilder<T> setScreenShake(float screenShakeIntensity, int screenShakeDuration) {
        this.screenShakeIntensity = screenShakeIntensity;
        this.screenShakeDuration = screenShakeDuration;
        return this;
    }

    public AbstractScytheBuilder<T> setScreenShakeEasing(Interp easing) {
        this.screenShakeEasing = easing;
        return this;
    }

    public AbstractScytheBuilder<T> setAttackCount(int attackUsages, int attackDelay) {
        this.attackUsages = attackUsages;
        this.attackDelay = attackDelay;
        return this;
    }

    public AbstractScytheBuilder<T> setAttackSound(SoundEvent event) {
        this.attackSound = event;
        return this;
    }

    public AbstractScytheBuilder<T> setCooldownSound(SoundEvent event) {
        this.cooldownSound = event;
        return this;
    }

    public AbstractScytheBuilder<T> setParticles(ParticleOptions particleOptions) {
        this.particleOptions = particleOptions;
        return this;
    }

    public AbstractScytheBuilder<T> setEffects(float chance, MobEffectInstance ... pEffects) {
        this.chance = chance;
        this.effects = ImmutableList.copyOf((Object[])pEffects);
        return this;
    }

    public AbstractScytheBuilder<T> setEffects(MobEffectInstance ... pEffects) {
        this.effects = ImmutableList.copyOf((Object[])pEffects);
        return this;
    }

    public AbstractScytheBuilder<T> setCooldownTime(int minCooldownTime, int cooldownTime) {
        this.minCooldownTime = minCooldownTime;
        this.cooldownTime = cooldownTime;
        return this;
    }

    public AbstractScytheBuilder<T> setAttackRadius(float distance) {
        this.attackRadius = distance;
        return this;
    }

    public abstract T build();
}

