/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types.builders;

import com.google.common.collect.ImmutableList;
import com.idark.valoria.registries.ItemTierRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.item.types.KatanaItem;
import java.awt.Color;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;

public abstract class AbstractKatanaBuilder<T extends KatanaItem> {
    public Tier tier = ItemTierRegistry.NONE;
    public Item.Properties itemProperties;
    public ResourceLocation texture = new ResourceLocation("valoria", "textures/gui/overlay/speedlines.png");
    public SoundEvent dashSound = (SoundEvent)SoundsRegistry.SWIFTSLICE.get();
    public SoundEvent cooldownSound = (SoundEvent)SoundsRegistry.RECHARGE.get();
    public SoundEvent chargedSound;
    public Color dashColor;
    public boolean usePacket = false;
    public boolean hasLargeModel = true;
    public float attackDamageIn;
    public float attackSpeedIn;
    public float chance = 1.0f;
    public int overlayTime = 35;
    public int cooldownTime = 75;
    public int chargeTime = 0;
    public float dashDist = 1.0f;
    public ImmutableList<MobEffectInstance> effects = ImmutableList.of();
    public ParticleOptions particleOptions = ParticleTypes.f_123759_;

    public AbstractKatanaBuilder(float attackDamageIn, float attackSpeedIn, Item.Properties itemProperties) {
        this.attackDamageIn = attackDamageIn;
        this.attackSpeedIn = attackSpeedIn;
        this.itemProperties = itemProperties;
    }

    public AbstractKatanaBuilder<T> setTier(Tier tier) {
        this.tier = tier;
        return this;
    }

    public AbstractKatanaBuilder<T> setDashSound(SoundEvent event) {
        this.dashSound = event;
        return this;
    }

    public AbstractKatanaBuilder<T> setCooldownSound(SoundEvent event) {
        this.cooldownSound = event;
        return this;
    }

    public AbstractKatanaBuilder<T> setChargedSound(SoundEvent event) {
        this.chargedSound = event;
        return this;
    }

    public AbstractKatanaBuilder<T> setParticles(ParticleOptions particleOptions) {
        this.particleOptions = particleOptions;
        return this;
    }

    public AbstractKatanaBuilder<T> usePacket(Color color) {
        this.usePacket = true;
        this.dashColor = color;
        return this;
    }

    public AbstractKatanaBuilder<T> removeLargeModelCheck() {
        this.hasLargeModel = false;
        return this;
    }

    public AbstractKatanaBuilder<T> setEffects(float chance, MobEffectInstance ... pEffects) {
        this.chance = chance;
        this.effects = ImmutableList.copyOf((Object[])pEffects);
        return this;
    }

    public AbstractKatanaBuilder<T> setEffects(MobEffectInstance ... pEffects) {
        this.effects = ImmutableList.copyOf((Object[])pEffects);
        return this;
    }

    public AbstractKatanaBuilder<T> setTimeToCharge(int useTime) {
        this.chargeTime = useTime;
        return this;
    }

    public AbstractKatanaBuilder<T> setOverlayTime(int time) {
        this.overlayTime = time;
        return this;
    }

    public AbstractKatanaBuilder<T> setCooldownTime(int cooldownTime) {
        this.cooldownTime = cooldownTime;
        return this;
    }

    public AbstractKatanaBuilder<T> setDashDistance(float distance) {
        this.dashDist = distance;
        return this;
    }

    public AbstractKatanaBuilder<T> setOverlay(ResourceLocation texture) {
        this.texture = texture;
        return this;
    }

    public abstract T build();
}

