/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.idark.valoria.Valoria;
import com.idark.valoria.registries.AttributeReg;
import com.idark.valoria.registries.item.types.builders.AbstractScytheBuilder;
import com.idark.valoria.util.ValoriaUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Vector3d;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.api.interfaces.CooldownNotifyItem;
import pro.komaru.tridot.api.interfaces.CooldownReductionItem;
import pro.komaru.tridot.api.interfaces.DashItem;
import pro.komaru.tridot.api.interfaces.ICustomAnimationItem;
import pro.komaru.tridot.api.interfaces.RadiusItem;
import pro.komaru.tridot.api.interfaces.SpinAttackItem;
import pro.komaru.tridot.api.render.animation.ItemAnimation;
import pro.komaru.tridot.client.render.screenshake.PositionedScreenshakeInstance;
import pro.komaru.tridot.client.render.screenshake.ScreenshakeHandler;
import pro.komaru.tridot.client.render.screenshake.ScreenshakeInstance;
import pro.komaru.tridot.common.registry.EnchantmentsRegistry;
import pro.komaru.tridot.common.registry.item.TooltipComponentItem;
import pro.komaru.tridot.common.registry.item.components.AbilityComponent;
import pro.komaru.tridot.common.registry.item.components.SeparatorComponent;
import pro.komaru.tridot.common.registry.item.components.TextComponent;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.comps.phys.Pos3;
import pro.komaru.tridot.util.math.ArcRandom;
import pro.komaru.tridot.util.struct.data.Seq;

public class ScytheItem
extends SwordItem
implements ICustomAnimationItem,
CooldownNotifyItem,
RadiusItem,
SpinAttackItem,
DashItem,
CooldownReductionItem,
TooltipComponentItem {
    public AbstractScytheBuilder<? extends ScytheItem> builder;
    public Multimap<Attribute, AttributeModifier> defaultModifiers;
    public final ArcRandom arcRandom = Tmp.rnd;
    public int usageCount;

    public ScytheItem(AbstractScytheBuilder<? extends ScytheItem> builderIn) {
        super(builderIn.tier, (int)builderIn.attackDamageIn, builderIn.attackSpeedIn, builderIn.itemProperties);
        this.builder = builderIn;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)(builderIn.attackDamageIn + builderIn.tier.m_6631_()), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)builderIn.attackSpeedIn, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)AttributeReg.ATTACK_RADIUS.get()), (Object)new AttributeModifier(Valoria.BASE_ATTACK_RADIUS_UUID, "Tool modifier", (double)builderIn.attackRadius, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public ScytheItem(Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builderIn) {
        this(new Builder(attackDamageIn, attackSpeedIn, builderIn).setTier(tier));
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(pEquipmentSlot);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (!playerIn.m_6144_() && handIn != InteractionHand.OFF_HAND) {
            playerIn.m_6672_(handIn);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public SoundEvent getSoundEvent() {
        return this.builder.cooldownSound;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.CUSTOM;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemAnimation getAnimation(ItemStack stack) {
        return this.builder.animation;
    }

    public int m_8105_(ItemStack stack) {
        return this.builder.useTime;
    }

    public void applyCooldown(Player playerIn, int time) {
        for (Item item : ForgeRegistries.ITEMS) {
            if (!(item instanceof ScytheItem)) continue;
            playerIn.m_36335_().m_41524_(item, time);
        }
    }

    public void performEffects(LivingEntity targets, Player player) {
        targets.m_147240_((double)0.4f, player.m_20185_() - targets.m_20185_(), player.m_20189_() - targets.m_20189_());
        if (EnchantmentHelper.m_44914_((LivingEntity)player) > 0) {
            int i = EnchantmentHelper.m_44914_((LivingEntity)player);
            targets.m_20254_(i * 4);
        }
    }

    public void performAttack(Level level, ItemStack stack, Player player) {
        ArrayList<LivingEntity> hitEntities = new ArrayList<LivingEntity>();
        Vector3d pos = new Vector3d(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_());
        float damage = (float)player.m_21133_(Attributes.f_22281_) + EnchantmentHelper.m_44821_((LivingEntity)player);
        float radius = (float)player.m_21133_((Attribute)AttributeReg.ATTACK_RADIUS.get());
        CompoundTag tag = stack.m_41784_();
        this.usageCount = tag.m_128451_("usageCount");
        ++this.usageCount;
        tag.m_128405_("usageCount", this.usageCount);
        stack.m_41751_(tag);
        ValoriaUtils.radiusHit(level, stack, player, this.builder.particleOptions, hitEntities, pos, 0.0f, player.m_20155_().f_82471_, radius);
        if (this.usageCount > this.builder.attackUsages - 1) {
            int cooldown = hitEntities.isEmpty() ? this.builder.minCooldownTime : this.builder.cooldownTime;
            this.applyCooldown(player, this.getCooldownReduction(cooldown, stack));
            tag.m_128405_("usageCount", 0);
            stack.m_41751_(tag);
        } else {
            this.applyCooldown(player, this.builder.attackDelay);
        }
        for (LivingEntity entity : hitEntities) {
            if (!player.m_6779_(entity)) continue;
            entity.m_6469_(level.m_269111_().m_269075_(player), (damage + EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)entity.m_6336_())) * 1.35f);
            this.performEffects(entity, player);
            Utils.Entities.applyWithChance((LivingEntity)entity, this.builder.effects, (float)this.builder.chance, (ArcRandom)this.arcRandom);
            if (player.m_7500_()) continue;
            stack.m_41622_(hitEntities.size(), (LivingEntity)player, p_220045_0_ -> p_220045_0_.m_21166_(EquipmentSlot.MAINHAND));
        }
        ScreenshakeHandler.add((ScreenshakeInstance)new PositionedScreenshakeInstance(this.builder.screenShakeDuration, (Pos3)pro.komaru.tridot.util.phys.Vec3.from((Vec3)player.m_146892_()), 0.0f, 30.0f).intensity(this.builder.screenShakeIntensity).interp(this.builder.screenShakeEasing));
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entityLiving) {
        Player player = (Player)entityLiving;
        if (!player.m_21255_() && stack.getEnchantmentLevel((Enchantment)EnchantmentsRegistry.DASH.get()) > 0) {
            this.performDash(player, stack);
        }
        this.performAttack(level, stack, player);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        level.m_5594_(null, player.m_20097_(), this.builder.attackSound, SoundSource.PLAYERS, 1.0f, 1.0f);
        return stack;
    }

    public Seq<TooltipComponent> getTooltips(ItemStack pStack) {
        if (this.builder.attackUsages > 1) {
            return Seq.with((Object[])new TooltipComponent[]{new SeparatorComponent((Component)Component.m_237115_((String)"tooltip.valoria.abilities")), new AbilityComponent(Component.m_237115_((String)"tooltip.valoria.scythe").m_130940_(ChatFormatting.GRAY), Valoria.loc("textures/gui/tooltips/circular_strike.png")), new TextComponent(Component.m_237110_((String)"tooltip.valoria.usage_count", (Object[])new Object[]{this.builder.attackUsages}).m_130940_(ChatFormatting.GRAY)), new TextComponent(Component.m_237115_((String)"tooltip.valoria.hold_rmb").m_130938_(style -> style.m_131150_(Valoria.FONT)))});
        }
        return Seq.with((Object[])new TooltipComponent[]{new SeparatorComponent((Component)Component.m_237115_((String)"tooltip.valoria.abilities")), new AbilityComponent(Component.m_237115_((String)"tooltip.valoria.scythe").m_130940_(ChatFormatting.GRAY), Valoria.loc("textures/gui/tooltips/circular_strike.png")), new TextComponent(Component.m_237115_((String)"tooltip.valoria.hold_rmb").m_130938_(style -> style.m_131150_(Valoria.FONT)))});
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        Utils.Items.effectTargetTooltip(this.builder.effects, tooltip, (float)1.0f, (float)this.builder.chance);
    }

    public static class Builder
    extends AbstractScytheBuilder<ScytheItem> {
        public Builder(float attackDamageIn, float attackSpeedIn, Item.Properties itemProperties) {
            super(attackDamageIn, attackSpeedIn, itemProperties);
        }

        @Override
        public ScytheItem build() {
            return new ScytheItem(this);
        }
    }
}

