/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types;

import com.idark.valoria.client.particle.ParticleEffects;
import com.idark.valoria.registries.ItemsRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.api.interfaces.IGuiRenderItem;
import pro.komaru.tridot.api.interfaces.ParticleItemEntity;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.render.RenderBuilder;
import pro.komaru.tridot.client.render.TridotRenderTypes;
import pro.komaru.tridot.util.Col;

public class CoreItem
extends Item
implements ParticleItemEntity,
IGuiRenderItem {
    private final String coreName;
    public ParticleType<?> particle;
    private final ColorParticleData color;
    private final int givenCores;

    public CoreItem(@NotNull ParticleType<?> pType, Item.Properties pProperties, String pCoreID) {
        super(pProperties);
        this.particle = pType;
        this.coreName = pCoreID;
        this.color = null;
        this.givenCores = 0;
    }

    public CoreItem(@NotNull ParticleType<?> pType, Item.Properties pProperties, int pGivenCores, Col pColor, Col pColorTo, String pCoreID) {
        super(pProperties);
        this.particle = pType;
        this.givenCores = pGivenCores;
        this.color = ColorParticleData.create((Col)pColor, (Col)pColorTo).build();
        this.coreName = pCoreID;
    }

    public CoreItem(@NotNull ParticleType<?> pType, Item.Properties pProperties, int pGivenCores, Col pColor, Col pColorTo, RegistryObject<Item> item) {
        super(pProperties);
        this.particle = pType;
        this.givenCores = pGivenCores;
        this.color = ColorParticleData.create((Col)pColor, (Col)pColorTo).build();
        this.coreName = item.getId().m_135815_();
    }

    public String getCoreName() {
        return this.coreName;
    }

    public ColorParticleData getColor() {
        return this.color;
    }

    public Col getCoreColor() {
        return new Col(this.getColor().r1, this.getColor().g1, this.getColor().b1).darker();
    }

    public int getGivenCores() {
        return this.givenCores;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.valoria.core").m_130940_(ChatFormatting.GRAY));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticles(Level level, ItemEntity entity) {
        ParticleEffects.spawnItemParticles(level, entity, this.particle, this.getColor());
    }

    public void onGuiRender(GuiGraphics gfx, LivingEntity livingEntity, Level level, ItemStack itemStack, int x, int y, int seed, int guiOffset) {
        PoseStack poseStack = gfx.m_280168_();
        if (itemStack.m_150930_((Item)ItemsRegistry.voidCore.get())) {
            poseStack.m_85836_();
            poseStack.m_252880_((float)(x + 8), (float)(y + 9), 100.0f);
            RenderBuilder.create().setRenderType(TridotRenderTypes.TRANSLUCENT_TEXTURE).setUV(Utils.Render.getSprite((String)"valoria", (String)"particle/smoke")).setColor(Col.fromHex((String)"562a8a")).setAlpha(1.0f).renderCenteredQuad(poseStack, 15.0f).endBatch();
            poseStack.m_85849_();
        } else {
            poseStack.m_85836_();
            poseStack.m_252880_((float)(x + 8), (float)(y + 9), 100.0f);
            RenderBuilder.create().setRenderType(TridotRenderTypes.ADDITIVE_TEXTURE).setUV(Utils.Render.getSprite((String)"valoria", (String)"particle/smoke")).setColor(this.getColor().r1, this.getColor().g1, this.getColor().b1).setAlpha(1.0f).renderCenteredQuad(poseStack, 14.0f).endBatch();
            poseStack.m_85849_();
        }
    }
}

