/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types;

import com.idark.valoria.registries.item.types.TexturedSpawnEggItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.util.Col;

public class BossSummonableItem
extends TexturedSpawnEggItem {
    private final Supplier<? extends EntityType<? extends Mob>> typeSupplier;
    private final float expandValue;

    public BossSummonableItem(Supplier<? extends EntityType<? extends Mob>> type, Item.Properties pProperties) {
        super(type, pProperties);
        this.typeSupplier = type;
        this.expandValue = 0.0f;
    }

    public BossSummonableItem(float expandValue, Supplier<? extends EntityType<? extends Mob>> type, Item.Properties pProperties) {
        super(type, pProperties);
        this.typeSupplier = type;
        this.expandValue = expandValue;
    }

    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        tooltip.add((Component)Component.m_237110_((String)"tooltip.valoria.boss_summonable", (Object[])new Object[]{this.getDefaultType().m_20676_()}).m_130940_(ChatFormatting.GRAY));
    }

    @Override
    public EntityType<?> m_43228_(@Nullable CompoundTag tag) {
        EntityType<?> type = super.m_43228_(tag);
        return type != null ? type : this.typeSupplier.get();
    }

    @Override
    protected EntityType<?> getDefaultType() {
        return this.typeSupplier.get();
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Player player;
        AABB spawnAABB;
        Level level = pContext.m_43725_();
        SpawnResult result = this.canSpawnHere(level, spawnAABB = this.getAABB(player = pContext.m_43723_(), this.getDefaultType().m_20615_(level)));
        if (result.success()) {
            return super.m_6225_(pContext);
        }
        double size = Math.floor(spawnAABB.m_82309_()) + 3.0;
        player.m_5661_((Component)Component.m_237110_((String)"tooltip.valoria.boss_summon_fail", (Object[])new Object[]{size + "x" + size}).m_130940_(ChatFormatting.GRAY), true);
        this.showParticleBox(level, spawnAABB);
        for (BlockPos pos : result.preventingBlocks) {
            if (!level.m_5776_()) continue;
            this.showBlockingParticles(level, pos);
        }
        return InteractionResult.FAIL;
    }

    public void showParticleBox(Level level, AABB box) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double step = 0.5;
        for (double x = box.f_82288_; x <= box.f_82291_; x += step) {
            for (double y = box.f_82289_; y <= box.f_82292_; y += step) {
                for (double z = box.f_82290_; z <= box.f_82293_; z += step) {
                    boolean onEdge;
                    boolean bl = onEdge = Mth.m_14082_((double)x, (double)box.f_82288_) || x + step > box.f_82291_ || Mth.m_14082_((double)y, (double)box.f_82289_) || y + step > box.f_82292_ || Mth.m_14082_((double)z, (double)box.f_82290_) || z + step > box.f_82293_;
                    if (!onEdge) continue;
                    server.m_8767_((ParticleOptions)ParticleTypes.f_123757_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void showBlockingParticles(Level level, BlockPos pos) {
        ParticleBuilder.create((RegistryObject)TridotParticles.SQUARE).setScaleData(GenericParticleData.create((float)0.05f).build()).setColorData(ColorParticleData.create((Col)Col.red).build()).setGravity(0.0f).setLifetime(60).setHasPhysics(false).spawnVoxelShape(level, new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), level.m_8055_(pos).m_60808_((BlockGetter)level, pos), 15).getParticleOptions();
    }

    @NotNull
    public AABB getAABB(Player player, Entity mob) {
        AABB mobBoundingBox = mob.m_20191_();
        Vec3 origin = player.m_146892_();
        Vec3 direction = player.m_20156_();
        BlockHitResult hitResult = player.m_9236_().m_45547_(new ClipContext(origin, origin.m_82549_(direction.m_82490_(5.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)player));
        BlockPos centerPos = hitResult.m_82425_().m_7494_();
        double width = mobBoundingBox.m_82362_() + (double)this.expandValue;
        double height = mobBoundingBox.m_82376_();
        double depth = mobBoundingBox.m_82385_() + (double)this.expandValue;
        double minX = (double)centerPos.m_123341_() - width / 2.0;
        double minY = centerPos.m_123342_();
        double minZ = (double)centerPos.m_123343_() - depth / 2.0;
        double maxX = (double)centerPos.m_123341_() + width / 2.0;
        double maxY = (double)centerPos.m_123342_() + height;
        double maxZ = (double)centerPos.m_123343_() + depth / 2.0;
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public SpawnResult canSpawnHere(Level world, AABB blockAABB) {
        int x;
        BlockPos min = new BlockPos((int)Math.floor(blockAABB.f_82288_), (int)Math.floor(blockAABB.f_82289_), (int)Math.floor(blockAABB.f_82290_));
        BlockPos max = new BlockPos((int)Math.floor(blockAABB.f_82291_), (int)Math.floor(blockAABB.f_82292_), (int)Math.floor(blockAABB.f_82293_));
        ArrayList<BlockPos> preventingBlocks = new ArrayList<BlockPos>();
        int baseY = min.m_123342_();
        for (x = min.m_123341_(); x <= max.m_123341_(); ++x) {
            for (int z = min.m_123343_(); z <= max.m_123343_(); ++z) {
                BlockPos groundPos = new BlockPos(x, baseY - 1, z);
                BlockState groundState = world.m_8055_(groundPos);
                if (!groundState.m_60795_() && groundState.m_280296_() && !world.m_6425_(groundPos).m_76170_()) continue;
                preventingBlocks.add(groundPos);
            }
        }
        for (x = min.m_123341_(); x <= max.m_123341_(); ++x) {
            for (int y = baseY; y <= max.m_123342_(); ++y) {
                for (int z = min.m_123343_(); z <= max.m_123343_(); ++z) {
                    BlockPos checkPos = new BlockPos(x, y, z);
                    BlockState state = world.m_8055_(checkPos);
                    if (state.m_60812_((BlockGetter)world, checkPos).m_83281_() && !world.m_6425_(checkPos).m_76170_() || state.m_247087_() || !(state.m_60800_((BlockGetter)world, checkPos) >= 0.0f)) continue;
                    preventingBlocks.add(checkPos);
                }
            }
        }
        return SpawnResult.checkResult(preventingBlocks);
    }

    public record SpawnResult(boolean success, List<BlockPos> preventingBlocks) {
        public static SpawnResult checkResult(List<BlockPos> preventingBlocks) {
            return new SpawnResult(preventingBlocks.isEmpty(), preventingBlocks);
        }
    }
}

