/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManipulatorRecipe
implements Recipe<Container> {
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    private final ResourceLocation id;
    private final String pCoreId;
    private final int cores;
    private final int time;

    public ManipulatorRecipe(ResourceLocation id, ItemStack output, String pCoreId, int cores, int time, Ingredient ... inputItems) {
        this.id = id;
        this.output = output;
        this.pCoreId = pCoreId;
        this.cores = cores;
        this.time = time;
        this.inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])inputItems);
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        boolean craft = true;
        for (int i = 0; i < 2; ++i) {
            if (((Ingredient)this.inputs.get(i)).test(pContainer.m_8020_(i))) continue;
            craft = false;
        }
        return craft;
    }

    public boolean m_5598_() {
        return true;
    }

    public int getTime() {
        return this.time;
    }

    public int getCoresNeeded() {
        return this.cores;
    }

    public ItemStack assemble(IItemHandler itemHandler) {
        ItemStack itemstack = this.output.m_41777_();
        CompoundTag compoundtag = itemHandler.getStackInSlot(0).m_41783_();
        if (compoundtag != null) {
            itemstack.m_41751_(compoundtag.m_6426_());
        }
        return itemstack;
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        ItemStack itemstack = this.output.m_41777_();
        CompoundTag compoundtag = pContainer.m_8020_(1).m_41783_();
        if (compoundtag != null) {
            itemstack.m_41751_(compoundtag.m_6426_());
        }
        return itemstack;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output;
    }

    public String getCore() {
        return this.pCoreId;
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<ManipulatorRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("valoria", "manipulator");

        @NotNull
        public ManipulatorRecipe fromJson(@NotNull ResourceLocation pRecipeId, @NotNull JsonObject pSerializedRecipe) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            String core = pSerializedRecipe.has("core") ? pSerializedRecipe.get("core").getAsString() : "empty";
            int cores = pSerializedRecipe.has("cores") ? GsonHelper.m_13927_((JsonObject)pSerializedRecipe, (String)"cores") : 0;
            int time = GsonHelper.m_13927_((JsonObject)pSerializedRecipe, (String)"time");
            JsonArray pIngredients = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredients");
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (JsonElement e : pIngredients) {
                inputs.add(Ingredient.m_43917_((JsonElement)e));
            }
            return new ManipulatorRecipe(pRecipeId, output, core, cores, time, inputs.toArray(new Ingredient[0]));
        }

        @Nullable
        public ManipulatorRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            Ingredient[] inputs = new Ingredient[pBuffer.readInt()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            }
            ItemStack output = pBuffer.m_130267_();
            String core = pBuffer.m_130277_();
            int cores = pBuffer.readInt();
            int time = pBuffer.readInt();
            return new ManipulatorRecipe(pRecipeId, output, core, cores, time, inputs);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, ManipulatorRecipe pRecipe) {
            pBuffer.writeInt(pRecipe.m_7527_().size());
            for (Ingredient input : pRecipe.m_7527_()) {
                input.m_43923_(pBuffer);
            }
            pBuffer.m_130055_(pRecipe.output);
            pBuffer.m_130070_(pRecipe.getCore());
            pBuffer.writeInt(pRecipe.getCoresNeeded());
            pBuffer.writeInt(pRecipe.getTime());
        }
    }

    public static class Type
    implements RecipeType<ManipulatorRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "manipulator";
    }
}

