/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.projectile;

import com.idark.valoria.client.particle.ParticleEffects;
import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.util.Pal;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pro.komaru.tridot.api.interfaces.TexturedArrow;
import pro.komaru.tridot.client.gfx.particle.GenericParticle;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.render.screenshake.PositionedScreenshakeInstance;
import pro.komaru.tridot.client.render.screenshake.ScreenshakeHandler;
import pro.komaru.tridot.client.render.screenshake.ScreenshakeInstance;
import pro.komaru.tridot.common.registry.entity.projectiles.AbstractTridotArrow;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.comps.phys.Pos3;

public class PyratiteArrow
extends AbstractTridotArrow
implements TexturedArrow {
    public PyratiteArrow(EntityType<? extends AbstractTridotArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public PyratiteArrow(Level pLevel, ItemStack thrown) {
        super((EntityType)EntityTypeRegistry.PYRATITE_ARROW.get(), pLevel);
        this.arrowItem = ItemStack.f_41583_;
        this.arrowItem = new ItemStack((ItemLike)thrown.m_41720_());
        this.f_36698_ = 4.0;
    }

    public PyratiteArrow(Level pLevel, LivingEntity pShooter, ItemStack thrown) {
        super((EntityType)EntityTypeRegistry.PYRATITE_ARROW.get(), pLevel, pShooter, thrown, 4.0);
    }

    protected void m_6532_(HitResult pResult) {
        super.m_6532_(pResult);
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.m_9236_().m_254849_(this.m_19749_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, Level.ExplosionInteraction.MOB);
        ScreenshakeHandler.add((ScreenshakeInstance)new PositionedScreenshakeInstance(3, (Pos3)pro.komaru.tridot.util.phys.Vec3.from((Vec3)this.m_20182_()), 0.0f, 30.0f).intensity(1.0f));
        this.m_146870_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticlesTrail() {
        if (!this.f_36703_) {
            Vec3 delta = this.m_20184_().m_82541_();
            Vec3 pos = new Vec3(this.m_20185_() + delta.m_7096_() * 1.5E-4, this.m_20186_() + delta.m_7098_() * 1.5E-4, this.m_20189_() + delta.m_7094_() * 1.5E-4);
            Vec3[] cachePos = new Vec3[]{new Vec3(pos.f_82479_, pos.f_82480_, pos.f_82481_)};
            Consumer<GenericParticle> target = p -> {
                Vec3 arrowPos = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
                float lenBetweenArrowAndParticle = (float)arrowPos.m_82546_(cachePos[0]).m_82553_();
                Vec3 vector = arrowPos.m_82546_(cachePos[0]);
                if (lenBetweenArrowAndParticle > 0.0f) {
                    cachePos[0] = cachePos[0].m_82549_(vector);
                    p.setPosition(cachePos[0]);
                }
            };
            ParticleEffects.smoothTrail(this.m_9236_(), target, pos, ColorParticleData.create((Col)Pal.pyratiteBright, (Col)Pal.pyratite).build());
            ParticleEffects.fireParticles(this.m_9236_(), pos, ColorParticleData.create((Col)Col.white, (Col)Pal.pyratite).build());
        }
    }

    public ResourceLocation getTexture() {
        return new ResourceLocation("valoria", "textures/entity/projectile/arrow/pyratite_arrow.png");
    }
}

