/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.projectile;

import com.idark.valoria.registries.EntityTypeRegistry;
import java.util.function.Consumer;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.RegistryObject;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.GenericParticle;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.behavior.TrailParticleBehavior;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.client.render.TridotRenderTypes;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.math.Interp;

public class LaserEntity
extends Projectile {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(LaserEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public LaserEntity(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    public LaserEntity(EntityType type, double x, double y, double z, Level worldIn) {
        this(type, worldIn);
        this.m_6034_(x, y, z);
    }

    public LaserEntity(Level worldIn, LivingEntity shooter) {
        this((EntityType)EntityTypeRegistry.LASER.get(), shooter.m_20185_(), shooter.m_20188_(), shooter.m_20189_(), worldIn);
        this.m_5602_((Entity)shooter);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticlesTrail() {
        Vec3 delta = this.m_20184_().m_82541_();
        Vec3 pos = new Vec3(this.m_20185_() + delta.m_7096_() * 1.5E-4, this.m_20186_() + delta.m_7098_() * 1.5E-4, this.m_20189_() + delta.m_7094_() * 1.5E-4);
        Vec3[] cachePos = new Vec3[]{new Vec3(pos.f_82479_, pos.f_82480_ + 0.5, pos.f_82481_)};
        Consumer<GenericParticle> target = p -> {
            Vec3 arrowPos = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
            float lenBetweenArrowAndParticle = (float)arrowPos.m_82546_(cachePos[0]).m_82553_();
            Vec3 vector = arrowPos.m_82546_(cachePos[0]);
            if (lenBetweenArrowAndParticle > 0.0f) {
                cachePos[0] = cachePos[0].m_82549_(vector);
                p.setPosition(cachePos[0]);
            }
        };
        ParticleBuilder.create((RegistryObject)TridotParticles.TRAIL).setRenderType(TridotRenderTypes.TRANSLUCENT_PARTICLE_TEXTURE).setBehavior(TrailParticleBehavior.create().build()).setColorData(ColorParticleData.create((Col)Col.fromHex((String)"b8202d"), (Col)Col.fromHex((String)"c4352b")).build()).setTransparencyData(GenericParticleData.create((float)1.0f, (float)0.0f).setEasing(Interp.sineOut).build()).setScaleData(GenericParticleData.create((float)0.85f).setEasing((Interp)Interp.exp5In).build()).addTickActor(target).setGravity(0.0f).setLifetime(12).spawn(this.m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        if (!this.m_9236_().f_46443_) {
            Entity entity = result.m_82443_();
            LivingEntity owner = (LivingEntity)this.m_19749_();
            entity.m_6469_(this.m_9236_().m_269111_().m_269299_((Entity)this, owner), this.getDamage());
            if (owner != null) {
                this.m_19970_(owner, entity);
            }
        }
    }

    protected void m_6532_(HitResult p_37628_) {
        super.m_6532_(p_37628_);
        if (!this.m_9236_().f_46443_) {
            this.m_146870_();
        }
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.spawnParticlesTrail();
        }
        Entity entity = this.m_19749_();
        if (this.m_9236_().f_46443_ || (entity == null || !entity.m_213877_()) && this.m_9236_().m_46805_(this.m_20183_())) {
            super.m_8119_();
            HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
            if (hitresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.m_6532_(hitresult);
            }
            this.m_20101_();
            Vec3 vec3 = this.m_20184_();
            if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
                double d0 = vec3.m_165924_();
                this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
                this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
                this.f_19859_ = this.m_146908_();
                this.f_19860_ = this.m_146909_();
            }
            double d5 = vec3.f_82479_;
            double d6 = vec3.f_82480_;
            double d1 = vec3.f_82481_;
            double d7 = this.m_20185_() + d5;
            double d2 = this.m_20186_() + d6;
            double d3 = this.m_20189_() + d1;
            double d4 = vec3.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)d5, (double)d1) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)d6, (double)d4) * 57.2957763671875));
            this.m_146926_(LaserEntity.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
            this.m_146922_(LaserEntity.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
            float f = 0.99f;
            float sqrt = (float)this.m_20184_().m_82553_();
            if (sqrt < 0.1f) {
                this.m_146870_();
            }
            this.m_20256_(vec3.m_82490_((double)f));
            this.m_6034_(d7, d2, d3);
        } else {
            this.m_146870_();
        }
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public boolean m_6469_(DamageSource damageSource, float damage) {
        return false;
    }
}

