/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.projectile;

import com.idark.valoria.registries.EntityTypeRegistry;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class Devourer
extends Entity
implements TraceableEntity {
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 22;
    private float damage;
    public final AnimationState attackAnimationState = new AnimationState();
    private boolean clientSideAttackStarted;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;

    public Devourer(EntityType<Devourer> entityEntityType, Level level) {
        super(entityEntityType, level);
    }

    public Devourer(Level pLevel, double pX, double pY, double pZ, float pYRot, int pWarmupDelay, LivingEntity pOwner) {
        this((EntityType<Devourer>)((EntityType)EntityTypeRegistry.DEVOURER.get()), pLevel);
        this.warmupDelayTicks = pWarmupDelay;
        this.damage = 5.0f;
        this.setOwner(pOwner);
        this.m_6034_(pX, pY, pZ);
        this.m_146922_(pYRot);
    }

    public Devourer(Level pLevel, double pX, double pY, double pZ, float pYRot, int pWarmupDelay, float pDamage, LivingEntity pOwner) {
        this((EntityType<Devourer>)((EntityType)EntityTypeRegistry.DEVOURER.get()), pLevel);
        this.warmupDelayTicks = pWarmupDelay;
        this.damage = pDamage;
        this.setOwner(pOwner);
        this.m_6034_(pX, pY, pZ);
        this.m_146922_(pYRot);
    }

    public Devourer setDamage(float damage) {
        this.damage = damage;
        return this;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.clientSideAttackStarted) {
                --this.lifeTicks;
                if (this.lifeTicks == 14) {
                    for (int i = 0; i < 12; ++i) {
                        double d0 = this.m_20185_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                        double d1 = this.m_20186_() + 0.05 + this.f_19796_.m_188500_();
                        double d2 = this.m_20189_() + (this.f_19796_.m_188500_() * 2.0 - 1.0) * (double)this.m_20205_() * 0.5;
                        double d3 = (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.3;
                        double d4 = 0.3 + this.f_19796_.m_188500_() * 0.3;
                        double d5 = (this.f_19796_.m_188500_() * 2.0 - 1.0) * 0.3;
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, d0, d1 + 1.0, d2, d3, d4, d5);
                    }
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (this.warmupDelayTicks == -8) {
                for (LivingEntity livingentity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(0.2, 0.0, 0.2))) {
                    this.dealDamageTo(livingentity);
                }
            }
            if (!this.sentSpikeEvent) {
                this.m_9236_().m_7605_((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.m_146870_();
            }
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        this.owner = pOwner;
        this.ownerUUID = pOwner == null ? null : pOwner.m_20148_();
    }

    public void m_7378_(CompoundTag pCompound) {
        this.warmupDelayTicks = pCompound.m_128451_("Warmup");
        if (pCompound.m_128403_("Owner")) {
            this.ownerUUID = pCompound.m_128342_("Owner");
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        pCompound.m_128405_("Warmup", this.warmupDelayTicks);
        if (this.ownerUUID != null) {
            pCompound.m_128362_("Owner", this.ownerUUID);
        }
    }

    protected void m_8097_() {
    }

    private void dealDamageTo(LivingEntity pTarget) {
        LivingEntity livingentity = this.getOwner();
        if (pTarget.m_6084_() && !pTarget.m_20147_() && pTarget != livingentity) {
            if (livingentity == null) {
                pTarget.m_6469_(this.m_269291_().m_269425_(), this.damage);
            } else {
                if (pTarget.m_5647_() != null ? livingentity.m_7307_((Entity)pTarget) : pTarget.m_6095_().m_20674_().equals((Object)MobCategory.MONSTER)) {
                    return;
                }
                pTarget.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)livingentity), this.damage);
            }
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_7822_(byte pId) {
        super.m_7822_(pId);
        if (pId == 4) {
            this.clientSideAttackStarted = true;
            if (!this.m_20067_()) {
                this.attackAnimationState.m_216977_(this.f_19797_);
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11865_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.2f + 0.85f, false);
            }
        }
    }

    public float getAnimationProgress(float pPartialTicks) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int i = this.lifeTicks - 2;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - pPartialTicks) / 20.0f;
    }
}

