/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.projectile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.idark.valoria.client.particle.ParticleRegistry;
import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.entity.projectile.AbstractProjectile;
import com.idark.valoria.util.Pal;
import java.util.Collection;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.client.gfx.postprocess.GlowPostProcess;
import pro.komaru.tridot.client.gfx.postprocess.GlowPostProcessInstance;
import pro.komaru.tridot.client.render.TridotRenderTypes;
import pro.komaru.tridot.util.Col;

public class AcidSpit
extends AbstractProjectile {
    public final Set<MobEffectInstance> effects = Sets.newHashSet();
    public float rotationVelocity = 0.0f;
    boolean child = false;

    public AcidSpit(EntityType<? extends AbstractProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public AcidSpit(LivingEntity pShooter, Level pLevel) {
        super((EntityType<? extends AbstractArrow>)((EntityType)EntityTypeRegistry.ACID_SPIT.get()), pLevel);
        this.m_6034_(pShooter.m_20185_(), pShooter.m_20188_() - (double)0.1f, pShooter.m_20189_());
        this.m_5602_((Entity)pShooter);
    }

    @NotNull
    public SoundEvent m_7239_() {
        return SoundEvents.f_11917_;
    }

    @NotNull
    public SoundEvent m_36784_() {
        return SoundEvents.f_11917_;
    }

    private void summonStormCrystal(ServerLevel serverLevel, Vec3 spawnPos, float angle, double speed) {
        AcidSpit shard = (AcidSpit)((EntityType)EntityTypeRegistry.ACID_SPIT.get()).m_20615_(this.m_9236_());
        if (shard != null) {
            shard.m_7678_(spawnPos.m_7096_(), spawnPos.m_7098_() + 2.0, spawnPos.m_7094_(), 0.0f, 0.0f);
            shard.m_5602_(this.m_19749_());
            shard.setChild(true);
            double vx = Math.cos(angle) * speed;
            double vz = Math.sin(angle) * speed;
            shard.m_20334_(vx, 0.4, vz);
            serverLevel.m_7967_((Entity)shard);
        }
    }

    @Override
    protected void m_6532_(HitResult pResult) {
        super.m_6532_(pResult);
        if (!this.child) {
            Level level;
            if (this.m_9236_().m_5776_()) {
                GlowPostProcess.INSTANCE.addInstance(new GlowPostProcessInstance(pResult.m_82450_().m_252839_(), new Vector3f(0.36078432f, 0.85882354f, 0.27450982f)).setIntensity(0.325f).setFadeTime(45.0f).setRadius(4.0f));
            }
            if ((level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serv = (ServerLevel)level;
                for (int i = 0; i < 6; ++i) {
                    float angle = (float)(1.0471975511965976 * (double)i);
                    this.summonStormCrystal(serv, pResult.m_82450_(), angle, 0.25);
                }
            }
        }
        this.m_146870_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticlesTrail() {
        if (this.m_6000_(this.m_20185_(), this.m_20186_(), this.m_20189_()) && !this.f_36703_) {
            ParticleBuilder.create(ParticleRegistry.ACID_SPIT).setRenderType(TridotRenderTypes.TRANSLUCENT_PARTICLE).setScaleData(GenericParticleData.create((float)(this.isChild() ? 0.15f : 0.35f)).build()).setTransparencyData(GenericParticleData.create((float)1.0f, (float)0.4f, (float)0.0f).build()).setColorData(ColorParticleData.create((Col)Pal.kiwi).build()).setGravity(0.0f).setLifetime(5).spawn(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
    }

    public void setChild(boolean child) {
        this.child = child;
    }

    public void addEffect(MobEffectInstance pEffectInstance) {
        this.effects.add(pEffectInstance);
    }

    public void setEffectsFromList(ImmutableList<MobEffectInstance> effects) {
        this.effects.addAll((Collection<MobEffectInstance>)effects);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (!this.effects.isEmpty()) {
            ListTag listtag = new ListTag();
            for (MobEffectInstance mobeffectinstance : this.effects) {
                listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
            }
            pCompound.m_128365_("CustomPotionEffects", (Tag)listtag);
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        for (MobEffectInstance mobeffectinstance : PotionUtils.m_43573_((CompoundTag)pCompound)) {
            this.addEffect(mobeffectinstance);
        }
    }

    public boolean isChild() {
        return this.child;
    }
}

