/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living.minions;

import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.particle.SmokeParticlePacket;
import com.idark.valoria.registries.entity.ai.movements.FlyingAroundMovement;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import pro.komaru.tridot.api.interfaces.Allied;

public class WickedShield
extends FlyingMob
implements TraceableEntity,
Allied {
    @javax.annotation.Nullable
    public Entity owner;
    public int limitedLifeTicks = 20;
    public FlyingAroundMovement movement = new FlyingAroundMovement((Mob)this, null);

    public WickedShield(EntityType<? extends FlyingMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_7639_() instanceof Allied && !(this.owner instanceof Player)) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12346_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12347_;
    }

    public boolean m_7307_(Entity pEntity) {
        return super.m_7307_(pEntity) || pEntity instanceof Allied;
    }

    public boolean m_6779_(LivingEntity pTarget) {
        return super.m_6779_(pTarget) && !this.m_7307_((Entity)pTarget);
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        this.movement.setupMovement();
        if ((this.owner == null || !this.owner.m_6084_() && --this.limitedLifeTicks <= 0) && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serv = (ServerLevel)level;
            this.spawnDisappearParticles(serv);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void spawnDisappearParticles(ServerLevel serverLevel) {
        double posX = this.m_20097_().m_252807_().f_82479_;
        double posY = this.m_20097_().m_7494_().m_252807_().f_82480_;
        double posZ = this.m_20097_().m_252807_().f_82481_;
        PacketHandler.sendToTracking((Level)serverLevel, this.m_20097_(), new SmokeParticlePacket(3, posX, posY - 0.5, posZ, 0.005f, 0.025f, 0.005f, 255, 255, 255));
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("LifeTicks", this.limitedLifeTicks);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("LifeTicks")) {
            this.setLimitedLife(pCompound.m_128451_("LifeTicks"));
        }
    }

    public void setLimitedLife(int pLimitedLifeTicks) {
        this.limitedLifeTicks = pLimitedLifeTicks;
    }

    public void setOwner(@javax.annotation.Nullable Entity owner) {
        this.owner = owner;
    }

    @Nullable
    public Entity m_19749_() {
        return this.owner;
    }
}

