/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living.minions;

import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.particle.SmokeParticlePacket;
import com.idark.valoria.util.Pal;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.common.registry.entity.AbstractMinionEntity;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.Tmp;

public class PixieEntity
extends AbstractMinionEntity {
    public static final int TICKS_PER_FLAP = Mth.m_14167_((float)3.9269907f);
    private static final EntityDataAccessor<Integer> DATA_ID_ATTACK_TARGET = SynchedEntityData.m_135353_(PixieEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private LivingEntity clientSideCachedAttackTarget;
    private int clientSideHealTime;

    public PixieEntity(EntityType<? extends PixieEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.f_21364_ = 1;
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_6109_()) {
            if (this.m_20069_()) {
                this.m_19920_(0.02f, pTravelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            } else if (this.m_20077_()) {
                this.m_19920_(0.02f, pTravelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                this.m_19920_(this.m_6113_(), pTravelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.91f));
            }
        }
        this.m_267651_(false);
    }

    protected float m_6431_(Pose pPose, EntityDimensions pDimensions) {
        return pDimensions.f_20378_ - 0.28125f;
    }

    public boolean m_142039_() {
        return this.f_19797_ % TICKS_PER_FLAP == 0;
    }

    public void spawnDisappearParticles(ServerLevel serverLevel) {
        double posX = this.m_20097_().m_252807_().f_82479_;
        double posY = this.m_20097_().m_7494_().m_252807_().f_82480_;
        double posZ = this.m_20097_().m_252807_().f_82481_;
        PacketHandler.sendToTracking((Level)serverLevel, this.m_20097_(), new SmokeParticlePacket(3, posX, posY - 0.5, posZ, 0.005f, 0.025f, 0.005f, 255, 255, 255));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_ATTACK_TARGET, (Object)0);
    }

    public float getHealAnimationScale(float pPartialTick) {
        return ((float)this.clientSideHealTime + pPartialTick) / (float)this.getHealDuration();
    }

    public float getClientSideHealTime() {
        return this.clientSideHealTime;
    }

    void setActiveAttackTarget(int pActiveAttackTargetId) {
        this.f_19804_.m_135381_(DATA_ID_ATTACK_TARGET, (Object)pActiveAttackTargetId);
    }

    public boolean hasActiveOwner() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_ATTACK_TARGET) != 0;
    }

    @Nullable
    public LivingEntity getActiveAttackTarget() {
        if (!this.hasActiveOwner()) {
            return null;
        }
        if (this.m_9236_().f_46443_) {
            if (this.clientSideCachedAttackTarget != null) {
                return this.clientSideCachedAttackTarget;
            }
            Entity entity = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(DATA_ID_ATTACK_TARGET)).intValue());
            if (entity instanceof LivingEntity) {
                this.clientSideCachedAttackTarget = (LivingEntity)entity;
                return this.clientSideCachedAttackTarget;
            }
            return null;
        }
        return this.m_5448_();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_() && this.m_9236_().f_46443_) {
            if (this.hasActiveOwner()) {
                LivingEntity livingentity;
                if (this.clientSideHealTime < this.getHealDuration()) {
                    ++this.clientSideHealTime;
                }
                if ((livingentity = this.getActiveAttackTarget()) != null) {
                    this.m_21563_().m_24960_((Entity)livingentity, 90.0f, 90.0f);
                    this.m_21563_().m_8128_();
                    double d5 = this.getHealAnimationScale(0.0f);
                    double d0 = livingentity.m_20185_() - this.m_20185_();
                    double d1 = livingentity.m_20227_(0.5) - this.m_20188_();
                    double d2 = livingentity.m_20189_() - this.m_20189_();
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.f_19796_.m_188500_();
                    while (d4 < d3 && Tmp.rnd.chance(0.45)) {
                        ParticleBuilder.create((RegistryObject)TridotParticles.TINY_WISP).setColorData(ColorParticleData.create((Col)Pal.nature, (Col)Pal.oceanic).build()).setScaleData(GenericParticleData.create((float)0.1f).build()).spawn(this.m_9236_(), this.m_20185_() + d0 * (d4 += 1.8 - d5 + this.f_19796_.m_188500_() * (1.7 - d5)), this.m_20188_() + d1 * d4, this.m_20189_() + d2 * d4);
                    }
                }
            }
            if (this.hasActiveOwner()) {
                this.m_146922_(this.f_20885_);
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        super.m_7350_(pKey);
        if (DATA_ID_ATTACK_TARGET.equals(pKey)) {
            this.clientSideHealTime = 0;
            this.clientSideCachedAttackTarget = null;
        }
    }

    public void spawnParticlesTrail() {
        if (Tmp.rnd.chance(0.15f)) {
            Vec3 vector3d = this.m_20184_();
            double a3 = vector3d.f_82479_;
            double a4 = vector3d.f_82480_;
            double a0 = vector3d.f_82481_;
            int a = 0;
            while ((float)a < 0.05f) {
                ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.WISP).setColorData(ColorParticleData.create((Col)Pal.nature, (Col)Pal.oceanic).build()).randomVelocity((double)0.15f)).setScaleData(GenericParticleData.create((float)0.1f).build()).spawn(this.m_9236_(), this.m_20185_() + a3 * (double)a / 4.0, this.m_20186_() + a4 * (double)a / 4.0, this.m_20189_() + a0 * (double)a / 4.0);
                ++a;
            }
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new HealOwnerGoal());
        this.f_21345_.m_25352_(0, (Goal)new RandomMoveGoal());
        this.f_21345_.m_25352_(0, (Goal)new FollowOwnerGoal(1.0, 16.0f, 6.0f));
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_215671_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_215672_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_215675_;
    }

    public float m_213856_() {
        return 1.0f;
    }

    protected PathNavigation m_6037_(Level pLevel) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, pLevel);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(false);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    public boolean m_6147_() {
        return false;
    }

    public double m_6049_() {
        return 0.4;
    }

    public int getHealDuration() {
        return 80;
    }

    class HealOwnerGoal
    extends Goal {
        private int healTime;

        HealOwnerGoal() {
        }

        public boolean m_8036_() {
            return PixieEntity.this.m_269323_() != null && PixieEntity.this.m_269323_().m_6084_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && PixieEntity.this.m_269323_() != null && PixieEntity.this.m_20280_((Entity)PixieEntity.this.m_269323_()) > 9.0 && PixieEntity.this.m_269323_().m_21223_() < PixieEntity.this.m_269323_().m_21233_();
        }

        public void m_8056_() {
            this.healTime = -10;
            PixieEntity.this.m_21573_().m_26573_();
            LivingEntity livingentity = PixieEntity.this.m_269323_();
            if (livingentity != null) {
                PixieEntity.this.m_21563_().m_24960_((Entity)livingentity, 90.0f, 90.0f);
            }
            PixieEntity.this.f_19812_ = true;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8041_() {
            PixieEntity.this.setActiveAttackTarget(0);
        }

        public void m_8037_() {
            LivingEntity livingentity = PixieEntity.this.m_269323_();
            if (livingentity != null) {
                PixieEntity.this.m_21573_().m_26573_();
                PixieEntity.this.m_21563_().m_24960_((Entity)livingentity, 90.0f, 90.0f);
                if (PixieEntity.this.m_142582_((Entity)livingentity)) {
                    ++this.healTime;
                    if (this.healTime == 0) {
                        PixieEntity.this.setActiveAttackTarget(livingentity.m_19879_());
                    } else if (this.healTime >= PixieEntity.this.getHealDuration() && this.healTime % 20 == 0) {
                        float f = 1.0f;
                        if (PixieEntity.this.m_9236_().m_46791_() == Difficulty.HARD) {
                            f += 5.0f;
                        }
                        livingentity.m_5634_(f);
                    }
                    super.m_8037_();
                }
            }
        }
    }

    class RandomMoveGoal
    extends Goal {
        public RandomMoveGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return PixieEntity.this.m_5448_() == null && !PixieEntity.this.m_21566_().m_24995_() && PixieEntity.this.f_19796_.m_188503_(RandomMoveGoal.m_186073_((int)7)) == 0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            BlockPos blockpos = PixieEntity.this.getBoundOrigin();
            if (blockpos == null) {
                blockpos = PixieEntity.this.m_20183_();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(PixieEntity.this.f_19796_.m_188503_(15) - 7, PixieEntity.this.f_19796_.m_188503_(7) - 5, PixieEntity.this.f_19796_.m_188503_(15) - 7);
                if (!PixieEntity.this.m_9236_().m_46859_(blockpos1)) continue;
                PixieEntity.this.f_21342_.m_6849_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 0.25);
                break;
            }
        }
    }

    class FollowOwnerGoal
    extends Goal {
        private LivingEntity owner;
        private final double speedModifier;
        private final PathNavigation navigation;
        private int timeToRecalcPath;
        private final float stopDistance;
        private final float startDistance;
        private float oldWaterCost;

        public FollowOwnerGoal(double pSpeedModifier, float pStartDistance, float pStopDistance) {
            this.speedModifier = pSpeedModifier;
            this.navigation = PixieEntity.this.m_21573_();
            this.startDistance = pStartDistance;
            this.stopDistance = pStopDistance;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = PixieEntity.this.m_269323_();
            if (livingentity == null) {
                return false;
            }
            if (livingentity.m_5833_()) {
                return false;
            }
            if (this.unableToMove()) {
                return false;
            }
            if (PixieEntity.this.m_20280_((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
                return false;
            }
            this.owner = livingentity;
            return true;
        }

        public boolean m_8045_() {
            if (this.navigation.m_26571_()) {
                return false;
            }
            if (this.unableToMove()) {
                return false;
            }
            return !(PixieEntity.this.m_20280_((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
        }

        private boolean unableToMove() {
            return PixieEntity.this.m_20159_() || PixieEntity.this.m_21523_();
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = PixieEntity.this.m_21439_(BlockPathTypes.WATER);
            PixieEntity.this.m_21441_(BlockPathTypes.WATER, 0.0f);
        }

        public void m_8041_() {
            this.owner = null;
            this.navigation.m_26573_();
            PixieEntity.this.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
        }

        public void m_8037_() {
            PixieEntity.this.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)PixieEntity.this.m_8132_());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(10);
                this.navigation.m_5624_((Entity)this.owner, this.speedModifier);
            }
        }
    }
}

