/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living.minions;

import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.particle.SmokeParticlePacket;
import com.idark.valoria.registries.BlockRegistry;
import com.idark.valoria.registries.entity.projectile.LaserEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import pro.komaru.tridot.common.registry.entity.AbstractMinionEntity;
import pro.komaru.tridot.common.registry.entity.goal.CopyOwnerTargetGoal;
import pro.komaru.tridot.common.registry.entity.goal.FollowOwnerGoal;

public class FleshSentinel
extends AbstractMinionEntity {
    public static final int TICKS_PER_FLAP = Mth.m_14167_((float)3.9269907f);
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(FleshSentinel.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public boolean cystSpawned;

    public FleshSentinel(EntityType<? extends FleshSentinel> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new UndeadMoveControl(this);
        this.f_21364_ = 3;
    }

    protected float m_6431_(Pose pPose, EntityDimensions pDimensions) {
        return pDimensions.f_20378_ - 0.28125f;
    }

    public void spawnDisappearParticles(ServerLevel serverLevel) {
        double posX = this.m_20097_().m_252807_().f_82479_;
        double posY = this.m_20097_().m_7494_().m_252807_().f_82480_;
        double posZ = this.m_20097_().m_252807_().f_82481_;
        PacketHandler.sendToTracking((Level)serverLevel, this.m_20097_(), new SmokeParticlePacket(3, posX, posY - 0.5, posZ, 0.005f, 0.025f, 0.005f, 255, 255, 255));
    }

    public boolean m_142039_() {
        return this.f_19797_ % TICKS_PER_FLAP == 0;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(0, (Goal)new FollowOwnerGoal((Mob)this, 1.0, 24.0f, 8.0f, true));
        this.f_21346_.m_25352_(0, (Goal)new CopyOwnerTargetGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(0, (Goal)new FleshSentinelOrbitAndShootGoal(8.0, 0.5));
        this.f_21345_.m_25352_(0, (Goal)new FleshSentinelRandomMoveGoal());
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12526_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12527_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12529_;
    }

    public float m_213856_() {
        return 1.0f;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.cystSpawned && this.getBoundOrigin() != null && this.m_9236_().m_8055_(this.getBoundOrigin()).m_60713_((Block)BlockRegistry.fleshCyst.get()) && !this.hasLimitedLife) {
            this.setLimitedLife(1750);
        }
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    protected PathNavigation m_6037_(Level pLevel) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, pLevel);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_6109_()) {
            if (this.m_20069_()) {
                this.m_19920_(0.02f, pTravelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            } else if (this.m_20077_()) {
                this.m_19920_(0.02f, pTravelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                BlockPos ground = this.m_20099_();
                float f = 0.91f;
                if (this.m_20096_()) {
                    f = this.m_9236_().m_8055_(ground).getFriction((LevelReader)this.m_9236_(), ground, (Entity)this) * 0.91f;
                }
                float f1 = 0.16277137f / (f * f * f);
                f = 0.91f;
                if (this.m_20096_()) {
                    f = this.m_9236_().m_8055_(ground).getFriction((LevelReader)this.m_9236_(), ground, (Entity)this) * 0.91f;
                }
                this.m_19920_(this.m_20096_() ? 0.1f * f1 : 0.02f, pTravelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)f));
            }
        }
        this.m_267651_(false);
    }

    public boolean m_6147_() {
        return false;
    }

    public double m_6049_() {
        return 0.4;
    }

    class UndeadMoveControl
    extends MoveControl {
        public UndeadMoveControl(FleshSentinel pFleshSentinel) {
            super((Mob)pFleshSentinel);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vec3 = new Vec3(this.f_24975_ - FleshSentinel.this.m_20185_(), this.f_24976_ - FleshSentinel.this.m_20186_(), this.f_24977_ - FleshSentinel.this.m_20189_());
                double d0 = vec3.m_82553_();
                if (d0 < FleshSentinel.this.m_20191_().m_82309_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    FleshSentinel.this.m_20256_(FleshSentinel.this.m_20184_().m_82490_(0.5));
                } else {
                    FleshSentinel.this.m_20256_(FleshSentinel.this.m_20184_().m_82549_(vec3.m_82490_(this.f_24978_ * 0.05 / d0)));
                    if (FleshSentinel.this.m_5448_() == null) {
                        Vec3 vec31 = FleshSentinel.this.m_20184_();
                        FleshSentinel.this.m_146922_(-((float)Mth.m_14136_((double)vec31.f_82479_, (double)vec31.f_82481_)) * 57.295776f);
                    } else {
                        double d2 = FleshSentinel.this.m_5448_().m_20185_() - FleshSentinel.this.m_20185_();
                        double d1 = FleshSentinel.this.m_5448_().m_20189_() - FleshSentinel.this.m_20189_();
                        FleshSentinel.this.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f);
                    }
                    FleshSentinel.this.f_20883_ = FleshSentinel.this.m_146908_();
                }
            }
        }
    }

    class FleshSentinelOrbitAndShootGoal
    extends Goal {
        private final double orbitRadius;
        private final double speed;
        private int attackCooldown;

        public FleshSentinelOrbitAndShootGoal(double orbitRadius, double speed) {
            this.orbitRadius = orbitRadius;
            this.speed = speed;
            this.attackCooldown = 0;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return FleshSentinel.this.m_5448_() != null;
        }

        public boolean m_8045_() {
            return FleshSentinel.this.m_5448_() != null && FleshSentinel.this.m_5448_().m_6084_();
        }

        public void m_8037_() {
            double dz;
            LivingEntity target = FleshSentinel.this.m_5448_();
            if (target == null) {
                return;
            }
            double dx = target.m_20185_() - FleshSentinel.this.m_20185_();
            double distance = Math.sqrt(dx * dx + (dz = target.m_20189_() - FleshSentinel.this.m_20189_()) * dz);
            if (distance < this.orbitRadius * 0.8) {
                FleshSentinel.this.m_21566_().m_6849_(FleshSentinel.this.m_20185_() - dx / distance * this.orbitRadius, FleshSentinel.this.m_20186_(), FleshSentinel.this.m_20189_() - dz / distance * this.orbitRadius, this.speed);
            } else if (distance > this.orbitRadius * 1.2) {
                FleshSentinel.this.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), this.speed);
            } else {
                double angle = Math.toRadians(FleshSentinel.this.f_19797_ % 360 * 4);
                double offsetX = Math.cos(angle) * this.orbitRadius;
                double offsetZ = Math.sin(angle) * this.orbitRadius;
                FleshSentinel.this.m_21566_().m_6849_(target.m_20185_() + offsetX, target.m_20186_(), target.m_20189_() + offsetZ, this.speed);
            }
            FleshSentinel.this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            if (this.attackCooldown > 0) {
                --this.attackCooldown;
            } else {
                this.shootAtTarget(target);
                this.attackCooldown = 40;
            }
        }

        private void shootAtTarget(LivingEntity target) {
            Vec3 direction = new Vec3(target.m_20185_() - FleshSentinel.this.m_20185_(), target.m_20188_() - FleshSentinel.this.m_20188_(), target.m_20189_() - FleshSentinel.this.m_20189_()).m_82541_();
            LaserEntity projectile = new LaserEntity(FleshSentinel.this.m_9236_(), (LivingEntity)FleshSentinel.this);
            projectile.m_6034_(FleshSentinel.this.m_20185_(), FleshSentinel.this.m_20188_(), FleshSentinel.this.m_20189_());
            projectile.setDamage(4.0f);
            projectile.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 1.5f, 1.0f);
            FleshSentinel.this.m_9236_().m_7967_((Entity)projectile);
        }
    }

    class FleshSentinelRandomMoveGoal
    extends Goal {
        public FleshSentinelRandomMoveGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return FleshSentinel.this.m_5448_() == null && !FleshSentinel.this.m_21566_().m_24995_() && FleshSentinel.this.f_19796_.m_188503_(FleshSentinelRandomMoveGoal.m_186073_((int)7)) == 0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            BlockPos blockpos = FleshSentinel.this.getBoundOrigin();
            if (blockpos == null) {
                blockpos = FleshSentinel.this.m_20183_();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(FleshSentinel.this.f_19796_.m_188503_(15) - 7, FleshSentinel.this.f_19796_.m_188503_(11) - 5, FleshSentinel.this.f_19796_.m_188503_(15) - 7);
                if (!FleshSentinel.this.m_9236_().m_46859_(blockpos1)) continue;
                FleshSentinel.this.f_21342_.m_6849_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 0.25);
                break;
            }
        }
    }
}

