/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living.elemental;

import com.idark.valoria.registries.EntityStatsRegistry;
import com.idark.valoria.registries.ItemsRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.entity.ai.goals.ReasonableAvoidEntityGoal;
import com.idark.valoria.registries.entity.ai.movements.SkeletonMovement;
import com.idark.valoria.registries.entity.living.elemental.AbstractDevil;
import com.idark.valoria.registries.entity.projectile.ThrownSpearEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.api.entity.AttackRegistry;
import pro.komaru.tridot.common.registry.entity.MultiAttackMob;
import pro.komaru.tridot.util.Tmp;

public class Devil
extends AbstractDevil
implements RangedAttackMob {
    public final AnimationState idleAnimationState = new AnimationState();
    public AnimationState throwAnimationState = new AnimationState();
    public AnimationState magicAnimationState = new AnimationState();
    public int idleAnimationTimeout = 0;
    public int throwAnimationTimeout = 0;
    public int magicAnimationTimeout = 0;
    public int hits = 0;
    public boolean ranged;
    public SkeletonMovement movement = new SkeletonMovement((Mob)this, 64.0);
    private int attackAnimationTick;

    public Devil(EntityType<? extends Devil> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void m_7822_(byte pId) {
        if (pId == 62 && this.throwAnimationTimeout <= 0) {
            this.throwAnimationTimeout = 40;
            this.idleAnimationState.m_216973_();
            this.throwAnimationState.m_216977_(this.f_19797_);
        }
        if (pId == 61 && this.magicAnimationTimeout <= 0) {
            this.magicAnimationTimeout = 80;
            this.idleAnimationState.m_216973_();
            this.magicAnimationState.m_216977_(this.f_19797_);
        }
        super.m_7822_(pId);
    }

    @Nullable
    public SoundEvent m_7515_() {
        return this.hasTarget() ? (SoundEvent)SoundsRegistry.DEVIL_IDLE.get() : SoundEvents.f_271165_;
    }

    @Override
    public SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)SoundsRegistry.DEVIL_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundsRegistry.DEVIL_DEATH.get();
    }

    public boolean m_7327_(Entity pEntity) {
        this.m_5496_((SoundEvent)SoundsRegistry.DEVIL_ATTACK.get(), 1.0f, 1.0f);
        return super.m_7327_(pEntity);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.ranged) {
            this.movement.setupMovement();
        }
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
            if (this.attackAnimationTick == this.attackDelay() && this.m_5448_() != null && this.m_5448_().m_6084_()) {
                double d0 = this.m_20275_(this.m_5448_().m_20185_(), this.m_5448_().m_20186_(), this.m_5448_().m_20189_());
                float f = (float)Math.sqrt(d0) / 16.0f;
                float f1 = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
                this.m_6504_(this.m_5448_(), f1);
            }
        }
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 60;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.throwAnimationTimeout;
            --this.idleAnimationTimeout;
        }
    }

    public final boolean isLowHP() {
        return this.m_21223_() < 10.0f;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (!this.m_9236_().m_5776_() && this.hits < 4) {
            ++this.hits;
            this.amplifyStats();
        }
        return super.m_6469_(pSource, pAmount);
    }

    private void amplifyStats() {
        this.m_21051_(Attributes.f_22281_).m_22118_(new AttributeModifier("modifier", (double)((float)this.m_9236_().m_46791_().m_19028_() * 0.5f), AttributeModifier.Operation.ADDITION));
        this.m_21051_(Attributes.f_22279_).m_22118_(new AttributeModifier("modifier", (double)0.025f, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    public boolean m_21526_() {
        return false;
    }

    protected void m_213945_(RandomSource pRandom, DifficultyInstance pDifficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, ((Item)ItemsRegistry.infernalSpear.get()).m_7968_());
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        RandomSource randomsource = pLevel.m_213780_();
        this.m_213945_(randomsource, pDifficulty);
        this.ranged = Tmp.rnd.chance(0.25f);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(0, (Goal)new ThrowSpearGoal(this, 1.0, 12.0f));
        this.f_21345_.m_25352_(0, new ReasonableAvoidEntityGoal<Player>((PathfinderMob)this, Player.class, 16.0f, 1.25, 2.0, this.isLowHP()));
        if (!this.ranged) {
            this.f_21345_.m_25352_(1, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 12.0f));
        }
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{Devil.class}));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void m_6504_(LivingEntity pTarget, float pVelocity) {
        ThrownSpearEntity spear = new ThrownSpearEntity(this.m_9236_(), (LivingEntity)this, new ItemStack((ItemLike)ItemsRegistry.infernalSpear.get()));
        double d0 = pTarget.m_20185_() - this.m_20185_();
        double d1 = pTarget.m_20227_(0.3333333333333333) - spear.m_20186_();
        double d2 = pTarget.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        spear.m_36781_(6.0);
        spear.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.m_9236_().m_46791_().m_19028_() * 4);
        this.m_5496_(SoundEvents.f_11821_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)spear);
    }

    public class ThrowSpearGoal
    extends MultiAttackMob.AttackGoal {
        private final Mob mob;
        private LivingEntity target;
        private final double speedModifier;
        private final float attackRadiusSqr;

        public ThrowSpearGoal(RangedAttackMob pRangedAttackMob, double pSpeedModifier, float pAttackRadius) {
            super((MultiAttackMob)Devil.this);
            this.mob = (Mob)pRangedAttackMob;
            this.speedModifier = pSpeedModifier;
            this.attackRadiusSqr = pAttackRadius * pAttackRadius;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (livingentity.m_6084_() && super.m_8036_()) {
                this.target = livingentity;
                return Devil.this.cantReachTarget(this.target) || Devil.this.isFleeing(this.mob, 5.0f) || Devil.this.ranged;
            }
            return false;
        }

        protected void performAttack() {
        }

        public boolean raytrace(Mob mob, Vec3 EndPos) {
            HitResult hitresult;
            Vec3 pos = new Vec3(mob.m_20185_(), mob.m_20186_() + (double)mob.m_20192_(), mob.m_20189_());
            double pitch = (double)(mob.m_20155_().f_82470_ + 90.0f) * Math.PI / 180.0;
            double yaw = (double)(mob.m_20155_().f_82471_ + 90.0f) * Math.PI / 180.0;
            double X = Math.sin(pitch) * Math.cos(yaw) * 15.0;
            double Y = Math.cos(pitch) * 15.0;
            double Z = Math.sin(pitch) * Math.sin(yaw) * 15.0;
            Vec3 playerPos = mob.m_146892_();
            if (ProjectileUtil.m_37287_((Entity)mob, (Vec3)playerPos, (Vec3)EndPos, (AABB)new AABB(pos.f_82479_ + X - 3.0, pos.f_82480_ + Y - 3.0, pos.f_82481_ + Z - 3.0, pos.f_82479_ + X + 3.0, pos.f_82480_ + Y + 3.0, pos.f_82481_ + Z + 3.0), e -> true, (double)15.0) == null && (hitresult = Utils.Hit.hitResult((Vec3)playerPos, (Entity)mob, e -> true, (Vec3)EndPos, (Level)mob.m_9236_())) != null) {
                return switch (hitresult.m_6662_()) {
                    default -> throw new IncompatibleClassChangeError();
                    case HitResult.Type.BLOCK, HitResult.Type.MISS -> false;
                    case HitResult.Type.ENTITY -> true;
                };
            }
            return false;
        }

        private Vec3 getRandomPositionWithLineOfSight(Mob mob, LivingEntity target, int radius, int attempts) {
            RandomSource random = mob.m_217043_();
            for (int i = 0; i < attempts; ++i) {
                double randomZ;
                double randomY;
                double randomX = target.m_20185_() + (random.m_188500_() - 0.5) * (double)radius * 2.0;
                Vec3 randomPos = new Vec3(randomX, randomY = target.m_20186_(), randomZ = target.m_20189_() + (random.m_188500_() - 0.5) * (double)radius * 2.0);
                if (!this.raytrace(mob, randomPos)) continue;
                return randomPos;
            }
            return null;
        }

        public void m_8037_() {
            Vec3 randomPos;
            super.m_8037_();
            this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            if (!this.m_8036_()) {
                return;
            }
            if (Devil.this.cantReachTarget(this.target)) {
                this.mob.m_21566_().m_24988_(-0.5f, Tmp.rnd.nextBoolean() ? 0.5f : -0.5f);
                return;
            }
            double d0 = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
            if (!(d0 > (double)this.attackRadiusSqr) && this.mob.m_21574_().m_148306_((Entity)this.target)) {
                this.mob.m_21573_().m_26573_();
                return;
            }
            if (!this.mob.m_21574_().m_148306_((Entity)this.target) && (randomPos = this.getRandomPositionWithLineOfSight(this.mob, this.target, 12, 8)) != null) {
                this.mob.m_21573_().m_26519_(randomPos.f_82479_, randomPos.f_82480_, randomPos.f_82481_, this.speedModifier);
                return;
            }
            this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
        }

        public void onPrepare() {
            Devil.this.attackAnimationTick = 25;
            Devil.this.m_9236_().m_7605_((Entity)Devil.this, (byte)62);
        }

        public int getPreparingTime() {
            return 25;
        }

        public int getAttackInterval() {
            return 50;
        }

        public SoundEvent getPrepareSound() {
            return null;
        }

        public AttackRegistry getAttack() {
            return EntityStatsRegistry.THROW;
        }
    }
}

