/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living.boss;

import com.google.common.collect.ImmutableList;
import com.idark.valoria.Valoria;
import com.idark.valoria.core.config.CommonConfig;
import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.MusicToastPacket;
import com.idark.valoria.core.network.packets.particle.CircleShapedParticlePacket;
import com.idark.valoria.core.network.packets.particle.SmokeParticlePacket;
import com.idark.valoria.registries.EffectsRegistry;
import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.entity.ai.movements.SkeletonMovement;
import com.idark.valoria.registries.entity.living.DraugrEntity;
import com.idark.valoria.registries.entity.living.SorcererEntity;
import com.idark.valoria.registries.entity.living.boss.AbstractNecromancer;
import com.idark.valoria.registries.entity.living.minions.UndeadEntity;
import com.idark.valoria.registries.entity.projectile.Devourer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.api.interfaces.BossEntity;
import pro.komaru.tridot.api.render.bossbars.ServerBossBar;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;

public class NecromancerEntity
extends AbstractNecromancer
implements BossEntity {
    public final List<UUID> nearbyPlayers = new ArrayList<UUID>();
    public final Map<UUID, Float> damageMap = new HashMap<UUID, Float>();
    public ArcRandom arcRandom = Tmp.rnd;
    public SkeletonMovement movement = new SkeletonMovement((Mob)this);
    public final ServerBossBar bossEvent = new ServerBossBar(this.m_5446_(), Valoria.loc("basic")).setTexture(Valoria.loc("textures/gui/bossbars/necromancer.png")).setBossMusic((SoundEvent)SoundsRegistry.MUSIC_NECROMANCER.get()).setDarkenScreen(true);
    private int spawnTime = 0;
    @Nullable
    private Skeleton wololoTarget;

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.movement.setupMovement();
        if (this.spawnTime < 10) {
            ++this.spawnTime;
        }
    }

    public void m_6667_(DamageSource pDamageSource) {
        this.bossEvent.setAboutToDie(true);
        super.m_6667_(pDamageSource);
    }

    public float getSpawnProgress(float partialTicks) {
        return Math.min(1.0f, ((float)this.spawnTime + partialTicks) / 10.0f);
    }

    public NecromancerEntity(EntityType<? extends NecromancerEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 100;
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.readBossData(pCompound);
        if (this.m_8077_()) {
            this.bossEvent.setName(this.m_5446_());
        }
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.saveBossData(pCompound);
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.bossEvent.setName(this.m_5446_());
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossEvent.addPlayer(pPlayer);
        PacketHandler.sendTo(pPlayer, (Object)new MusicToastPacket((Player)pPlayer, (SoundEvent)SoundsRegistry.MUSIC_NECROMANCER.get()));
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossEvent.removePlayer(pPlayer);
    }

    public float m_5610_(BlockPos pPos, LevelReader pLevel) {
        return 0.0f;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        CompoundTag data = this.getPersistentData();
        if (!data.m_128471_("NearbyPlayerHealthBonus")) {
            this.initializeNearbyPlayers(this.m_9236_(), (Entity)this);
            this.applyBonusHealth((Mob)this);
        }
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        this.bossEvent.setHealth(this.m_21223_(), this.m_21233_());
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity = source.m_7640_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            UUID playerUUID = player.m_20148_();
            this.getDamageMap().put(playerUUID, Float.valueOf(this.getDamageMap().getOrDefault(playerUUID, Float.valueOf(0.0f)).floatValue() + amount));
        }
        return super.m_6469_(source, amount);
    }

    @Nullable
    public ItemEntity m_5552_(ItemStack stack, float offsetY) {
        if (stack.m_41619_() || this.m_9236_().f_46443_) {
            return null;
        }
        this.initializeLoot(this.m_9236_(), stack, this.m_20097_().m_7494_(), offsetY);
        return null;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new AttackSpellGoal());
        this.f_21345_.m_25352_(1, (Goal)new SummonMobsSpellGoal());
        this.f_21345_.m_25352_(1, (Goal)new KnockbackEntitiesGoal(true, new MobEffectInstance(MobEffects.f_19613_, 120, 0), new MobEffectInstance(MobEffects.f_19610_, 45, 0)));
        this.f_21345_.m_25352_(1, (Goal)new KnockbackEntitiesGoal(false, new MobEffectInstance(MobEffects.f_19613_, 120, 0), new MobEffectInstance(MobEffects.f_19610_, 45, 0)));
        this.f_21345_.m_25352_(2, (Goal)new KnockbackEntitiesGoal(false, new MobEffectInstance[0]));
        this.f_21345_.m_25352_(1, (Goal)new HealSelfSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new HealTargetSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new ApplyEffectSpellGoal(new MobEffectInstance((MobEffect)EffectsRegistry.STUN.get(), 60, 0)));
        this.f_21345_.m_25352_(2, (Goal)new ApplyEffectSpellGoal(new MobEffectInstance(MobEffects.f_19613_, 145, 0)));
        this.f_21345_.m_25352_(2, (Goal)new ApplyEffectSpellGoal(new MobEffectInstance(MobEffects.f_19613_, 165, 1)));
        this.f_21345_.m_25352_(3, (Goal)new WololoSpellGoal());
        this.f_21345_.m_25352_(0, (Goal)new CastingSpellGoal());
        this.f_21345_.m_25352_(1, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Wolf.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_7307_(Entity pEntity) {
        if (super.m_7307_(pEntity)) {
            return true;
        }
        if (pEntity instanceof LivingEntity && ((LivingEntity)pEntity).m_6336_() == MobType.f_21641_) {
            return this.m_5647_() == null && pEntity.m_5647_() == null;
        }
        return false;
    }

    public void m_6083_() {
        super.m_6083_();
        Entity entity = this.m_275832_();
        if (entity instanceof PathfinderMob) {
            PathfinderMob pathfindermob = (PathfinderMob)entity;
            this.f_20883_ = pathfindermob.f_20883_;
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        RandomSource randomsource = pLevel.m_213780_();
        this.m_213945_(randomsource, pDifficulty);
        this.m_213946_(randomsource, pDifficulty);
        this.m_21553_(randomsource.m_188501_() < 0.55f * pDifficulty.m_19057_());
        return pSpawnData;
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
        super.m_8061_(pSlot, pStack);
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12383_;
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return 1.74f;
    }

    public double m_6049_() {
        return -0.6;
    }

    void setWololoTarget(@Nullable Skeleton pWololoTarget) {
        this.wololoTarget = pWololoTarget;
    }

    @Nullable
    Skeleton getWololoTarget() {
        return this.wololoTarget;
    }

    public List<UUID> getNearbyPlayers() {
        return this.nearbyPlayers;
    }

    public Map<UUID, Float> getDamageMap() {
        return this.damageMap;
    }

    class AttackSpellGoal
    extends AbstractNecromancer.SpellcasterUseSpellGoal {
        AttackSpellGoal() {
        }

        @Override
        public int getCastingTime() {
            return (Integer)CommonConfig.ATTACK_NECROMANCER_CASTING_TIME.get();
        }

        @Override
        public int getCastingInterval() {
            return (Integer)CommonConfig.ATTACK_NECROMANCER_CASTING_INTERVAL.get();
        }

        @Override
        protected void performSpellCasting() {
            block5: {
                LivingEntity livingentity = NecromancerEntity.this.m_5448_();
                if (livingentity == null) break block5;
                double d0 = Math.min(livingentity.m_20186_(), NecromancerEntity.this.m_20186_());
                double d1 = Math.max(livingentity.m_20186_(), NecromancerEntity.this.m_20186_()) + 1.0;
                float f = (float)Mth.m_14136_((double)(livingentity.m_20189_() - NecromancerEntity.this.m_20189_()), (double)(livingentity.m_20185_() - NecromancerEntity.this.m_20185_()));
                if (NecromancerEntity.this.m_20280_((Entity)livingentity) < 9.0) {
                    for (int i = 0; i < 5; ++i) {
                        float f1 = f + (float)i * (float)Math.PI * 0.4f;
                        this.createSpellEntity(NecromancerEntity.this.m_20185_() + (double)Mth.m_14089_((float)f1) * 1.5, NecromancerEntity.this.m_20189_() + (double)Mth.m_14031_((float)f1) * 1.5, d0, d1, f1, 0);
                    }
                    for (int k = 0; k < 8; ++k) {
                        float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                        this.createSpellEntity(NecromancerEntity.this.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.5, NecromancerEntity.this.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.5, d0, d1, f2, 3);
                    }
                } else {
                    for (int l = 0; l < 16; ++l) {
                        double d2 = 1.25 * (double)(l + 1);
                        this.createSpellEntity(NecromancerEntity.this.m_20185_() + (double)Mth.m_14089_((float)f) * d2, NecromancerEntity.this.m_20189_() + (double)Mth.m_14031_((float)f) * d2, d0, d1, f, l);
                    }
                }
            }
        }

        private void createSpellEntity(double pX, double pZ, double pMinY, double pMaxY, float pYRot, int pWarmupDelay) {
            BlockPos blockpos = BlockPos.m_274561_((double)pX, (double)pMaxY, (double)pZ);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1 = blockpos.m_7495_();
                BlockState blockstate = NecromancerEntity.this.m_9236_().m_8055_(blockpos1);
                if (!blockstate.m_60783_((BlockGetter)NecromancerEntity.this.m_9236_(), blockpos1, Direction.UP)) continue;
                if (!NecromancerEntity.this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = NecromancerEntity.this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)NecromancerEntity.this.m_9236_(), blockpos)).m_83281_()) {
                    d0 = voxelshape.m_83297_(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)pMinY) - 1);
            if (flag) {
                NecromancerEntity.this.m_9236_().m_7967_((Entity)new Devourer(NecromancerEntity.this.m_9236_(), pX, (double)blockpos.m_123342_() + d0, pZ, pYRot, pWarmupDelay, ((Integer)CommonConfig.ATTACK_NECROMANCER_DAMAGE.get()).intValue(), (LivingEntity)NecromancerEntity.this));
            }
        }

        @Override
        public SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11867_;
        }

        @Override
        public AbstractNecromancer.NecromancerSpells getSpell() {
            return AbstractNecromancer.NecromancerSpells.FANGS;
        }
    }

    class SummonMobsSpellGoal
    extends AbstractNecromancer.SpellcasterUseSpellGoal {
        private final TargetingConditions vexCountTargeting = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_().m_26893_();

        SummonMobsSpellGoal() {
        }

        @Override
        public void m_8056_() {
            NecromancerEntity.this.setIsCastingSpell(this.getSpell());
            this.attackWarmupDelay = this.m_183277_(this.getCastingTime());
            NecromancerEntity.this.spellCastingTickCount = this.getCastingTime();
            this.nextAttackTickCount = NecromancerEntity.this.f_19797_ + this.getCastingInterval();
        }

        @Override
        public boolean m_8036_() {
            int i = NecromancerEntity.this.m_9236_().m_45971_(Zombie.class, this.vexCountTargeting, (LivingEntity)NecromancerEntity.this, NecromancerEntity.this.m_20191_().m_82400_(16.0)).size();
            return super.m_8036_() && NecromancerEntity.this.f_19796_.m_188503_(8) + 1 > i;
        }

        @Override
        public int getCastingTime() {
            return (Integer)CommonConfig.SUMMON_NECROMANCER_CASTING_TIME.get();
        }

        @Override
        public int getCastingInterval() {
            return (Integer)CommonConfig.SUMMON_NECROMANCER_CASTING_INTERVAL.get();
        }

        @Override
        @Nullable
        public SoundEvent getSpellPrepareSound() {
            return null;
        }

        private void spawnZombie(ServerLevel serverLevel, BlockPos blockpos) {
            Zombie zombie = (Zombie)EntityType.f_20501_.m_20615_(NecromancerEntity.this.m_9236_());
            if (zombie != null && serverLevel.m_46859_(blockpos) && serverLevel.m_46859_(blockpos.m_7494_())) {
                zombie.m_20035_(blockpos, 0.0f, 0.0f);
                zombie.m_6518_((ServerLevelAccessor)serverLevel, NecromancerEntity.this.m_9236_().m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, null, null);
                zombie.m_21153_(zombie.m_21233_() / 2.0f);
                zombie.m_6710_(NecromancerEntity.this.m_5448_());
                serverLevel.m_47205_((Entity)zombie);
            } else {
                this.spawnUndead(serverLevel, blockpos.m_7494_());
            }
        }

        private void spawnSkeletons(ServerLevel serverLevel, BlockPos blockpos) {
            Skeleton skeleton = (Skeleton)EntityType.f_20524_.m_20615_(NecromancerEntity.this.m_9236_());
            if (skeleton != null && serverLevel.m_46859_(blockpos) && serverLevel.m_46859_(blockpos.m_7494_())) {
                skeleton.m_20035_(blockpos, 0.0f, 0.0f);
                skeleton.m_6518_((ServerLevelAccessor)serverLevel, NecromancerEntity.this.m_9236_().m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, null, null);
                skeleton.m_21153_(skeleton.m_21233_() / 2.0f);
                skeleton.m_6710_(NecromancerEntity.this.m_5448_());
                serverLevel.m_47205_((Entity)skeleton);
            } else {
                this.spawnUndead(serverLevel, blockpos.m_7494_());
            }
        }

        private void spawnSorcerers(ServerLevel serverLevel, BlockPos blockpos) {
            SorcererEntity sorcerer = (SorcererEntity)((EntityType)EntityTypeRegistry.SORCERER.get()).m_20615_(NecromancerEntity.this.m_9236_());
            if (sorcerer != null && serverLevel.m_46859_(blockpos) && serverLevel.m_46859_(blockpos.m_7494_())) {
                sorcerer.m_20035_(blockpos, 0.0f, 0.0f);
                sorcerer.m_6518_((ServerLevelAccessor)serverLevel, NecromancerEntity.this.m_9236_().m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, null, null);
                serverLevel.m_47205_((Entity)sorcerer);
            } else {
                this.spawnUndead(serverLevel, blockpos.m_7494_());
            }
        }

        private void spawnUndead(ServerLevel serverLevel, BlockPos blockpos) {
            UndeadEntity undead = (UndeadEntity)((EntityType)EntityTypeRegistry.UNDEAD.get()).m_20615_(NecromancerEntity.this.m_9236_());
            if (undead != null && serverLevel.m_46859_(blockpos)) {
                undead.m_20035_(blockpos, 0.0f, 0.0f);
                undead.m_6518_((ServerLevelAccessor)serverLevel, NecromancerEntity.this.m_9236_().m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, null, null);
                undead.setOwner((LivingEntity)NecromancerEntity.this);
                undead.setBoundOrigin(blockpos);
                undead.setLimitedLife(20 + NecromancerEntity.this.f_19796_.m_188503_(140));
                serverLevel.m_47205_((Entity)undead);
            }
        }

        public void spawnUndead(ServerLevel serv) {
            for (int i = 0; i < 3; ++i) {
                BlockPos undeadSpawnPos = NecromancerEntity.this.m_20183_().m_7918_(-2 + NecromancerEntity.this.f_19796_.m_188503_(5), 1, -2 + NecromancerEntity.this.f_19796_.m_188503_(5));
                this.spawnUndead(serv, undeadSpawnPos);
            }
        }

        public void spawnMobs(ServerLevel serv) {
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos = NecromancerEntity.this.m_20183_().m_7918_(-2 + NecromancerEntity.this.f_19796_.m_188503_(5), 0, -2 + NecromancerEntity.this.f_19796_.m_188503_(5));
                if (NecromancerEntity.this.arcRandom.fiftyFifty()) {
                    this.spawnSkeletons(serv, blockpos);
                    continue;
                }
                this.spawnZombie(serv, blockpos);
            }
            if (NecromancerEntity.this.arcRandom.chance(45)) {
                BlockPos blockpos = NecromancerEntity.this.m_20183_().m_7918_(-2 + NecromancerEntity.this.f_19796_.m_188503_(5), 0, -2 + NecromancerEntity.this.f_19796_.m_188503_(5));
                this.spawnSorcerers(serv, blockpos);
            }
            if (NecromancerEntity.this.arcRandom.chance(5)) {
                this.spawnUndead(serv);
            }
            serv.m_247517_(null, NecromancerEntity.this.m_20183_(), this.getSpellPrepareSound(false), SoundSource.HOSTILE);
        }

        @Override
        protected void performSpellCasting() {
            boolean flag;
            NecromancerEntity entity = NecromancerEntity.this;
            boolean bl = flag = entity.m_9236_().f_46443_ || !entity.hasTarget();
            if (flag) {
                return;
            }
            Level level = entity.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serv = (ServerLevel)level;
                this.spawnMobs(serv);
                double posX = entity.m_20097_().m_252807_().f_82479_;
                double posY = entity.m_20097_().m_7494_().m_252807_().f_82480_;
                double posZ = entity.m_20097_().m_252807_().f_82481_;
                PacketHandler.sendToTracking((Level)serv, entity.m_20097_(), new SmokeParticlePacket(60, posX, posY - 0.5, posZ, 0.125f, 0.0f, 0.125f, 255, 255, 255));
            }
        }

        public SoundEvent getSpellPrepareSound(boolean isAir) {
            return isAir ? (SoundEvent)SoundsRegistry.NECROMANCER_SUMMON_AIR.get() : (SoundEvent)SoundsRegistry.NECROMANCER_SUMMON_GROUND.get();
        }

        @Override
        public AbstractNecromancer.NecromancerSpells getSpell() {
            return AbstractNecromancer.NecromancerSpells.SUMMON_MOBS;
        }
    }

    class KnockbackEntitiesGoal
    extends AbstractNecromancer.SpellcasterUseSpellGoal {
        private float range;
        private final TargetingConditions targeting;
        private final boolean strong;
        public final ImmutableList<MobEffectInstance> effects;

        public KnockbackEntitiesGoal(boolean strong, float range, MobEffectInstance ... pEffect) {
            this.targeting = TargetingConditions.m_148352_().m_26883_((double)this.range).m_148355_().m_26893_();
            this.range = range;
            this.effects = ImmutableList.copyOf((Object[])pEffect);
            this.strong = strong;
        }

        public KnockbackEntitiesGoal(boolean strong, MobEffectInstance ... pEffect) {
            this.targeting = TargetingConditions.m_148352_().m_26883_((double)this.range).m_148355_().m_26893_();
            this.range = (NecromancerEntity.this.m_21223_() < 100.0f ? (Integer)CommonConfig.KNOCKBACK_NECROMANCER_RADIUS_STRONG.get() : (Integer)CommonConfig.KNOCKBACK_NECROMANCER_RADIUS.get()).intValue();
            this.effects = ImmutableList.copyOf((Object[])pEffect);
            this.strong = strong;
        }

        @Override
        public boolean m_8036_() {
            List entities = NecromancerEntity.this.m_9236_().m_45971_(LivingEntity.class, this.targeting, (LivingEntity)NecromancerEntity.this, NecromancerEntity.this.m_20191_().m_82400_((double)this.range));
            return super.m_8036_() && NecromancerEntity.this.m_5448_() != null && !NecromancerEntity.this.isCastingSpell() && !entities.isEmpty();
        }

        @Override
        public int getCastingTime() {
            return (Integer)CommonConfig.KNOCKBACK_NECROMANCER_CASTING_TIME.get();
        }

        @Override
        public int getCastingInterval() {
            return (Integer)CommonConfig.KNOCKBACK_NECROMANCER_CASTING_INTERVAL.get();
        }

        @Override
        protected void performSpellCasting() {
            if (NecromancerEntity.this.hasTarget()) {
                Vec3 vec3 = new Vec3(NecromancerEntity.this.m_20185_(), NecromancerEntity.this.m_20186_(), NecromancerEntity.this.m_20189_());
                List entities = NecromancerEntity.this.m_9236_().m_45971_(LivingEntity.class, this.targeting, (LivingEntity)NecromancerEntity.this, NecromancerEntity.this.m_20191_().m_82400_((double)this.range));
                for (LivingEntity entity : entities) {
                    double dZ;
                    double dY;
                    double distance = Math.sqrt(entity.m_20238_(vec3)) / (double)this.range;
                    double dX = entity.m_20185_() - NecromancerEntity.this.m_20185_();
                    double sqrt = Math.sqrt(dX * dX + (dY = entity.m_20188_() - NecromancerEntity.this.m_20186_()) * dY + (dZ = entity.m_20189_() - NecromancerEntity.this.m_20189_()) * dZ);
                    if (sqrt == 0.0) continue;
                    dX /= sqrt;
                    dY /= sqrt;
                    dZ /= sqrt;
                    double seenPercent = Utils.Hit.seenPercent((Vec3)vec3, (Entity)entity, (float)2.0f);
                    double power = (1.0 - distance) * seenPercent;
                    double powerAfterDamp = ProtectionEnchantment.m_45135_((LivingEntity)entity, (double)power);
                    Vec3 vec31 = new Vec3((dX *= powerAfterDamp) * 2.0, (dY *= powerAfterDamp) * 0.5, (dZ *= powerAfterDamp) * 2.0);
                    if (this.strong) {
                        NecromancerEntity.this.m_5634_(NecromancerEntity.this.m_21223_() * 0.05f);
                        entity.m_6469_(NecromancerEntity.this.m_9236_().m_269111_().m_269264_(), entity.m_21223_() * 0.5f);
                    }
                    for (MobEffectInstance effectInstance : this.effects) {
                        NecromancerEntity.this.m_5448_().m_7292_(effectInstance);
                    }
                    entity.f_19864_ = true;
                    entity.m_20256_(entity.m_20184_().m_82549_(vec31));
                }
            }
        }

        public boolean m_6767_() {
            return false;
        }

        @Override
        public SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11868_;
        }

        @Override
        public AbstractNecromancer.NecromancerSpells getSpell() {
            return AbstractNecromancer.NecromancerSpells.KNOCKBACK;
        }
    }

    public class HealSelfSpellGoal
    extends AbstractNecromancer.SpellcasterUseSpellGoal {
        @Override
        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            return NecromancerEntity.this.m_21223_() < NecromancerEntity.this.m_21233_();
        }

        public boolean m_6767_() {
            return false;
        }

        @Override
        public int getCastingTime() {
            return (Integer)CommonConfig.SELF_HEAL_NECROMANCER_CASTING_TIME.get();
        }

        @Override
        public int getCastingInterval() {
            return (Integer)CommonConfig.SELF_HEAL_NECROMANCER_CASTING_INTERVAL.get();
        }

        @Override
        protected void performSpellCasting() {
            ServerLevel serverLevel = (ServerLevel)NecromancerEntity.this.m_9236_();
            if (NecromancerEntity.this.m_21223_() < NecromancerEntity.this.m_21233_()) {
                Vector3d pos = new Vector3d(NecromancerEntity.this.m_20185_(), NecromancerEntity.this.m_20186_(), NecromancerEntity.this.m_20189_());
                Utils.Particles.around((Vector3d)pos, (float)2.0f, (float)1.0f, (Level)serverLevel, (ParticleOptions)ParticleTypes.f_123748_);
                NecromancerEntity.this.m_5634_(((Float)CommonConfig.SELF_HEAL_NECROMANCER_AMOUNT.get()).floatValue());
                serverLevel.m_6263_(null, NecromancerEntity.this.m_20185_(), NecromancerEntity.this.m_20186_(), NecromancerEntity.this.m_20189_(), SoundEvents.f_11862_, NecromancerEntity.this.m_5720_(), 0.42f, 1.23f);
            }
        }

        @Override
        public SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11868_;
        }

        @Override
        public AbstractNecromancer.NecromancerSpells getSpell() {
            return AbstractNecromancer.NecromancerSpells.HEAL;
        }
    }

    public class HealTargetSpellGoal
    extends AbstractNecromancer.SpellcasterUseSpellGoal {
        private final TargetingConditions targeting = TargetingConditions.m_148352_().m_26883_(4.0);

        @Override
        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            List targets = NecromancerEntity.this.m_9236_().m_45971_(Monster.class, this.targeting, (LivingEntity)NecromancerEntity.this, NecromancerEntity.this.m_20191_().m_82400_(4.0));
            return !targets.isEmpty();
        }

        public boolean m_6767_() {
            return false;
        }

        @Override
        public int getCastingTime() {
            return (Integer)CommonConfig.TARGET_HEAL_NECROMANCER_CASTING_TIME.get();
        }

        @Override
        public int getCastingInterval() {
            return (Integer)CommonConfig.TARGET_HEAL_NECROMANCER_CASTING_INTERVAL.get();
        }

        @Override
        protected void performSpellCasting() {
            ServerLevel serverLevel = (ServerLevel)NecromancerEntity.this.m_9236_();
            List targets = serverLevel.m_45971_(Monster.class, this.targeting, (LivingEntity)NecromancerEntity.this, NecromancerEntity.this.m_20191_().m_82400_(4.0));
            ArrayList toHeal = new ArrayList();
            for (Monster target : targets) {
                if (target instanceof NecromancerEntity || !(target.m_21223_() < target.m_21233_())) continue;
                Vector3d pos = new Vector3d(NecromancerEntity.this.m_20185_(), NecromancerEntity.this.m_20186_(), NecromancerEntity.this.m_20189_());
                Utils.Particles.inRadius((Level)serverLevel, null, (ParticleOptions)ParticleTypes.f_123748_, (Vector3d)pos, (float)0.0f, (float)NecromancerEntity.this.m_20155_().f_82471_, (float)4.0f);
                Utils.Hit.healNearbyMobs((MobCategory)MobCategory.MONSTER, (Float)((Float)CommonConfig.TARGET_HEAL_NECROMANCER_AMOUNT.get()), (Level)serverLevel, (LivingEntity)NecromancerEntity.this, toHeal, (Vector3d)pos, (float)0.0f, (float)NecromancerEntity.this.m_20155_().f_82471_, (float)4.0f);
                serverLevel.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_11862_, target.m_5720_(), 0.42f, 1.23f);
                break;
            }
        }

        @Override
        public SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11868_;
        }

        @Override
        public AbstractNecromancer.NecromancerSpells getSpell() {
            return AbstractNecromancer.NecromancerSpells.HEAL;
        }
    }

    public class ApplyEffectSpellGoal
    extends AbstractNecromancer.SpellcasterUseSpellGoal {
        public final ImmutableList<MobEffectInstance> effects;

        public ApplyEffectSpellGoal(MobEffectInstance ... pEffect) {
            this.effects = ImmutableList.copyOf((Object[])pEffect);
        }

        @Override
        public int getCastingTime() {
            return (Integer)CommonConfig.EFFECT_NECROMANCER_CASTING_TIME.get();
        }

        @Override
        public int getCastingInterval() {
            return (Integer)CommonConfig.EFFECT_NECROMANCER_CASTING_INTERVAL.get();
        }

        @Override
        protected void performSpellCasting() {
            if (NecromancerEntity.this.hasTarget()) {
                for (MobEffectInstance effectInstance : this.effects) {
                    NecromancerEntity.this.m_5448_().m_7292_(effectInstance);
                }
            }
        }

        @Override
        public SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11868_;
        }

        @Override
        public AbstractNecromancer.NecromancerSpells getSpell() {
            return AbstractNecromancer.NecromancerSpells.EFFECT;
        }
    }

    public class WololoSpellGoal
    extends AbstractNecromancer.SpellcasterUseSpellGoal {
        private final TargetingConditions wololoTargeting = TargetingConditions.m_148352_().m_26883_(8.0);

        @Override
        public boolean m_8036_() {
            if (NecromancerEntity.this.hasTarget()) {
                return false;
            }
            if (NecromancerEntity.this.isCastingSpell()) {
                return false;
            }
            if (NecromancerEntity.this.f_19797_ < this.nextAttackTickCount) {
                return false;
            }
            List list = NecromancerEntity.this.m_9236_().m_45971_(Skeleton.class, this.wololoTargeting, (LivingEntity)NecromancerEntity.this, NecromancerEntity.this.m_20191_().m_82377_(16.0, 4.0, 16.0));
            if (list.isEmpty()) {
                return false;
            }
            NecromancerEntity.this.setWololoTarget((Skeleton)list.get(NecromancerEntity.this.f_19796_.m_188503_(list.size())));
            return true;
        }

        @Override
        public boolean m_8045_() {
            return NecromancerEntity.this.getWololoTarget() != null && this.attackWarmupDelay > 0;
        }

        public void m_8041_() {
            super.m_8041_();
            NecromancerEntity.this.setWololoTarget(null);
        }

        @Override
        protected void performSpellCasting() {
            DraugrEntity mob;
            Skeleton target = NecromancerEntity.this.getWololoTarget();
            ServerLevel serverlevel = (ServerLevel)NecromancerEntity.this.m_9236_();
            if (target != null && target.m_6084_() && (mob = (DraugrEntity)((EntityType)EntityTypeRegistry.DRAUGR.get()).m_20615_((Level)serverlevel)) != null) {
                serverlevel.m_7967_((Entity)mob);
                BlockPos pos = new BlockPos(target.m_146903_(), target.m_146904_(), target.m_146907_());
                PacketHandler.sendToTracking((Level)serverlevel, target.m_20097_(), new CircleShapedParticlePacket((float)target.m_146903_() + 0.5f, target.m_146904_(), (float)target.m_146907_() + 0.5f, target.m_20155_().f_82471_, 46, 51, 60));
                if (!target.m_21205_().m_41619_()) {
                    mob.m_21008_(InteractionHand.MAIN_HAND, Items.f_42411_.m_7968_());
                } else if (!target.m_21206_().m_41619_()) {
                    mob.m_21008_(InteractionHand.OFF_HAND, Items.f_42411_.m_7968_());
                }
                mob.m_20035_(pos, target.m_146908_(), target.m_146909_());
                mob.m_21563_().m_24946_(target.m_21563_().m_24969_(), target.m_21563_().m_24970_(), target.m_21563_().m_24971_());
                mob.m_21153_(target.m_21223_());
                target.m_146870_();
            }
        }

        @Override
        public int getCastingTime() {
            return 60;
        }

        @Override
        public int getCastingInterval() {
            return 180;
        }

        @Override
        public SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_215772_;
        }

        @Override
        public AbstractNecromancer.NecromancerSpells getSpell() {
            return AbstractNecromancer.NecromancerSpells.WOLOLO;
        }
    }

    class CastingSpellGoal
    extends AbstractNecromancer.SpellcasterCastingSpellGoal {
        CastingSpellGoal() {
        }

        @Override
        public void m_8037_() {
            if (NecromancerEntity.this.hasTarget()) {
                NecromancerEntity.this.m_21563_().m_24960_((Entity)NecromancerEntity.this.m_5448_(), (float)NecromancerEntity.this.m_8085_(), (float)NecromancerEntity.this.m_8132_());
            } else if (NecromancerEntity.this.getWololoTarget() != null) {
                NecromancerEntity.this.m_21563_().m_24960_((Entity)NecromancerEntity.this.getWololoTarget(), (float)NecromancerEntity.this.m_8085_(), (float)NecromancerEntity.this.m_8132_());
            }
        }
    }
}

