/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import pro.komaru.tridot.api.entity.ai.goals.DelayedMeleeAttackGoal;

public class SwampWandererEntity
extends Zombie {
    boolean searchingForLand;
    protected final WaterBoundPathNavigation waterNavigation;
    protected final GroundPathNavigation groundNavigation;

    public SwampWandererEntity(EntityType<? extends SwampWandererEntity> type, Level pLevel) {
        super(type, pLevel);
        this.m_274367_(1.0f);
        this.f_21342_ = new DrownedMoveControl(this);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.waterNavigation = new WaterBoundPathNavigation((Mob)this, pLevel);
        this.groundNavigation = new GroundPathNavigation((Mob)this, pLevel);
    }

    protected void m_6878_() {
        this.f_21345_.m_25352_(2, (Goal)new DrownedGoToWaterGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new DrownedAttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new DrownedGoToBeachGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new DrownedSwimUpGoal(this, 1.2, this.m_9236_().m_5736_()));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{SwampWandererEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::okTarget));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Axolotl.class, true, false));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_));
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11815_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11817_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11819_;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11875_, 0.2f, 0.5f);
    }

    protected void m_213945_(RandomSource pRandom, DifficultyInstance pDifficulty) {
        if ((double)pRandom.m_188501_() > 0.9) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42523_));
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        RandomSource randomsource = pLevel.m_213780_();
        this.m_213945_(randomsource, pDifficulty);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.8f : 1.45f;
    }

    protected boolean m_7593_() {
        return false;
    }

    public boolean m_6914_(LevelReader pLevel) {
        return pLevel.m_45784_((Entity)this);
    }

    public boolean okTarget(@Nullable LivingEntity p_32396_) {
        if (p_32396_ != null) {
            return p_32396_.m_6084_();
        }
        return false;
    }

    public boolean m_6063_() {
        return !this.m_6069_();
    }

    boolean wantsToSwim() {
        if (this.searchingForLand) {
            return true;
        }
        LivingEntity livingentity = this.m_5448_();
        return livingentity != null && livingentity.m_20069_();
    }

    public boolean m_7327_(Entity entityIn) {
        if (!super.m_7327_(entityIn)) {
            return false;
        }
        if (entityIn instanceof LivingEntity) {
            ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 0));
        }
        return true;
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_6109_() && this.m_20069_() && this.wantsToSwim()) {
            this.m_19920_(0.01f, pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    public void m_5844_() {
        if (!this.m_9236_().f_46443_) {
            if (this.m_21515_() && this.m_20069_() && this.wantsToSwim()) {
                this.f_21344_ = this.waterNavigation;
                this.m_20282_(true);
            } else {
                this.f_21344_ = this.groundNavigation;
                this.m_20282_(false);
            }
        }
    }

    public boolean m_6067_() {
        return this.m_6069_();
    }

    protected boolean closeToNextPos() {
        Path path = this.m_21573_().m_26570_();
        if (path != null) {
            BlockPos blockpos = path.m_77406_();
            double d0 = this.m_20275_(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_());
            return d0 < 4.0;
        }
        return false;
    }

    public void setSearchingForLand(boolean pSearchingForLand) {
        this.searchingForLand = pSearchingForLand;
    }

    static class DrownedMoveControl
    extends MoveControl {
        private final SwampWandererEntity drowned;

        public DrownedMoveControl(SwampWandererEntity pDrowned) {
            super((Mob)pDrowned);
            this.drowned = pDrowned;
        }

        public void m_8126_() {
            LivingEntity livingentity = this.drowned.m_5448_();
            if (this.drowned.wantsToSwim() && this.drowned.m_20069_()) {
                if (livingentity != null && livingentity.m_20186_() > this.drowned.m_20186_() || this.drowned.searchingForLand) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, 0.002, 0.0));
                }
                if (this.f_24981_ != MoveControl.Operation.MOVE_TO || this.drowned.m_21573_().m_26571_()) {
                    this.drowned.m_7910_(0.0f);
                    return;
                }
                double d0 = this.f_24975_ - this.drowned.m_20185_();
                double d1 = this.f_24976_ - this.drowned.m_20186_();
                double d2 = this.f_24977_ - this.drowned.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.drowned.m_146922_(this.m_24991_(this.drowned.m_146908_(), f, 90.0f));
                this.drowned.f_20883_ = this.drowned.m_146908_();
                float f1 = (float)(this.f_24978_ * this.drowned.m_21133_(Attributes.f_22279_));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.drowned.m_6113_(), (float)f1);
                this.drowned.m_7910_(f2);
                this.drowned.m_20256_(this.drowned.m_20184_().m_82520_((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
            } else {
                if (!this.drowned.m_20096_()) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, -0.008, 0.0));
                }
                super.m_8126_();
            }
        }
    }

    static class DrownedGoToWaterGoal
    extends Goal {
        private final PathfinderMob mob;
        private double wantedX;
        private double wantedY;
        private double wantedZ;
        private final double speedModifier;
        private final Level level;

        public DrownedGoToWaterGoal(PathfinderMob pMob, double pSpeedModifier) {
            this.mob = pMob;
            this.speedModifier = pSpeedModifier;
            this.level = pMob.m_9236_();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.mob.m_20069_()) {
                LivingEntity target;
                BlockPos targetBlockPos;
                if (this.mob.m_5448_() != null && this.level.m_8055_(targetBlockPos = (target = this.mob.m_5448_()).m_20183_()).m_60713_(Blocks.f_50196_)) {
                    double jumpHeight = 15.5;
                    double jumpSpeed = 0.6;
                    Vec3 jumpVec = new Vec3(target.m_20185_() - this.mob.m_20185_(), jumpHeight, target.m_20189_() - this.mob.m_20189_()).m_82541_().m_82490_(jumpSpeed);
                    if (target.m_20280_((Entity)this.mob) < 5.0) {
                        this.level.m_46961_(targetBlockPos, true);
                        this.mob.m_20256_(jumpVec);
                        this.mob.f_19812_ = true;
                        return true;
                    }
                }
                return false;
            }
            Vec3 vec3 = this.getWaterPos();
            if (vec3 == null) {
                return false;
            }
            this.wantedX = vec3.f_82479_;
            this.wantedY = vec3.f_82480_;
            this.wantedZ = vec3.f_82481_;
            return true;
        }

        public boolean m_8045_() {
            return !this.mob.m_21573_().m_26571_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26519_(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
        }

        @Nullable
        private Vec3 getWaterPos() {
            RandomSource randomsource = this.mob.m_217043_();
            BlockPos blockpos = this.mob.m_20183_();
            for (int i = 0; i < 10; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(randomsource.m_188503_(20) - 10, 2 - randomsource.m_188503_(8), randomsource.m_188503_(20) - 10);
                if (!this.level.m_8055_(blockpos1).m_60713_(Blocks.f_49990_)) continue;
                return Vec3.m_82539_((Vec3i)blockpos1);
            }
            return null;
        }
    }

    static class DrownedAttackGoal
    extends DelayedMeleeAttackGoal {
        private final SwampWandererEntity drowned;

        public DrownedAttackGoal(SwampWandererEntity pDrowned, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super((PathfinderMob)pDrowned, pSpeedModifier, 20, pFollowingTargetEvenIfNotSeen);
            this.drowned = pDrowned;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.drowned.okTarget(this.drowned.m_5448_());
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.drowned.okTarget(this.drowned.m_5448_());
        }
    }

    static class DrownedGoToBeachGoal
    extends MoveToBlockGoal {
        private final SwampWandererEntity drowned;

        public DrownedGoToBeachGoal(SwampWandererEntity pDrowned, double pSpeedModifier) {
            super((PathfinderMob)pDrowned, pSpeedModifier, 8, 2);
            this.drowned = pDrowned;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.drowned.m_9236_().m_46461_() && this.drowned.m_20069_() && this.drowned.m_20186_() >= (double)(this.drowned.m_9236_().m_5736_() - 3);
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            BlockPos blockpos = pPos.m_7494_();
            return pLevel.m_46859_(blockpos) && pLevel.m_46859_(blockpos.m_7494_()) && pLevel.m_8055_(pPos).m_60634_((BlockGetter)pLevel, pPos, (Entity)this.drowned);
        }

        public void m_8056_() {
            this.drowned.setSearchingForLand(false);
            this.drowned.f_21344_ = (PathNavigation)this.drowned.groundNavigation;
            super.m_8056_();
        }

        public void m_8041_() {
            super.m_8041_();
        }
    }

    static class DrownedSwimUpGoal
    extends Goal {
        private final SwampWandererEntity drowned;
        private final double speedModifier;
        private final int seaLevel;
        private boolean stuck;

        public DrownedSwimUpGoal(SwampWandererEntity pDrowned, double pSpeedModifier, int pSeaLevel) {
            this.drowned = pDrowned;
            this.speedModifier = pSpeedModifier;
            this.seaLevel = pSeaLevel;
        }

        public boolean m_8036_() {
            return this.drowned.m_20069_() && this.drowned.m_20186_() < (double)(this.seaLevel - 2);
        }

        public boolean m_8045_() {
            return this.m_8036_() && !this.stuck;
        }

        public void m_8037_() {
            if (this.drowned.m_20186_() < (double)(this.seaLevel - 1) && (this.drowned.m_21573_().m_26571_() || this.drowned.closeToNextPos())) {
                Vec3 vec3 = DefaultRandomPos.m_148412_((PathfinderMob)this.drowned, (int)4, (int)12, (Vec3)new Vec3(this.drowned.m_20185_(), (double)(this.seaLevel - 1), this.drowned.m_20189_()), (double)1.5707963705062866);
                if (vec3 == null) {
                    this.stuck = true;
                    return;
                }
                this.drowned.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, this.speedModifier);
            }
        }

        public void m_8056_() {
            this.drowned.setSearchingForLand(true);
            this.stuck = false;
        }

        public void m_8041_() {
            this.drowned.setSearchingForLand(false);
        }
    }
}

