/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living;

import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.entity.ai.goals.AvoidStrongEntityGoal;
import com.idark.valoria.registries.entity.ai.goals.CollectBerriesGoal;
import com.idark.valoria.registries.entity.ai.goals.ReasonableAvoidEntityGoal;
import com.idark.valoria.registries.entity.ai.goals.ReasonablePanicGoal;
import com.idark.valoria.registries.entity.ai.goals.RemoveBlockGoal;
import com.idark.valoria.registries.entity.ai.goals.RemoveCropsGoal;
import com.idark.valoria.registries.entity.ai.goals.SearchForItemsGoal;
import com.idark.valoria.registries.entity.living.AbstractGoblin;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;

public class Goblin
extends AbstractGoblin {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public ArcRandom arcRandom = Tmp.rnd;

    public Goblin(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 5;
    }

    public boolean m_7327_(Entity pEntity) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        return super.m_7327_(pEntity);
    }

    protected float m_6121_() {
        return 0.45f;
    }

    public float m_6100_() {
        return this.m_6162_() ? (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.5f : (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.25f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundsRegistry.GOBLIN_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)SoundsRegistry.GOBLIN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundsRegistry.GOBLIN_DEATH.get();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 160;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    protected void m_213945_(RandomSource pRandom, DifficultyInstance pDifficulty) {
        super.m_213945_(pRandom, pDifficulty);
        if (this.arcRandom.chance(0.3f)) {
            this.m_8061_(EquipmentSlot.MAINHAND, ((Item)goblinCanSpawnWith.get(pRandom.m_216339_(0, goblinCanSpawnWith.size()))).m_7968_());
        }
    }

    public static boolean isBrightEnoughToSpawn(BlockAndTintGetter pLevel, BlockPos pPos) {
        return pLevel.m_45524_(pPos, 0) > 8;
    }

    public static boolean checkGoblinSpawnRules(EntityType<Goblin> pGoblin, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pLevel.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_184228_) && Goblin.isBrightEnoughToSpawn((BlockAndTintGetter)pLevel, pPos);
    }

    @Override
    public void m_7822_(byte pId) {
        if (pId == 4) {
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(pId);
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, 10, true, true, p_28604_ -> p_28604_ instanceof Chicken || p_28604_ instanceof Rabbit || p_28604_ instanceof Pig));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractFish.class, 20, true, true, p_28600_ -> p_28600_ instanceof AbstractSchoolingFish));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true, true));
        this.f_21346_.m_25352_(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
        this.f_21345_.m_25352_(0, new AvoidStrongEntityGoal<Player>(this, Player.class, 16.0f, 1.2, 1.6));
        this.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 8.0f, 1.6, 1.4));
        this.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)this, Creeper.class, 12.0f, 1.8, 1.4));
        this.f_21345_.m_25352_(0, (Goal)new SearchForItemsGoal(this, ALLOWED_ITEMS));
        this.f_21345_.m_25352_(0, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(0, new ReasonableAvoidEntityGoal<Player>(this, Player.class, 15.0f, 1.25, 2.0, this.isLowHP()));
        this.f_21345_.m_25352_(0, (Goal)new ReasonablePanicGoal(this, 2.0, this.isLowHP()));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new CollectBerriesGoal(this, 1.2, 12, 4));
        this.f_21345_.m_25352_(6, (Goal)new RemoveBlockGoal(Blocks.f_50093_, this, 1.4, 10));
        this.f_21345_.m_25352_(6, (Goal)new RemoveCropsGoal(this, 1.2, 10));
        this.f_21345_.m_25352_(3, (Goal)new FollowMobGoal((Mob)this, 1.2, 6.0f, 10.0f));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        RandomSource randomsource = pLevel.m_213780_();
        this.m_213945_(randomsource, pDifficulty);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }
}

