/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.block.types;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.idark.valoria.core.interfaces.FleshSpreaderBehaviour;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.block.types.BloodVeinBlock;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public class FleshSpreader {
    final boolean isWorldGeneration;
    private final TagKey<Block> replaceableBlocks;
    private final int growthSpawnCost;
    private final int noGrowthRadius;
    private final int chargeDecayRate;
    private final int additionalDecayRate;
    private List<ChargeCursor> cursors = new ArrayList<ChargeCursor>();
    private static final Logger LOGGER = LogUtils.getLogger();

    public FleshSpreader(boolean pIsWorldGeneration, TagKey<Block> pReplaceableBlocks, int pGrowthSpawnCoat, int pNoGrowthRadius, int pChargeDecayRate, int pAdditionalDecayRate) {
        this.isWorldGeneration = pIsWorldGeneration;
        this.replaceableBlocks = pReplaceableBlocks;
        this.growthSpawnCost = pGrowthSpawnCoat;
        this.noGrowthRadius = pNoGrowthRadius;
        this.chargeDecayRate = pChargeDecayRate;
        this.additionalDecayRate = pAdditionalDecayRate;
    }

    public static FleshSpreader createLevelSpreader() {
        return new FleshSpreader(false, (TagKey<Block>)BlockTags.f_215823_, 10, 4, 10, 5);
    }

    public static FleshSpreader createWorldGenSpreader() {
        return new FleshSpreader(true, (TagKey<Block>)BlockTags.f_215824_, 50, 1, 5, 10);
    }

    public TagKey<Block> replaceableBlocks() {
        return this.replaceableBlocks;
    }

    public int growthSpawnCost() {
        return this.growthSpawnCost;
    }

    public int noGrowthRadius() {
        return this.noGrowthRadius;
    }

    public int chargeDecayRate() {
        return this.chargeDecayRate;
    }

    public int additionalDecayRate() {
        return this.additionalDecayRate;
    }

    public boolean isWorldGeneration() {
        return this.isWorldGeneration;
    }

    @VisibleForTesting
    public List<ChargeCursor> getCursors() {
        return this.cursors;
    }

    public void clear() {
        this.cursors.clear();
    }

    public void load(CompoundTag pTag) {
        if (pTag.m_128425_("cursors", 9)) {
            this.cursors.clear();
            List list = ChargeCursor.CODEC.listOf().parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)pTag.m_128437_("cursors", 10))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseGet(ArrayList::new);
            int i = Math.min(list.size(), 32);
            for (int j = 0; j < i; ++j) {
                this.addCursor((ChargeCursor)list.get(j));
            }
        }
    }

    public void save(CompoundTag pTag) {
        ChargeCursor.CODEC.listOf().encodeStart((DynamicOps)NbtOps.f_128958_, this.cursors).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_222273_ -> pTag.m_128365_("cursors", p_222273_));
    }

    public void addCursors(BlockPos pPos, int pCharge) {
        while (pCharge > 0) {
            int i = Math.min(pCharge, 1000);
            this.addCursor(new ChargeCursor(pPos, i));
            pCharge -= i;
        }
    }

    private void addCursor(ChargeCursor pCursor) {
        if (this.cursors.size() < 32) {
            this.cursors.add(pCursor);
        }
    }

    public void updateCursors(LevelAccessor pLevel, BlockPos pPos, RandomSource pRandom, boolean pShouldConvertBlocks) {
        if (!this.cursors.isEmpty()) {
            ArrayList<ChargeCursor> list = new ArrayList<ChargeCursor>();
            HashMap<BlockPos, ChargeCursor> map = new HashMap<BlockPos, ChargeCursor>();
            Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
            for (ChargeCursor spreader : this.cursors) {
                spreader.update(pLevel, pPos, pRandom, this, pShouldConvertBlocks);
                if (spreader.charge < 0) continue;
                BlockPos blockpos = spreader.getPos();
                object2intmap.computeInt((Object)blockpos, (p_222264_, p_222265_) -> (p_222265_ == null ? 0 : p_222265_) + spreader.charge);
                ChargeCursor spreader1 = (ChargeCursor)map.get(blockpos);
                if (spreader1 == null) {
                    map.put(blockpos, spreader);
                    list.add(spreader);
                    continue;
                }
                if (!this.isWorldGeneration() && spreader.charge + spreader1.charge <= 1000) {
                    spreader1.mergeWith(spreader);
                    continue;
                }
                list.add(spreader);
                if (spreader.charge >= spreader1.charge) continue;
                map.put(blockpos, spreader);
            }
            this.cursors = list;
        }
    }

    public static class ChargeCursor {
        private static final ObjectArrayList<Vec3i> NON_CORNER_NEIGHBOURS = (ObjectArrayList)Util.m_137469_((Object)new ObjectArrayList(18), p_222338_ -> BlockPos.m_121990_((BlockPos)new BlockPos(-1, -1, -1), (BlockPos)new BlockPos(1, 1, 1)).filter(p_222336_ -> (p_222336_.m_123341_() == 0 || p_222336_.m_123342_() == 0 || p_222336_.m_123343_() == 0) && !p_222336_.equals((Object)BlockPos.f_121853_)).map(BlockPos::m_7949_).forEach(arg_0 -> ((ObjectArrayList)p_222338_).add(arg_0)));
        private BlockPos pos;
        int charge;
        private int updateDelay;
        private int decayDelay;
        @Nullable
        private Set<Direction> facings;
        private static final Codec<Set<Direction>> DIRECTION_SET = Direction.f_175356_.listOf().xmap(p_222340_ -> Sets.newEnumSet((Iterable)p_222340_, Direction.class), Lists::newArrayList);
        public static final Codec<ChargeCursor> CODEC = RecordCodecBuilder.create(p_222330_ -> p_222330_.group((App)BlockPos.f_121852_.fieldOf("pos").forGetter(ChargeCursor::getPos), (App)Codec.intRange((int)0, (int)1000).fieldOf("charge").orElse((Object)0).forGetter(ChargeCursor::getCharge), (App)Codec.intRange((int)0, (int)1).fieldOf("decay_delay").orElse((Object)1).forGetter(ChargeCursor::getDecayDelay), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("update_delay").orElse((Object)0).forGetter(p_222346_ -> p_222346_.updateDelay), (App)DIRECTION_SET.optionalFieldOf("facings").forGetter(p_222343_ -> Optional.ofNullable(p_222343_.getFacingData()))).apply((Applicative)p_222330_, ChargeCursor::new));

        private ChargeCursor(BlockPos p_222299_, int p_222300_, int p_222301_, int p_222302_, Optional<Set<Direction>> p_222303_) {
            this.pos = p_222299_;
            this.charge = p_222300_;
            this.decayDelay = p_222301_;
            this.updateDelay = p_222302_;
            this.facings = p_222303_.orElse(null);
        }

        public ChargeCursor(BlockPos pPos, int pCharge) {
            this(pPos, pCharge, 1, 0, Optional.empty());
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public int getCharge() {
            return this.charge;
        }

        public int getDecayDelay() {
            return this.decayDelay;
        }

        @Nullable
        public Set<Direction> getFacingData() {
            return this.facings;
        }

        private boolean shouldUpdate(LevelAccessor pLevel, BlockPos pPos, boolean pIsWorldGeneration) {
            if (this.charge <= 0) {
                return false;
            }
            if (pIsWorldGeneration) {
                return true;
            }
            if (pLevel instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)pLevel;
                return serverlevel.m_220393_(pPos);
            }
            return false;
        }

        public void update(LevelAccessor pLevel, BlockPos pPos, RandomSource pRandom, FleshSpreader pSpreader, boolean pShouldConvertBlocks) {
            if (this.shouldUpdate(pLevel, pPos, pSpreader.isWorldGeneration)) {
                if (this.updateDelay > 0) {
                    --this.updateDelay;
                } else {
                    BlockState blockstate = pLevel.m_8055_(this.pos);
                    FleshSpreaderBehaviour fleshBehaviour = ChargeCursor.getBlockBehaviour(blockstate);
                    if (pShouldConvertBlocks && fleshBehaviour.attemptSpreadVein(pLevel, this.pos, blockstate, this.facings, pSpreader.isWorldGeneration())) {
                        if (fleshBehaviour.canChangeBlockStateOnSpread()) {
                            blockstate = pLevel.m_8055_(this.pos);
                            fleshBehaviour = ChargeCursor.getBlockBehaviour(blockstate);
                        }
                        pLevel.m_5594_(null, this.pos, (SoundEvent)SoundsRegistry.CYST_SPREAD.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    this.charge = fleshBehaviour.attemptUseCharge(this, pLevel, pPos, pRandom, pSpreader, pShouldConvertBlocks);
                    if (this.charge <= 0) {
                        fleshBehaviour.onDischarged(pLevel, blockstate, this.pos, pRandom);
                    } else {
                        BlockPos blockpos = ChargeCursor.getValidMovementPos(pLevel, this.pos, pRandom);
                        if (blockpos != null) {
                            fleshBehaviour.onDischarged(pLevel, blockstate, this.pos, pRandom);
                            this.pos = blockpos.m_7949_();
                            if (pSpreader.isWorldGeneration() && !this.pos.m_123314_(new Vec3i(pPos.m_123341_(), this.pos.m_123342_(), pPos.m_123343_()), 15.0)) {
                                this.charge = 0;
                                return;
                            }
                            blockstate = pLevel.m_8055_(blockpos);
                        }
                        if (blockstate.m_60734_() instanceof FleshSpreaderBehaviour) {
                            this.facings = MultifaceBlock.m_221584_((BlockState)blockstate);
                        }
                        this.decayDelay = fleshBehaviour.updateDecayDelay(this.decayDelay);
                        this.updateDelay = fleshBehaviour.getSpreadDelay();
                    }
                }
            }
        }

        void mergeWith(ChargeCursor pCursor) {
            this.charge += pCursor.charge;
            pCursor.charge = 0;
            this.updateDelay = Math.min(this.updateDelay, pCursor.updateDelay);
        }

        private static FleshSpreaderBehaviour getBlockBehaviour(BlockState pState) {
            FleshSpreaderBehaviour fleshBehaviour;
            Block block = pState.m_60734_();
            FleshSpreaderBehaviour fleshBehaviour1 = block instanceof FleshSpreaderBehaviour ? (fleshBehaviour = (FleshSpreaderBehaviour)block) : FleshSpreaderBehaviour.DEFAULT;
            return fleshBehaviour1;
        }

        private static List<Vec3i> getRandomizedNonCornerNeighbourOffsets(RandomSource pRandom) {
            return Util.m_214611_(NON_CORNER_NEIGHBOURS, (RandomSource)pRandom);
        }

        @Nullable
        private static BlockPos getValidMovementPos(LevelAccessor pLevel, BlockPos pPos, RandomSource pRandom) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.m_122032_();
            BlockPos.MutableBlockPos blockpos$mutableblockpos1 = pPos.m_122032_();
            for (Vec3i vec3i : ChargeCursor.getRandomizedNonCornerNeighbourOffsets(pRandom)) {
                blockpos$mutableblockpos1.m_175306_((Vec3i)pPos, vec3i);
                BlockState blockstate = pLevel.m_8055_((BlockPos)blockpos$mutableblockpos1);
                if (!(blockstate.m_60734_() instanceof FleshSpreaderBehaviour) || !ChargeCursor.isMovementUnobstructed(pLevel, pPos, (BlockPos)blockpos$mutableblockpos1)) continue;
                blockpos$mutableblockpos.m_122190_((Vec3i)blockpos$mutableblockpos1);
                if (!BloodVeinBlock.hasSubstrateAccess(pLevel, blockstate, (BlockPos)blockpos$mutableblockpos1)) continue;
                break;
            }
            return blockpos$mutableblockpos.equals((Object)pPos) ? null : blockpos$mutableblockpos;
        }

        private static boolean isMovementUnobstructed(LevelAccessor pLevel, BlockPos pFromPos, BlockPos pToPos) {
            if (pFromPos.m_123333_((Vec3i)pToPos) == 1) {
                return true;
            }
            BlockPos blockpos = pToPos.m_121996_((Vec3i)pFromPos);
            Direction direction = Direction.m_122387_((Direction.Axis)Direction.Axis.X, (Direction.AxisDirection)(blockpos.m_123341_() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
            Direction direction1 = Direction.m_122387_((Direction.Axis)Direction.Axis.Y, (Direction.AxisDirection)(blockpos.m_123342_() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
            Direction direction2 = Direction.m_122387_((Direction.Axis)Direction.Axis.Z, (Direction.AxisDirection)(blockpos.m_123343_() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
            if (blockpos.m_123341_() == 0) {
                return ChargeCursor.isUnobstructed(pLevel, pFromPos, direction1) || ChargeCursor.isUnobstructed(pLevel, pFromPos, direction2);
            }
            if (blockpos.m_123342_() == 0) {
                return ChargeCursor.isUnobstructed(pLevel, pFromPos, direction) || ChargeCursor.isUnobstructed(pLevel, pFromPos, direction2);
            }
            return ChargeCursor.isUnobstructed(pLevel, pFromPos, direction) || ChargeCursor.isUnobstructed(pLevel, pFromPos, direction1);
        }

        private static boolean isUnobstructed(LevelAccessor pLevel, BlockPos pPos, Direction pDirection) {
            BlockPos blockpos = pPos.m_121945_(pDirection);
            return !pLevel.m_8055_(blockpos).m_60783_((BlockGetter)pLevel, blockpos, pDirection.m_122424_());
        }
    }
}

