/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.block.types;

import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.block.entity.FleshCystBlockEntity;
import com.idark.valoria.registries.entity.living.minions.FleshSentinel;
import com.idark.valoria.util.Pal;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.client.render.TridotRenderTypes;
import pro.komaru.tridot.common.registry.block.entity.TickableBlockEntity;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.Interp;

public class FleshCystBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public FleshCystBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new FleshCystBlockEntity(pPos, pState);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{WATERLOGGED});
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    private void spawnSentinels(ServerLevel world, BlockPos pos) {
        FleshSentinel sentinel = (FleshSentinel)((EntityType)EntityTypeRegistry.FLESH_SENTINEL.get()).m_20615_((Level)world);
        if (sentinel != null) {
            RandomSource randomsource = world.m_213780_();
            double d0 = (double)pos.m_123341_() + (randomsource.m_188500_() - randomsource.m_188500_()) * 6.0 + 0.5;
            double d1 = pos.m_123342_() + randomsource.m_188503_(3) - 1;
            double d2 = (double)pos.m_123343_() + (randomsource.m_188500_() - randomsource.m_188500_()) * 6.0 + 0.5;
            if (world.m_45772_(sentinel.m_6095_().m_20585_(d0, d1, d2))) {
                sentinel.m_7678_(d0, d1, d2, 0.0f, 0.0f);
                sentinel.setBoundOrigin(pos);
                world.m_7967_((Entity)sentinel);
            }
        }
    }

    private static VoxelShape makeShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125625, (double)0.125625, (double)0.125625, (double)0.874375, (double)0.561875, (double)0.874375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.125, (double)0.0, (double)1.0, (double)0.375, (double)0.3125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.125, (double)0.0, (double)0.25, (double)0.375, (double)0.3125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.125, (double)0.6875, (double)0.25, (double)0.375, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.125, (double)0.6875, (double)1.0, (double)0.375, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return FleshCystBlock.makeShape();
    }

    public void onDestroy(Level pLevel, BlockPos pPos) {
        if (!pLevel.m_5776_()) {
            for (int i = 0; i < 3; ++i) {
                this.spawnSentinels((ServerLevel)pLevel, pPos);
            }
        }
        if (pLevel.m_5776_()) {
            this.spawnDestroyParticles(pLevel, pPos);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnDestroyParticles(Level pLevel, BlockPos pPos) {
        ((ParticleBuilder)((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.WISP).setRenderType(TridotRenderTypes.TRANSLUCENT_PARTICLE).setColorData(ColorParticleData.create((Col)Pal.kiwi, (Col)Pal.mindaro).build()).setScaleData(GenericParticleData.create((float)0.425f, (float)0.075f, (float)0.0f).setEasing((Interp)Interp.bounceOut).build()).setLifetime(35).randomOffset(0.5)).setGravity(0.0125f).flatRandomVelocity(0.025, Tmp.rnd.randomValueUpTo(0.055), 0.025)).repeat(pLevel, pPos.m_252807_().f_82479_, pPos.m_252807_().f_82480_ + 0.2, pPos.m_252807_().f_82481_, 5);
    }

    public void m_5581_(Level pLevel, BlockState pState, BlockHitResult pHit, Projectile pProjectile) {
        pLevel.m_46961_(pHit.m_82425_(), true);
        this.onDestroy(pLevel, pHit.m_82425_());
    }

    public void m_142072_(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, float pFallDistance) {
        if (pFallDistance > 1.0f) {
            pLevel.m_46961_(pPos, false);
            this.onDestroy(pLevel, pPos);
        }
    }

    public void m_6786_(LevelAccessor pLevel, BlockPos pos, BlockState state) {
        if (pLevel instanceof Level) {
            Level level = (Level)pLevel;
            this.onDestroy(level, pos);
        }
    }

    public void m_7592_(Level pLevel, BlockPos pos, Explosion explosionIn) {
        this.onDestroy(pLevel, pos);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return TickableBlockEntity.getTickerHelper();
    }

    public int getExpDrop(BlockState state, LevelReader world, RandomSource randomSource, BlockPos pos, int fortune, int silktouch) {
        return 15 + randomSource.m_188503_(25);
    }
}

