/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.block.types;

import com.google.common.collect.ImmutableList;
import com.idark.valoria.Valoria;
import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.particle.FireTrapParticlePacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;

public class FireTrapBlock
extends Block {
    public float damage;
    public int secondsOnFire;
    public BlockState state;
    public ColorParticleData color;
    public final ImmutableList<MobEffectInstance> effects;

    public FireTrapBlock(BlockState pState, float pDamage, int pSecondsOnFire, ColorParticleData pColor, BlockBehaviour.Properties properties) {
        super(properties);
        this.damage = pDamage;
        this.secondsOnFire = pSecondsOnFire;
        this.state = pState;
        this.color = pColor;
        this.effects = ImmutableList.of();
    }

    public FireTrapBlock(BlockState pState, float pDamage, int pSecondsOnFire, ColorParticleData pColor, BlockBehaviour.Properties properties, MobEffectInstance ... pEffects) {
        super(properties);
        this.damage = pDamage;
        this.secondsOnFire = pSecondsOnFire;
        this.state = pState;
        this.color = pColor;
        this.effects = ImmutableList.copyOf((Object[])pEffects);
    }

    public static boolean isWaterNearby(Level world, BlockPos centerPos, int radius) {
        for (int xOffset = -radius; xOffset <= radius; ++xOffset) {
            for (int yOffset = -radius; yOffset <= radius; ++yOffset) {
                for (int zOffset = -radius; zOffset <= radius; ++zOffset) {
                    BlockPos currentPos = centerPos.m_7918_(xOffset, yOffset, zOffset);
                    FluidState fluidState = world.m_6425_(currentPos);
                    if (fluidState.m_76152_() != Fluids.f_76193_) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (pLevel.m_46469_().m_46207_(Valoria.TRAP_ACTIVATING) && (pLevel.m_46791_() != Difficulty.PEACEFUL && pEntity instanceof Player || pEntity instanceof ItemEntity)) {
            this.activateTrap(pLevel, pPos, pEntity);
        }
    }

    private void activateTrap(Level level, BlockPos pos, Entity entityIn) {
        LivingEntity living;
        if (entityIn instanceof LivingEntity && EnchantmentHelper.m_44938_((LivingEntity)(living = (LivingEntity)entityIn))) {
            return;
        }
        if (FireTrapBlock.isWaterNearby(level, pos, 1)) {
            level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.05f, level.m_213780_().m_188501_() * 0.5f + 0.5f);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_() + level.m_213780_().m_188500_(), (double)pos.m_123342_() + 0.7, (double)pos.m_123343_() + level.m_213780_().m_188500_(), 0.0, 0.05, 0.0);
        } else {
            level.m_5594_(null, pos, SoundEvents.f_11928_, SoundSource.BLOCKS, 0.3f, level.m_213780_().m_188501_() * 0.25f + 0.6f);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                PacketHandler.sendToTracking((Level)serverLevel, pos, new FireTrapParticlePacket(pos.m_252807_().f_82479_, pos.m_123342_(), pos.m_252807_().f_82481_, (int)this.color.r1, (int)this.color.g1, (int)this.color.b1, (int)this.color.r2, (int)this.color.g2, (int)this.color.b2));
                if (entityIn instanceof LivingEntity) {
                    LivingEntity living1 = (LivingEntity)entityIn;
                    living1.m_6469_(living1.m_269291_().m_269387_(), this.damage);
                    living1.m_20254_(this.secondsOnFire);
                    if (!this.effects.isEmpty()) {
                        for (MobEffectInstance effectInstance : this.effects) {
                            living1.m_7292_(new MobEffectInstance(effectInstance));
                        }
                    }
                }
                entityIn.m_146850_(GameEvent.f_223702_);
                serverLevel.m_46597_(pos, this.state);
            }
        }
    }
}

