/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.block.types;

import com.idark.valoria.core.interfaces.FleshSpreaderBehaviour;
import com.idark.valoria.registries.BlockRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.block.types.FleshSpreader;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import pro.komaru.tridot.util.Tmp;

public class BloodVeinBlock
extends MultifaceBlock
implements FleshSpreaderBehaviour,
SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final MultifaceSpreader veinSpreader = new MultifaceSpreader((MultifaceSpreader.SpreadConfig)new SpreaderConfig(MultifaceSpreader.f_221586_));
    private final MultifaceSpreader sameSpaceSpreader = new MultifaceSpreader((MultifaceSpreader.SpreadConfig)new SpreaderConfig(MultifaceSpreader.SpreadType.SAME_POSITION));

    public BloodVeinBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public MultifaceSpreader m_213612_() {
        return this.veinSpreader;
    }

    public MultifaceSpreader getSameSpaceSpreader() {
        return this.sameSpaceSpreader;
    }

    public static boolean regrow(LevelAccessor pLevel, BlockPos pPos, BlockState pState, Collection<Direction> pDirections) {
        boolean flag = false;
        BlockState blockstate = ((Block)BlockRegistry.bloodVein.get()).m_49966_();
        for (Direction direction : pDirections) {
            BlockPos blockpos;
            if (!BloodVeinBlock.m_153829_((BlockGetter)pLevel, (Direction)direction, (BlockPos)(blockpos = pPos.m_121945_(direction)), (BlockState)pLevel.m_8055_(blockpos))) continue;
            blockstate = (BlockState)blockstate.m_61124_((Property)BloodVeinBlock.m_153933_((Direction)direction), (Comparable)Boolean.TRUE);
            flag = true;
        }
        if (!flag) {
            return false;
        }
        if (!pState.m_60819_().m_76178_()) {
            blockstate = (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.TRUE);
        }
        pLevel.m_7731_(pPos, blockstate, 3);
        return true;
    }

    @Override
    public void onDischarged(LevelAccessor pLevel, BlockState pState, BlockPos pPos, RandomSource pRandom) {
        if (pState.m_60713_((Block)this)) {
            for (Direction direction : f_153806_) {
                BooleanProperty booleanproperty = BloodVeinBlock.m_153933_((Direction)direction);
                if (!((Boolean)pState.m_61143_((Property)booleanproperty)).booleanValue() || !pLevel.m_8055_(pPos.m_121945_(direction)).m_60713_(Blocks.f_220855_)) continue;
                pState = (BlockState)pState.m_61124_((Property)booleanproperty, (Comparable)Boolean.FALSE);
            }
            if (!BloodVeinBlock.m_153960_((BlockState)pState)) {
                FluidState fluidstate = pLevel.m_6425_(pPos);
                pState = (fluidstate.m_76178_() ? Blocks.f_50016_ : Blocks.f_49990_).m_49966_();
            }
            pLevel.m_7731_(pPos, pState, 3);
            FleshSpreaderBehaviour.super.onDischarged(pLevel, pState, pPos, pRandom);
        }
    }

    @Override
    public int attemptUseCharge(FleshSpreader.ChargeCursor pCursor, LevelAccessor pLevel, BlockPos pPos, RandomSource pRandom, FleshSpreader pSpreader, boolean pShouldConvertBlocks) {
        if (pShouldConvertBlocks && this.attemptPlace(pSpreader, pLevel, pCursor.getPos(), pRandom)) {
            return pCursor.getCharge() - 1;
        }
        return pRandom.m_188503_(pSpreader.chargeDecayRate()) == 0 ? Mth.m_14143_((float)((float)pCursor.getCharge() * 0.5f)) : pCursor.getCharge();
    }

    private boolean attemptPlace(FleshSpreader pSpreader, LevelAccessor pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockState blockstate = pLevel.m_8055_(pPos);
        TagKey<Block> tagkey = pSpreader.replaceableBlocks();
        for (Direction direction : Direction.m_235667_((RandomSource)pRandom)) {
            BlockPos blockpos;
            BlockState blockstate1;
            if (!BloodVeinBlock.m_153900_((BlockState)blockstate, (Direction)direction) || !(blockstate1 = pLevel.m_8055_(blockpos = pPos.m_121945_(direction))).m_204336_(tagkey)) continue;
            BlockState blockstate2 = Tmp.rnd.fiftyFifty() ? ((Block)BlockRegistry.fleshBlock.get()).m_49966_() : ((Block)BlockRegistry.meatBlock.get()).m_49966_();
            pLevel.m_7731_(blockpos, blockstate2, 3);
            Block.m_49897_((BlockState)blockstate1, (BlockState)blockstate2, (LevelAccessor)pLevel, (BlockPos)blockpos);
            pLevel.m_5594_(null, blockpos, (SoundEvent)SoundsRegistry.CYST_SPREAD.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            this.veinSpreader.m_221657_(blockstate2, pLevel, blockpos, pSpreader.isWorldGeneration());
            Direction direction1 = direction.m_122424_();
            for (Direction direction2 : f_153806_) {
                BlockPos blockpos1;
                BlockState blockstate3;
                if (direction2 == direction1 || !(blockstate3 = pLevel.m_8055_(blockpos1 = blockpos.m_121945_(direction2))).m_60713_((Block)this)) continue;
                this.onDischarged(pLevel, blockstate3, blockpos1, pRandom);
            }
            return true;
        }
        return false;
    }

    public static boolean hasSubstrateAccess(LevelAccessor pLevel, BlockState pState, BlockPos pPos) {
        if (!pState.m_60713_((Block)BlockRegistry.bloodVein.get())) {
            return false;
        }
        for (Direction direction : f_153806_) {
            if (!BloodVeinBlock.m_153900_((BlockState)pState, (Direction)direction) || !pLevel.m_8055_(pPos.m_121945_(direction)).m_204336_(BlockTags.f_215823_)) continue;
            return true;
        }
        return false;
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{WATERLOGGED});
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        return !pUseContext.m_43722_().m_150930_(((Block)BlockRegistry.bloodVein.get()).m_5456_()) || super.m_6864_(pState, pUseContext);
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    class SpreaderConfig
    extends MultifaceSpreader.DefaultSpreaderConfig {
        private final MultifaceSpreader.SpreadType[] spreadTypes;

        public SpreaderConfig(MultifaceSpreader.SpreadType ... pSpreadTypes) {
            super((MultifaceBlock)BloodVeinBlock.this);
            this.spreadTypes = pSpreadTypes;
        }

        public boolean m_213938_(BlockGetter pLevel, BlockPos pPos, BlockPos pSpreadPos, Direction pDirection, BlockState pState) {
            BlockState blockstate = pLevel.m_8055_(pSpreadPos.m_121945_(pDirection));
            if (!(blockstate.m_60713_((Block)BlockRegistry.fleshBlock.get()) || blockstate.m_60713_((Block)BlockRegistry.meatBlock.get()) || blockstate.m_60713_((Block)BlockRegistry.fleshCyst.get()) || blockstate.m_60713_(Blocks.f_50110_))) {
                BlockPos blockpos;
                if (pPos.m_123333_((Vec3i)pSpreadPos) == 2 && pLevel.m_8055_(blockpos = pPos.m_121945_(pDirection.m_122424_())).m_60783_(pLevel, blockpos, pDirection)) {
                    return false;
                }
                FluidState fluidstate = pState.m_60819_();
                if (!fluidstate.m_76178_() && !fluidstate.m_192917_((Fluid)Fluids.f_76193_)) {
                    return false;
                }
                if (pState.m_204336_(BlockTags.f_13076_)) {
                    return false;
                }
                return pState.m_247087_() || super.m_213938_(pLevel, pPos, pSpreadPos, pDirection, pState);
            }
            return false;
        }

        public MultifaceSpreader.SpreadType[] m_214109_() {
            return this.spreadTypes;
        }

        public boolean m_214107_(BlockState pOtherBlock) {
            return !pOtherBlock.m_60713_((Block)BlockRegistry.bloodVein.get());
        }
    }
}

