/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.block.entity;

import com.idark.valoria.registries.block.entity.BlockSimpleInventory;
import com.idark.valoria.util.ValoriaUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.common.registry.block.entity.TickableBlockEntity;

public abstract class AbstractAltarBlockEntity
extends BlockSimpleInventory
implements TickableBlockEntity {
    public int progress = 0;
    public int progressMax = 0;
    public boolean isSummoning = false;

    public AbstractAltarBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void startSummoning() {
        this.isSummoning = true;
        this.progress = 0;
    }

    public boolean canSummon(Level level) {
        LivingEntity boss = this.getBoss(level);
        if (boss == null) {
            return false;
        }
        BlockPos pos = this.m_58899_();
        AABB region = new AABB((double)(pos.m_123341_() - 15), (double)(pos.m_123342_() - 15), (double)(pos.m_123343_() - 15), (double)(pos.m_123341_() + 15), (double)(pos.m_123342_() + 15), (double)(pos.m_123343_() + 15));
        return level.m_45976_(boss.getClass(), region).isEmpty();
    }

    public abstract LivingEntity getBoss(Level var1);

    public abstract void summonBoss(Level var1);

    public abstract void summonParticles(int var1);

    public abstract SoundEvent getSummonSound();

    public void tick() {
        int tick = 0;
        ++tick;
        if (this.isSummoning) {
            if (this.f_58857_.m_5776_()) {
                this.summonParticles(tick);
            }
            this.increaseCraftingProgress(60);
            AbstractAltarBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
            if (this.progress >= 60) {
                this.finishSummoning();
                this.resetProgress();
            }
            ValoriaUtils.SUpdateTileEntityPacket(this);
        }
    }

    private void increaseCraftingProgress(int time) {
        this.progressMax = time;
        if (this.progress < time) {
            ++this.progress;
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void finishSummoning() {
        this.isSummoning = false;
        this.progress = 0;
        if (!this.getItemHandler().m_8020_(0).m_41619_()) {
            this.getItemHandler().m_7407_(0, 1);
            Level level = this.m_58904_();
            if (level == null) {
                return;
            }
            if (level.m_5776_()) {
                for (int i = 0; i < 4; ++i) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 2.85, (double)this.f_58858_.m_123343_() + 0.5, (Math.random() - 0.5) * 0.1, Math.random() * 0.1, (Math.random() - 0.5) * 0.1);
                }
            } else {
                this.summonBoss(level);
            }
            level.m_5594_(null, this.f_58858_, this.getSummonSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public void m_183515_(CompoundTag pTag) {
        pTag.m_128405_("progress", this.progress);
        pTag.m_128405_("progressMax", this.progressMax);
        pTag.m_128379_("summoning", this.isSummoning);
        super.m_183515_(pTag);
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.progress = pTag.m_128451_("progress");
        this.progressMax = pTag.m_128451_("progressMax");
        this.isSummoning = pTag.m_128471_("summoning");
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(1){

            public int m_6893_() {
                return 1;
            }
        };
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.m_131708_());
    }

    @NotNull
    public final CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ValoriaUtils.SUpdateTileEntityPacket(this);
        }
    }
}

